/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum BuildBatchPhaseType {
    SUBMITTED("SUBMITTED"),
    DOWNLOAD_BATCHSPEC("DOWNLOAD_BATCHSPEC"),
    IN_PROGRESS("IN_PROGRESS"),
    COMBINE_ARTIFACTS("COMBINE_ARTIFACTS"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    STOPPED("STOPPED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private BuildBatchPhaseType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BuildBatchPhaseType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(BuildBatchPhaseType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BuildBatchPhaseType> knownValues() {
        return Stream.of(BuildBatchPhaseType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

