/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codeartifact.CodeartifactClient;
import software.amazon.awssdk.services.codeartifact.model.AssetSummary;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsRequest;
import software.amazon.awssdk.services.codeartifact.model.ListPackageVersionAssetsResponse;

public class ListPackageVersionAssetsIterable
implements SdkIterable<ListPackageVersionAssetsResponse> {
    private final CodeartifactClient client;
    private final ListPackageVersionAssetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPackageVersionAssetsIterable(CodeartifactClient client, ListPackageVersionAssetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListPackageVersionAssetsResponseFetcher();
    }

    public Iterator<ListPackageVersionAssetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AssetSummary> assets() {
        Function<ListPackageVersionAssetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.assets() != null) {
                return response.assets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPackageVersionAssetsResponseFetcher
    implements SyncPageFetcher<ListPackageVersionAssetsResponse> {
        private ListPackageVersionAssetsResponseFetcher() {
        }

        public boolean hasNextPage(ListPackageVersionAssetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPackageVersionAssetsResponse nextPage(ListPackageVersionAssetsResponse previousPage) {
            if (previousPage == null) {
                return ListPackageVersionAssetsIterable.this.client.listPackageVersionAssets(ListPackageVersionAssetsIterable.this.firstRequest);
            }
            return ListPackageVersionAssetsIterable.this.client.listPackageVersionAssets((ListPackageVersionAssetsRequest)((Object)ListPackageVersionAssetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

