/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeartifact.model.CodeartifactResponse;
import software.amazon.awssdk.services.codeartifact.model.PackageFormat;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionSummary;
import software.amazon.awssdk.services.codeartifact.model.PackageVersionSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPackageVersionsResponse
extends CodeartifactResponse
implements ToCopyableBuilder<Builder, ListPackageVersionsResponse> {
    private static final SdkField<String> DEFAULT_DISPLAY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultDisplayVersion").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::defaultDisplayVersion)).setter(ListPackageVersionsResponse.setter(Builder::defaultDisplayVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDisplayVersion").build()}).build();
    private static final SdkField<String> FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("format").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::formatAsString)).setter(ListPackageVersionsResponse.setter(Builder::format)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()}).build();
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("namespace").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::namespace)).setter(ListPackageVersionsResponse.setter(Builder::namespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()}).build();
    private static final SdkField<String> PACKAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("package").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::packageValue)).setter(ListPackageVersionsResponse.setter(Builder::packageValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("package").build()}).build();
    private static final SdkField<List<PackageVersionSummary>> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("versions").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::versions)).setter(ListPackageVersionsResponse.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PackageVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPackageVersionsResponse.getter(ListPackageVersionsResponse::nextToken)).setter(ListPackageVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_DISPLAY_VERSION_FIELD, FORMAT_FIELD, NAMESPACE_FIELD, PACKAGE_FIELD, VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final String defaultDisplayVersion;
    private final String format;
    private final String namespace;
    private final String packageValue;
    private final List<PackageVersionSummary> versions;
    private final String nextToken;

    private ListPackageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.defaultDisplayVersion = builder.defaultDisplayVersion;
        this.format = builder.format;
        this.namespace = builder.namespace;
        this.packageValue = builder.packageValue;
        this.versions = builder.versions;
        this.nextToken = builder.nextToken;
    }

    public final String defaultDisplayVersion() {
        return this.defaultDisplayVersion;
    }

    public final PackageFormat format() {
        return PackageFormat.fromValue(this.format);
    }

    public final String formatAsString() {
        return this.format;
    }

    public final String namespace() {
        return this.namespace;
    }

    public final String packageValue() {
        return this.packageValue;
    }

    public final boolean hasVersions() {
        return this.versions != null && !(this.versions instanceof SdkAutoConstructList);
    }

    public final List<PackageVersionSummary> versions() {
        return this.versions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDisplayVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.namespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.packageValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersions() ? this.versions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackageVersionsResponse)) {
            return false;
        }
        ListPackageVersionsResponse other = (ListPackageVersionsResponse)((Object)obj);
        return Objects.equals(this.defaultDisplayVersion(), other.defaultDisplayVersion()) && Objects.equals(this.formatAsString(), other.formatAsString()) && Objects.equals(this.namespace(), other.namespace()) && Objects.equals(this.packageValue(), other.packageValue()) && this.hasVersions() == other.hasVersions() && Objects.equals(this.versions(), other.versions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPackageVersionsResponse").add("DefaultDisplayVersion", (Object)this.defaultDisplayVersion()).add("Format", (Object)this.formatAsString()).add("Namespace", (Object)this.namespace()).add("Package", (Object)this.packageValue()).add("Versions", this.hasVersions() ? this.versions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultDisplayVersion": {
                return Optional.ofNullable(clazz.cast(this.defaultDisplayVersion()));
            }
            case "format": {
                return Optional.ofNullable(clazz.cast(this.formatAsString()));
            }
            case "namespace": {
                return Optional.ofNullable(clazz.cast(this.namespace()));
            }
            case "package": {
                return Optional.ofNullable(clazz.cast(this.packageValue()));
            }
            case "versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackageVersionsResponse, T> g) {
        return obj -> g.apply((ListPackageVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeartifactResponse.BuilderImpl
    implements Builder {
        private String defaultDisplayVersion;
        private String format;
        private String namespace;
        private String packageValue;
        private List<PackageVersionSummary> versions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackageVersionsResponse model) {
            super(model);
            this.defaultDisplayVersion(model.defaultDisplayVersion);
            this.format(model.format);
            this.namespace(model.namespace);
            this.packageValue(model.packageValue);
            this.versions(model.versions);
            this.nextToken(model.nextToken);
        }

        public final String getDefaultDisplayVersion() {
            return this.defaultDisplayVersion;
        }

        @Override
        public final Builder defaultDisplayVersion(String defaultDisplayVersion) {
            this.defaultDisplayVersion = defaultDisplayVersion;
            return this;
        }

        public final void setDefaultDisplayVersion(String defaultDisplayVersion) {
            this.defaultDisplayVersion = defaultDisplayVersion;
        }

        public final String getFormat() {
            return this.format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(PackageFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getPackageValue() {
            return this.packageValue;
        }

        @Override
        public final Builder packageValue(String packageValue) {
            this.packageValue = packageValue;
            return this;
        }

        public final void setPackageValue(String packageValue) {
            this.packageValue = packageValue;
        }

        public final List<PackageVersionSummary.Builder> getVersions() {
            List<PackageVersionSummary.Builder> result = PackageVersionSummaryListCopier.copyToBuilder(this.versions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder versions(Collection<PackageVersionSummary> versions) {
            this.versions = PackageVersionSummaryListCopier.copy(versions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(PackageVersionSummary ... versions) {
            this.versions(Arrays.asList(versions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versions(Consumer<PackageVersionSummary.Builder> ... versions) {
            this.versions(Stream.of(versions).map(c -> (PackageVersionSummary)((PackageVersionSummary.Builder)PackageVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVersions(Collection<PackageVersionSummary.BuilderImpl> versions) {
            this.versions = PackageVersionSummaryListCopier.copyFromBuilder(versions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListPackageVersionsResponse build() {
            return new ListPackageVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeartifactResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPackageVersionsResponse> {
        public Builder defaultDisplayVersion(String var1);

        public Builder format(String var1);

        public Builder format(PackageFormat var1);

        public Builder namespace(String var1);

        public Builder packageValue(String var1);

        public Builder versions(Collection<PackageVersionSummary> var1);

        public Builder versions(PackageVersionSummary ... var1);

        public Builder versions(Consumer<PackageVersionSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

