/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeartifact.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum HashAlgorithm {
    MD5("MD5"),
    SHA_1("SHA-1"),
    SHA_256("SHA-256"),
    SHA_512("SHA-512"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private HashAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static HashAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(HashAlgorithm.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<HashAlgorithm> knownValues() {
        return Stream.of(HashAlgorithm.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

