/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardValidationMessage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardValidationMessage> {
    private static final SdkField<String> DATA_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataPath").getter(DashboardValidationMessage.getter(DashboardValidationMessage::dataPath)).setter(DashboardValidationMessage.setter(Builder::dataPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPath").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(DashboardValidationMessage.getter(DashboardValidationMessage::message)).setter(DashboardValidationMessage.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_PATH_FIELD, MESSAGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dataPath;
    private final String message;

    private DashboardValidationMessage(BuilderImpl builder) {
        this.dataPath = builder.dataPath;
        this.message = builder.message;
    }

    public final String dataPath() {
        return this.dataPath;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardValidationMessage)) {
            return false;
        }
        DashboardValidationMessage other = (DashboardValidationMessage)obj;
        return Objects.equals(this.dataPath(), other.dataPath()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardValidationMessage").add("DataPath", (Object)this.dataPath()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataPath": {
                return Optional.ofNullable(clazz.cast(this.dataPath()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardValidationMessage, T> g) {
        return obj -> g.apply((DashboardValidationMessage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataPath;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardValidationMessage model) {
            this.dataPath(model.dataPath);
            this.message(model.message);
        }

        public final String getDataPath() {
            return this.dataPath;
        }

        @Override
        public final Builder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public final void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public DashboardValidationMessage build() {
            return new DashboardValidationMessage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardValidationMessage> {
        public Builder dataPath(String var1);

        public Builder message(String var1);
    }
}

