/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterFuzzyMatching;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DocumentSuggesterOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DocumentSuggesterOptions> {
    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceField").getter(DocumentSuggesterOptions.getter(DocumentSuggesterOptions::sourceField)).setter(DocumentSuggesterOptions.setter(Builder::sourceField)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()}).build();
    private static final SdkField<String> FUZZY_MATCHING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FuzzyMatching").getter(DocumentSuggesterOptions.getter(DocumentSuggesterOptions::fuzzyMatchingAsString)).setter(DocumentSuggesterOptions.setter(Builder::fuzzyMatching)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FuzzyMatching").build()}).build();
    private static final SdkField<String> SORT_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortExpression").getter(DocumentSuggesterOptions.getter(DocumentSuggesterOptions::sortExpression)).setter(DocumentSuggesterOptions.setter(Builder::sortExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortExpression").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_FIELD_FIELD, FUZZY_MATCHING_FIELD, SORT_EXPRESSION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String sourceField;
    private final String fuzzyMatching;
    private final String sortExpression;

    private DocumentSuggesterOptions(BuilderImpl builder) {
        this.sourceField = builder.sourceField;
        this.fuzzyMatching = builder.fuzzyMatching;
        this.sortExpression = builder.sortExpression;
    }

    public final String sourceField() {
        return this.sourceField;
    }

    public final SuggesterFuzzyMatching fuzzyMatching() {
        return SuggesterFuzzyMatching.fromValue(this.fuzzyMatching);
    }

    public final String fuzzyMatchingAsString() {
        return this.fuzzyMatching;
    }

    public final String sortExpression() {
        return this.sortExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.fuzzyMatchingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortExpression());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSuggesterOptions)) {
            return false;
        }
        DocumentSuggesterOptions other = (DocumentSuggesterOptions)obj;
        return Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.fuzzyMatchingAsString(), other.fuzzyMatchingAsString()) && Objects.equals(this.sortExpression(), other.sortExpression());
    }

    public final String toString() {
        return ToString.builder((String)"DocumentSuggesterOptions").add("SourceField", (Object)this.sourceField()).add("FuzzyMatching", (Object)this.fuzzyMatchingAsString()).add("SortExpression", (Object)this.sortExpression()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceField": {
                return Optional.ofNullable(clazz.cast(this.sourceField()));
            }
            case "FuzzyMatching": {
                return Optional.ofNullable(clazz.cast(this.fuzzyMatchingAsString()));
            }
            case "SortExpression": {
                return Optional.ofNullable(clazz.cast(this.sortExpression()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentSuggesterOptions, T> g) {
        return obj -> g.apply((DocumentSuggesterOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceField;
        private String fuzzyMatching;
        private String sortExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSuggesterOptions model) {
            this.sourceField(model.sourceField);
            this.fuzzyMatching(model.fuzzyMatching);
            this.sortExpression(model.sortExpression);
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final String getFuzzyMatching() {
            return this.fuzzyMatching;
        }

        @Override
        public final Builder fuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
            return this;
        }

        @Override
        public final Builder fuzzyMatching(SuggesterFuzzyMatching fuzzyMatching) {
            this.fuzzyMatching(fuzzyMatching == null ? null : fuzzyMatching.toString());
            return this;
        }

        public final void setFuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
        }

        public final String getSortExpression() {
            return this.sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        public DocumentSuggesterOptions build() {
            return new DocumentSuggesterOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DocumentSuggesterOptions> {
        public Builder sourceField(String var1);

        public Builder fuzzyMatching(String var1);

        public Builder fuzzyMatching(SuggesterFuzzyMatching var1);

        public Builder sortExpression(String var1);
    }
}

