/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.CloudDirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSchemaAsJsonResponse
extends CloudDirectoryResponse
implements ToCopyableBuilder<Builder, GetSchemaAsJsonResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetSchemaAsJsonResponse.getter(GetSchemaAsJsonResponse::name)).setter(GetSchemaAsJsonResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Document").getter(GetSchemaAsJsonResponse.getter(GetSchemaAsJsonResponse::document)).setter(GetSchemaAsJsonResponse.setter(Builder::document)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Document").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DOCUMENT_FIELD));
    private final String name;
    private final String document;

    private GetSchemaAsJsonResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.document = builder.document;
    }

    public final String name() {
        return this.name;
    }

    public final String document() {
        return this.document;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.document());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSchemaAsJsonResponse)) {
            return false;
        }
        GetSchemaAsJsonResponse other = (GetSchemaAsJsonResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.document(), other.document());
    }

    public final String toString() {
        return ToString.builder((String)"GetSchemaAsJsonResponse").add("Name", (Object)this.name()).add("Document", (Object)this.document()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Document": {
                return Optional.ofNullable(clazz.cast(this.document()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSchemaAsJsonResponse, T> g) {
        return obj -> g.apply((GetSchemaAsJsonResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudDirectoryResponse.BuilderImpl
    implements Builder {
        private String name;
        private String document;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSchemaAsJsonResponse model) {
            super(model);
            this.name(model.name);
            this.document(model.document);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocument() {
            return this.document;
        }

        @Override
        public final Builder document(String document) {
            this.document = document;
            return this;
        }

        public final void setDocument(String document) {
            this.document = document;
        }

        @Override
        public GetSchemaAsJsonResponse build() {
            return new GetSchemaAsJsonResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudDirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSchemaAsJsonResponse> {
        public Builder name(String var1);

        public Builder document(String var1);
    }
}

