/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.clouddirectory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeDefinition;
import software.amazon.awssdk.services.clouddirectory.model.FacetAttributeReference;
import software.amazon.awssdk.services.clouddirectory.model.RequiredAttributeBehavior;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FacetAttribute
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FacetAttribute> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(FacetAttribute.getter(FacetAttribute::name)).setter(FacetAttribute.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<FacetAttributeDefinition> ATTRIBUTE_DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeDefinition").getter(FacetAttribute.getter(FacetAttribute::attributeDefinition)).setter(FacetAttribute.setter(Builder::attributeDefinition)).constructor(FacetAttributeDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeDefinition").build()}).build();
    private static final SdkField<FacetAttributeReference> ATTRIBUTE_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AttributeReference").getter(FacetAttribute.getter(FacetAttribute::attributeReference)).setter(FacetAttribute.setter(Builder::attributeReference)).constructor(FacetAttributeReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributeReference").build()}).build();
    private static final SdkField<String> REQUIRED_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RequiredBehavior").getter(FacetAttribute.getter(FacetAttribute::requiredBehaviorAsString)).setter(FacetAttribute.setter(Builder::requiredBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ATTRIBUTE_DEFINITION_FIELD, ATTRIBUTE_REFERENCE_FIELD, REQUIRED_BEHAVIOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final FacetAttributeDefinition attributeDefinition;
    private final FacetAttributeReference attributeReference;
    private final String requiredBehavior;

    private FacetAttribute(BuilderImpl builder) {
        this.name = builder.name;
        this.attributeDefinition = builder.attributeDefinition;
        this.attributeReference = builder.attributeReference;
        this.requiredBehavior = builder.requiredBehavior;
    }

    public final String name() {
        return this.name;
    }

    public final FacetAttributeDefinition attributeDefinition() {
        return this.attributeDefinition;
    }

    public final FacetAttributeReference attributeReference() {
        return this.attributeReference;
    }

    public final RequiredAttributeBehavior requiredBehavior() {
        return RequiredAttributeBehavior.fromValue(this.requiredBehavior);
    }

    public final String requiredBehaviorAsString() {
        return this.requiredBehavior;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeDefinition());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.requiredBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FacetAttribute)) {
            return false;
        }
        FacetAttribute other = (FacetAttribute)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.attributeDefinition(), other.attributeDefinition()) && Objects.equals(this.attributeReference(), other.attributeReference()) && Objects.equals(this.requiredBehaviorAsString(), other.requiredBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"FacetAttribute").add("Name", (Object)this.name()).add("AttributeDefinition", (Object)this.attributeDefinition()).add("AttributeReference", (Object)this.attributeReference()).add("RequiredBehavior", (Object)this.requiredBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "AttributeDefinition": {
                return Optional.ofNullable(clazz.cast(this.attributeDefinition()));
            }
            case "AttributeReference": {
                return Optional.ofNullable(clazz.cast(this.attributeReference()));
            }
            case "RequiredBehavior": {
                return Optional.ofNullable(clazz.cast(this.requiredBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FacetAttribute, T> g) {
        return obj -> g.apply((FacetAttribute)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private FacetAttributeDefinition attributeDefinition;
        private FacetAttributeReference attributeReference;
        private String requiredBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(FacetAttribute model) {
            this.name(model.name);
            this.attributeDefinition(model.attributeDefinition);
            this.attributeReference(model.attributeReference);
            this.requiredBehavior(model.requiredBehavior);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final FacetAttributeDefinition.Builder getAttributeDefinition() {
            return this.attributeDefinition != null ? this.attributeDefinition.toBuilder() : null;
        }

        @Override
        public final Builder attributeDefinition(FacetAttributeDefinition attributeDefinition) {
            this.attributeDefinition = attributeDefinition;
            return this;
        }

        public final void setAttributeDefinition(FacetAttributeDefinition.BuilderImpl attributeDefinition) {
            this.attributeDefinition = attributeDefinition != null ? attributeDefinition.build() : null;
        }

        public final FacetAttributeReference.Builder getAttributeReference() {
            return this.attributeReference != null ? this.attributeReference.toBuilder() : null;
        }

        @Override
        public final Builder attributeReference(FacetAttributeReference attributeReference) {
            this.attributeReference = attributeReference;
            return this;
        }

        public final void setAttributeReference(FacetAttributeReference.BuilderImpl attributeReference) {
            this.attributeReference = attributeReference != null ? attributeReference.build() : null;
        }

        public final String getRequiredBehavior() {
            return this.requiredBehavior;
        }

        @Override
        public final Builder requiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
            return this;
        }

        @Override
        public final Builder requiredBehavior(RequiredAttributeBehavior requiredBehavior) {
            this.requiredBehavior(requiredBehavior == null ? null : requiredBehavior.toString());
            return this;
        }

        public final void setRequiredBehavior(String requiredBehavior) {
            this.requiredBehavior = requiredBehavior;
        }

        public FacetAttribute build() {
            return new FacetAttribute(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FacetAttribute> {
        public Builder name(String var1);

        public Builder attributeDefinition(FacetAttributeDefinition var1);

        default public Builder attributeDefinition(Consumer<FacetAttributeDefinition.Builder> attributeDefinition) {
            return this.attributeDefinition((FacetAttributeDefinition)((FacetAttributeDefinition.Builder)FacetAttributeDefinition.builder().applyMutation(attributeDefinition)).build());
        }

        public Builder attributeReference(FacetAttributeReference var1);

        default public Builder attributeReference(Consumer<FacetAttributeReference.Builder> attributeReference) {
            return this.attributeReference((FacetAttributeReference)((FacetAttributeReference.Builder)FacetAttributeReference.builder().applyMutation(attributeReference)).build());
        }

        public Builder requiredBehavior(String var1);

        public Builder requiredBehavior(RequiredAttributeBehavior var1);
    }
}

