/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsRequest;
import software.amazon.awssdk.services.chime.model.ListVoiceConnectorGroupsResponse;

public class ListVoiceConnectorGroupsPublisher
implements SdkPublisher<ListVoiceConnectorGroupsResponse> {
    private final ChimeAsyncClient client;
    private final ListVoiceConnectorGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVoiceConnectorGroupsPublisher(ChimeAsyncClient client, ListVoiceConnectorGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVoiceConnectorGroupsPublisher(ChimeAsyncClient client, ListVoiceConnectorGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVoiceConnectorGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVoiceConnectorGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListVoiceConnectorGroupsResponseFetcher
    implements AsyncPageFetcher<ListVoiceConnectorGroupsResponse> {
        private ListVoiceConnectorGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListVoiceConnectorGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVoiceConnectorGroupsResponse> nextPage(ListVoiceConnectorGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListVoiceConnectorGroupsPublisher.this.client.listVoiceConnectorGroups(ListVoiceConnectorGroupsPublisher.this.firstRequest);
            }
            return ListVoiceConnectorGroupsPublisher.this.client.listVoiceConnectorGroups((ListVoiceConnectorGroupsRequest)((Object)ListVoiceConnectorGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

