/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.chime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.chime.ChimeAsyncClient;
import software.amazon.awssdk.services.chime.model.ListUsersRequest;
import software.amazon.awssdk.services.chime.model.ListUsersResponse;

public class ListUsersPublisher
implements SdkPublisher<ListUsersResponse> {
    private final ChimeAsyncClient client;
    private final ListUsersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListUsersPublisher(ChimeAsyncClient client, ListUsersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListUsersPublisher(ChimeAsyncClient client, ListUsersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListUsersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListUsersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListUsersResponseFetcher
    implements AsyncPageFetcher<ListUsersResponse> {
        private ListUsersResponseFetcher() {
        }

        public boolean hasNextPage(ListUsersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListUsersResponse> nextPage(ListUsersResponse previousPage) {
            if (previousPage == null) {
                return ListUsersPublisher.this.client.listUsers(ListUsersPublisher.this.firstRequest);
            }
            return ListUsersPublisher.this.client.listUsers((ListUsersRequest)((Object)ListUsersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

