/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.budgets.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.budgets.BudgetsAsyncClient;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetRequest;
import software.amazon.awssdk.services.budgets.model.DescribeNotificationsForBudgetResponse;
import software.amazon.awssdk.services.budgets.model.Notification;

public class DescribeNotificationsForBudgetPublisher
implements SdkPublisher<DescribeNotificationsForBudgetResponse> {
    private final BudgetsAsyncClient client;
    private final DescribeNotificationsForBudgetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeNotificationsForBudgetPublisher(BudgetsAsyncClient client, DescribeNotificationsForBudgetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeNotificationsForBudgetPublisher(BudgetsAsyncClient client, DescribeNotificationsForBudgetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeNotificationsForBudgetResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeNotificationsForBudgetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Notification> notifications() {
        Function<DescribeNotificationsForBudgetResponse, Iterator> getIterator = response -> {
            if (response != null && response.notifications() != null) {
                return response.notifications().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeNotificationsForBudgetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeNotificationsForBudgetResponseFetcher
    implements AsyncPageFetcher<DescribeNotificationsForBudgetResponse> {
        private DescribeNotificationsForBudgetResponseFetcher() {
        }

        public boolean hasNextPage(DescribeNotificationsForBudgetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeNotificationsForBudgetResponse> nextPage(DescribeNotificationsForBudgetResponse previousPage) {
            if (previousPage == null) {
                return DescribeNotificationsForBudgetPublisher.this.client.describeNotificationsForBudget(DescribeNotificationsForBudgetPublisher.this.firstRequest);
            }
            return DescribeNotificationsForBudgetPublisher.this.client.describeNotificationsForBudget((DescribeNotificationsForBudgetRequest)((Object)DescribeNotificationsForBudgetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

