/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.autoscaling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateOverrides;
import software.amazon.awssdk.services.autoscaling.model.LaunchTemplateSpecification;
import software.amazon.awssdk.services.autoscaling.model.OverridesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplate> {
    private static final SdkField<LaunchTemplateSpecification> LAUNCH_TEMPLATE_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplateSpecification").getter(LaunchTemplate.getter(LaunchTemplate::launchTemplateSpecification)).setter(LaunchTemplate.setter(Builder::launchTemplateSpecification)).constructor(LaunchTemplateSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplateSpecification").build()}).build();
    private static final SdkField<List<LaunchTemplateOverrides>> OVERRIDES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Overrides").getter(LaunchTemplate.getter(LaunchTemplate::overrides)).setter(LaunchTemplate.setter(Builder::overrides)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overrides").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LaunchTemplateOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_TEMPLATE_SPECIFICATION_FIELD, OVERRIDES_FIELD));
    private static final long serialVersionUID = 1L;
    private final LaunchTemplateSpecification launchTemplateSpecification;
    private final List<LaunchTemplateOverrides> overrides;

    private LaunchTemplate(BuilderImpl builder) {
        this.launchTemplateSpecification = builder.launchTemplateSpecification;
        this.overrides = builder.overrides;
    }

    public final LaunchTemplateSpecification launchTemplateSpecification() {
        return this.launchTemplateSpecification;
    }

    public final boolean hasOverrides() {
        return this.overrides != null && !(this.overrides instanceof SdkAutoConstructList);
    }

    public final List<LaunchTemplateOverrides> overrides() {
        return this.overrides;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplateSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverrides() ? this.overrides() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplate)) {
            return false;
        }
        LaunchTemplate other = (LaunchTemplate)obj;
        return Objects.equals(this.launchTemplateSpecification(), other.launchTemplateSpecification()) && this.hasOverrides() == other.hasOverrides() && Objects.equals(this.overrides(), other.overrides());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplate").add("LaunchTemplateSpecification", (Object)this.launchTemplateSpecification()).add("Overrides", this.hasOverrides() ? this.overrides() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LaunchTemplateSpecification": {
                return Optional.ofNullable(clazz.cast(this.launchTemplateSpecification()));
            }
            case "Overrides": {
                return Optional.ofNullable(clazz.cast(this.overrides()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplate, T> g) {
        return obj -> g.apply((LaunchTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private LaunchTemplateSpecification launchTemplateSpecification;
        private List<LaunchTemplateOverrides> overrides = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplate model) {
            this.launchTemplateSpecification(model.launchTemplateSpecification);
            this.overrides(model.overrides);
        }

        public final LaunchTemplateSpecification.Builder getLaunchTemplateSpecification() {
            return this.launchTemplateSpecification != null ? this.launchTemplateSpecification.toBuilder() : null;
        }

        @Override
        public final Builder launchTemplateSpecification(LaunchTemplateSpecification launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification;
            return this;
        }

        public final void setLaunchTemplateSpecification(LaunchTemplateSpecification.BuilderImpl launchTemplateSpecification) {
            this.launchTemplateSpecification = launchTemplateSpecification != null ? launchTemplateSpecification.build() : null;
        }

        public final List<LaunchTemplateOverrides.Builder> getOverrides() {
            List<LaunchTemplateOverrides.Builder> result = OverridesCopier.copyToBuilder(this.overrides);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder overrides(Collection<LaunchTemplateOverrides> overrides) {
            this.overrides = OverridesCopier.copy(overrides);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(LaunchTemplateOverrides ... overrides) {
            this.overrides(Arrays.asList(overrides));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder overrides(Consumer<LaunchTemplateOverrides.Builder> ... overrides) {
            this.overrides(Stream.of(overrides).map(c -> (LaunchTemplateOverrides)((LaunchTemplateOverrides.Builder)LaunchTemplateOverrides.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOverrides(Collection<LaunchTemplateOverrides.BuilderImpl> overrides) {
            this.overrides = OverridesCopier.copyFromBuilder(overrides);
        }

        public LaunchTemplate build() {
            return new LaunchTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplate> {
        public Builder launchTemplateSpecification(LaunchTemplateSpecification var1);

        default public Builder launchTemplateSpecification(Consumer<LaunchTemplateSpecification.Builder> launchTemplateSpecification) {
            return this.launchTemplateSpecification((LaunchTemplateSpecification)((LaunchTemplateSpecification.Builder)LaunchTemplateSpecification.builder().applyMutation(launchTemplateSpecification)).build());
        }

        public Builder overrides(Collection<LaunchTemplateOverrides> var1);

        public Builder overrides(LaunchTemplateOverrides ... var1);

        public Builder overrides(Consumer<LaunchTemplateOverrides.Builder> ... var1);
    }
}

