/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.athena.model.EncryptionOption;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EncryptionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EncryptionConfiguration> {
    private static final SdkField<String> ENCRYPTION_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionOption").getter(EncryptionConfiguration.getter(EncryptionConfiguration::encryptionOptionAsString)).setter(EncryptionConfiguration.setter(Builder::encryptionOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionOption").build()}).build();
    private static final SdkField<String> KMS_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKey").getter(EncryptionConfiguration.getter(EncryptionConfiguration::kmsKey)).setter(EncryptionConfiguration.setter(Builder::kmsKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKey").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_OPTION_FIELD, KMS_KEY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String encryptionOption;
    private final String kmsKey;

    private EncryptionConfiguration(BuilderImpl builder) {
        this.encryptionOption = builder.encryptionOption;
        this.kmsKey = builder.kmsKey;
    }

    public final EncryptionOption encryptionOption() {
        return EncryptionOption.fromValue(this.encryptionOption);
    }

    public final String encryptionOptionAsString() {
        return this.encryptionOption;
    }

    public final String kmsKey() {
        return this.kmsKey;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionOptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKey());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EncryptionConfiguration)) {
            return false;
        }
        EncryptionConfiguration other = (EncryptionConfiguration)obj;
        return Objects.equals(this.encryptionOptionAsString(), other.encryptionOptionAsString()) && Objects.equals(this.kmsKey(), other.kmsKey());
    }

    public final String toString() {
        return ToString.builder((String)"EncryptionConfiguration").add("EncryptionOption", (Object)this.encryptionOptionAsString()).add("KmsKey", (Object)this.kmsKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EncryptionOption": {
                return Optional.ofNullable(clazz.cast(this.encryptionOptionAsString()));
            }
            case "KmsKey": {
                return Optional.ofNullable(clazz.cast(this.kmsKey()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EncryptionConfiguration, T> g) {
        return obj -> g.apply((EncryptionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String encryptionOption;
        private String kmsKey;

        private BuilderImpl() {
        }

        private BuilderImpl(EncryptionConfiguration model) {
            this.encryptionOption(model.encryptionOption);
            this.kmsKey(model.kmsKey);
        }

        public final String getEncryptionOption() {
            return this.encryptionOption;
        }

        @Override
        public final Builder encryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
            return this;
        }

        @Override
        public final Builder encryptionOption(EncryptionOption encryptionOption) {
            this.encryptionOption(encryptionOption == null ? null : encryptionOption.toString());
            return this;
        }

        public final void setEncryptionOption(String encryptionOption) {
            this.encryptionOption = encryptionOption;
        }

        public final String getKmsKey() {
            return this.kmsKey;
        }

        @Override
        public final Builder kmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public final void setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
        }

        public EncryptionConfiguration build() {
            return new EncryptionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EncryptionConfiguration> {
        public Builder encryptionOption(String var1);

        public Builder encryptionOption(EncryptionOption var1);

        public Builder kmsKey(String var1);
    }
}

