/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ConflictHandlerType {
    OPTIMISTIC_CONCURRENCY("OPTIMISTIC_CONCURRENCY"),
    LAMBDA("LAMBDA"),
    AUTOMERGE("AUTOMERGE"),
    NONE("NONE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ConflictHandlerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConflictHandlerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ConflictHandlerType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConflictHandlerType> knownValues() {
        return Stream.of(ConflictHandlerType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

