/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apigatewayv2.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ProtocolType {
    WEBSOCKET("WEBSOCKET"),
    HTTP("HTTP"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ProtocolType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ProtocolType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ProtocolType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ProtocolType> knownValues() {
        return Stream.of(ProtocolType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

