/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeliveryMethod {
    EMAIL("EMAIL"),
    SMS("SMS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeliveryMethod(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryMethod fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeliveryMethod.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryMethod> knownValues() {
        return Stream.of(DeliveryMethod.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

