/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.amplifybackend.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthForgotPasswordConfig;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthMFAConfig;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthOAuthConfig;
import software.amazon.awssdk.services.amplifybackend.model.CreateBackendAuthPasswordPolicyConfig;
import software.amazon.awssdk.services.amplifybackend.model.ListOfRequiredSignUpAttributesElementCopier;
import software.amazon.awssdk.services.amplifybackend.model.RequiredSignUpAttributesElement;
import software.amazon.awssdk.services.amplifybackend.model.SignInMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBackendAuthUserPoolConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CreateBackendAuthUserPoolConfig> {
    private static final SdkField<CreateBackendAuthForgotPasswordConfig> FORGOT_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ForgotPassword").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::forgotPassword)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::forgotPassword)).constructor(CreateBackendAuthForgotPasswordConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forgotPassword").build()}).build();
    private static final SdkField<CreateBackendAuthMFAConfig> MFA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Mfa").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::mfa)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::mfa)).constructor(CreateBackendAuthMFAConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mfa").build()}).build();
    private static final SdkField<CreateBackendAuthOAuthConfig> O_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OAuth").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::oAuth)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::oAuth)).constructor(CreateBackendAuthOAuthConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("oAuth").build()}).build();
    private static final SdkField<CreateBackendAuthPasswordPolicyConfig> PASSWORD_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PasswordPolicy").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::passwordPolicy)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::passwordPolicy)).constructor(CreateBackendAuthPasswordPolicyConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("passwordPolicy").build()}).build();
    private static final SdkField<List<String>> REQUIRED_SIGN_UP_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredSignUpAttributes").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::requiredSignUpAttributesAsStrings)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::requiredSignUpAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requiredSignUpAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SIGN_IN_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SignInMethod").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::signInMethodAsString)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::signInMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signInMethod").build()}).build();
    private static final SdkField<String> USER_POOL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserPoolName").getter(CreateBackendAuthUserPoolConfig.getter(CreateBackendAuthUserPoolConfig::userPoolName)).setter(CreateBackendAuthUserPoolConfig.setter(Builder::userPoolName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORGOT_PASSWORD_FIELD, MFA_FIELD, O_AUTH_FIELD, PASSWORD_POLICY_FIELD, REQUIRED_SIGN_UP_ATTRIBUTES_FIELD, SIGN_IN_METHOD_FIELD, USER_POOL_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final CreateBackendAuthForgotPasswordConfig forgotPassword;
    private final CreateBackendAuthMFAConfig mfa;
    private final CreateBackendAuthOAuthConfig oAuth;
    private final CreateBackendAuthPasswordPolicyConfig passwordPolicy;
    private final List<String> requiredSignUpAttributes;
    private final String signInMethod;
    private final String userPoolName;

    private CreateBackendAuthUserPoolConfig(BuilderImpl builder) {
        this.forgotPassword = builder.forgotPassword;
        this.mfa = builder.mfa;
        this.oAuth = builder.oAuth;
        this.passwordPolicy = builder.passwordPolicy;
        this.requiredSignUpAttributes = builder.requiredSignUpAttributes;
        this.signInMethod = builder.signInMethod;
        this.userPoolName = builder.userPoolName;
    }

    public final CreateBackendAuthForgotPasswordConfig forgotPassword() {
        return this.forgotPassword;
    }

    public final CreateBackendAuthMFAConfig mfa() {
        return this.mfa;
    }

    public final CreateBackendAuthOAuthConfig oAuth() {
        return this.oAuth;
    }

    public final CreateBackendAuthPasswordPolicyConfig passwordPolicy() {
        return this.passwordPolicy;
    }

    public final List<RequiredSignUpAttributesElement> requiredSignUpAttributes() {
        return ListOfRequiredSignUpAttributesElementCopier.copyStringToEnum(this.requiredSignUpAttributes);
    }

    public final boolean hasRequiredSignUpAttributes() {
        return this.requiredSignUpAttributes != null && !(this.requiredSignUpAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> requiredSignUpAttributesAsStrings() {
        return this.requiredSignUpAttributes;
    }

    public final SignInMethod signInMethod() {
        return SignInMethod.fromValue(this.signInMethod);
    }

    public final String signInMethodAsString() {
        return this.signInMethod;
    }

    public final String userPoolName() {
        return this.userPoolName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.forgotPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.mfa());
        hashCode = 31 * hashCode + Objects.hashCode(this.oAuth());
        hashCode = 31 * hashCode + Objects.hashCode(this.passwordPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequiredSignUpAttributes() ? this.requiredSignUpAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.signInMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.userPoolName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackendAuthUserPoolConfig)) {
            return false;
        }
        CreateBackendAuthUserPoolConfig other = (CreateBackendAuthUserPoolConfig)obj;
        return Objects.equals(this.forgotPassword(), other.forgotPassword()) && Objects.equals(this.mfa(), other.mfa()) && Objects.equals(this.oAuth(), other.oAuth()) && Objects.equals(this.passwordPolicy(), other.passwordPolicy()) && this.hasRequiredSignUpAttributes() == other.hasRequiredSignUpAttributes() && Objects.equals(this.requiredSignUpAttributesAsStrings(), other.requiredSignUpAttributesAsStrings()) && Objects.equals(this.signInMethodAsString(), other.signInMethodAsString()) && Objects.equals(this.userPoolName(), other.userPoolName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBackendAuthUserPoolConfig").add("ForgotPassword", (Object)this.forgotPassword()).add("Mfa", (Object)this.mfa()).add("OAuth", (Object)this.oAuth()).add("PasswordPolicy", (Object)this.passwordPolicy()).add("RequiredSignUpAttributes", this.hasRequiredSignUpAttributes() ? this.requiredSignUpAttributesAsStrings() : null).add("SignInMethod", (Object)this.signInMethodAsString()).add("UserPoolName", (Object)this.userPoolName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ForgotPassword": {
                return Optional.ofNullable(clazz.cast(this.forgotPassword()));
            }
            case "Mfa": {
                return Optional.ofNullable(clazz.cast(this.mfa()));
            }
            case "OAuth": {
                return Optional.ofNullable(clazz.cast(this.oAuth()));
            }
            case "PasswordPolicy": {
                return Optional.ofNullable(clazz.cast(this.passwordPolicy()));
            }
            case "RequiredSignUpAttributes": {
                return Optional.ofNullable(clazz.cast(this.requiredSignUpAttributesAsStrings()));
            }
            case "SignInMethod": {
                return Optional.ofNullable(clazz.cast(this.signInMethodAsString()));
            }
            case "UserPoolName": {
                return Optional.ofNullable(clazz.cast(this.userPoolName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBackendAuthUserPoolConfig, T> g) {
        return obj -> g.apply((CreateBackendAuthUserPoolConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private CreateBackendAuthForgotPasswordConfig forgotPassword;
        private CreateBackendAuthMFAConfig mfa;
        private CreateBackendAuthOAuthConfig oAuth;
        private CreateBackendAuthPasswordPolicyConfig passwordPolicy;
        private List<String> requiredSignUpAttributes = DefaultSdkAutoConstructList.getInstance();
        private String signInMethod;
        private String userPoolName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackendAuthUserPoolConfig model) {
            this.forgotPassword(model.forgotPassword);
            this.mfa(model.mfa);
            this.oAuth(model.oAuth);
            this.passwordPolicy(model.passwordPolicy);
            this.requiredSignUpAttributesWithStrings(model.requiredSignUpAttributes);
            this.signInMethod(model.signInMethod);
            this.userPoolName(model.userPoolName);
        }

        public final CreateBackendAuthForgotPasswordConfig.Builder getForgotPassword() {
            return this.forgotPassword != null ? this.forgotPassword.toBuilder() : null;
        }

        @Override
        public final Builder forgotPassword(CreateBackendAuthForgotPasswordConfig forgotPassword) {
            this.forgotPassword = forgotPassword;
            return this;
        }

        public final void setForgotPassword(CreateBackendAuthForgotPasswordConfig.BuilderImpl forgotPassword) {
            this.forgotPassword = forgotPassword != null ? forgotPassword.build() : null;
        }

        public final CreateBackendAuthMFAConfig.Builder getMfa() {
            return this.mfa != null ? this.mfa.toBuilder() : null;
        }

        @Override
        public final Builder mfa(CreateBackendAuthMFAConfig mfa) {
            this.mfa = mfa;
            return this;
        }

        public final void setMfa(CreateBackendAuthMFAConfig.BuilderImpl mfa) {
            this.mfa = mfa != null ? mfa.build() : null;
        }

        public final CreateBackendAuthOAuthConfig.Builder getOAuth() {
            return this.oAuth != null ? this.oAuth.toBuilder() : null;
        }

        @Override
        public final Builder oAuth(CreateBackendAuthOAuthConfig oAuth) {
            this.oAuth = oAuth;
            return this;
        }

        public final void setOAuth(CreateBackendAuthOAuthConfig.BuilderImpl oAuth) {
            this.oAuth = oAuth != null ? oAuth.build() : null;
        }

        public final CreateBackendAuthPasswordPolicyConfig.Builder getPasswordPolicy() {
            return this.passwordPolicy != null ? this.passwordPolicy.toBuilder() : null;
        }

        @Override
        public final Builder passwordPolicy(CreateBackendAuthPasswordPolicyConfig passwordPolicy) {
            this.passwordPolicy = passwordPolicy;
            return this;
        }

        public final void setPasswordPolicy(CreateBackendAuthPasswordPolicyConfig.BuilderImpl passwordPolicy) {
            this.passwordPolicy = passwordPolicy != null ? passwordPolicy.build() : null;
        }

        public final Collection<String> getRequiredSignUpAttributes() {
            if (this.requiredSignUpAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredSignUpAttributes;
        }

        @Override
        public final Builder requiredSignUpAttributesWithStrings(Collection<String> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier.copy(requiredSignUpAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredSignUpAttributesWithStrings(String ... requiredSignUpAttributes) {
            this.requiredSignUpAttributesWithStrings(Arrays.asList(requiredSignUpAttributes));
            return this;
        }

        @Override
        public final Builder requiredSignUpAttributes(Collection<RequiredSignUpAttributesElement> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier.copyEnumToString(requiredSignUpAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredSignUpAttributes(RequiredSignUpAttributesElement ... requiredSignUpAttributes) {
            this.requiredSignUpAttributes(Arrays.asList(requiredSignUpAttributes));
            return this;
        }

        public final void setRequiredSignUpAttributes(Collection<String> requiredSignUpAttributes) {
            this.requiredSignUpAttributes = ListOfRequiredSignUpAttributesElementCopier.copy(requiredSignUpAttributes);
        }

        public final String getSignInMethod() {
            return this.signInMethod;
        }

        @Override
        public final Builder signInMethod(String signInMethod) {
            this.signInMethod = signInMethod;
            return this;
        }

        @Override
        public final Builder signInMethod(SignInMethod signInMethod) {
            this.signInMethod(signInMethod == null ? null : signInMethod.toString());
            return this;
        }

        public final void setSignInMethod(String signInMethod) {
            this.signInMethod = signInMethod;
        }

        public final String getUserPoolName() {
            return this.userPoolName;
        }

        @Override
        public final Builder userPoolName(String userPoolName) {
            this.userPoolName = userPoolName;
            return this;
        }

        public final void setUserPoolName(String userPoolName) {
            this.userPoolName = userPoolName;
        }

        public CreateBackendAuthUserPoolConfig build() {
            return new CreateBackendAuthUserPoolConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CreateBackendAuthUserPoolConfig> {
        public Builder forgotPassword(CreateBackendAuthForgotPasswordConfig var1);

        default public Builder forgotPassword(Consumer<CreateBackendAuthForgotPasswordConfig.Builder> forgotPassword) {
            return this.forgotPassword((CreateBackendAuthForgotPasswordConfig)((CreateBackendAuthForgotPasswordConfig.Builder)CreateBackendAuthForgotPasswordConfig.builder().applyMutation(forgotPassword)).build());
        }

        public Builder mfa(CreateBackendAuthMFAConfig var1);

        default public Builder mfa(Consumer<CreateBackendAuthMFAConfig.Builder> mfa) {
            return this.mfa((CreateBackendAuthMFAConfig)((CreateBackendAuthMFAConfig.Builder)CreateBackendAuthMFAConfig.builder().applyMutation(mfa)).build());
        }

        public Builder oAuth(CreateBackendAuthOAuthConfig var1);

        default public Builder oAuth(Consumer<CreateBackendAuthOAuthConfig.Builder> oAuth) {
            return this.oAuth((CreateBackendAuthOAuthConfig)((CreateBackendAuthOAuthConfig.Builder)CreateBackendAuthOAuthConfig.builder().applyMutation(oAuth)).build());
        }

        public Builder passwordPolicy(CreateBackendAuthPasswordPolicyConfig var1);

        default public Builder passwordPolicy(Consumer<CreateBackendAuthPasswordPolicyConfig.Builder> passwordPolicy) {
            return this.passwordPolicy((CreateBackendAuthPasswordPolicyConfig)((CreateBackendAuthPasswordPolicyConfig.Builder)CreateBackendAuthPasswordPolicyConfig.builder().applyMutation(passwordPolicy)).build());
        }

        public Builder requiredSignUpAttributesWithStrings(Collection<String> var1);

        public Builder requiredSignUpAttributesWithStrings(String ... var1);

        public Builder requiredSignUpAttributes(Collection<RequiredSignUpAttributesElement> var1);

        public Builder requiredSignUpAttributes(RequiredSignUpAttributesElement ... var1);

        public Builder signInMethod(String var1);

        public Builder signInMethod(SignInMethod var1);

        public Builder userPoolName(String var1);
    }
}

