/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.alexaforbusiness.AlexaForBusinessAsyncClient;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsRequest;
import software.amazon.awssdk.services.alexaforbusiness.model.SearchSkillGroupsResponse;

public class SearchSkillGroupsPublisher
implements SdkPublisher<SearchSkillGroupsResponse> {
    private final AlexaForBusinessAsyncClient client;
    private final SearchSkillGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchSkillGroupsPublisher(AlexaForBusinessAsyncClient client, SearchSkillGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchSkillGroupsPublisher(AlexaForBusinessAsyncClient client, SearchSkillGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchSkillGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchSkillGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchSkillGroupsResponseFetcher
    implements AsyncPageFetcher<SearchSkillGroupsResponse> {
        private SearchSkillGroupsResponseFetcher() {
        }

        public boolean hasNextPage(SearchSkillGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchSkillGroupsResponse> nextPage(SearchSkillGroupsResponse previousPage) {
            if (previousPage == null) {
                return SearchSkillGroupsPublisher.this.client.searchSkillGroups(SearchSkillGroupsPublisher.this.firstRequest);
            }
            return SearchSkillGroupsPublisher.this.client.searchSkillGroups((SearchSkillGroupsRequest)((Object)SearchSkillGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

