/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.alexaforbusiness.model.AlexaForBusinessResponse;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomData;
import software.amazon.awssdk.services.alexaforbusiness.model.RoomDataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchRoomsResponse
extends AlexaForBusinessResponse
implements ToCopyableBuilder<Builder, SearchRoomsResponse> {
    private static final SdkField<List<RoomData>> ROOMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Rooms").getter(SearchRoomsResponse.getter(SearchRoomsResponse::rooms)).setter(SearchRoomsResponse.setter(Builder::rooms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Rooms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RoomData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(SearchRoomsResponse.getter(SearchRoomsResponse::nextToken)).setter(SearchRoomsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> TOTAL_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TotalCount").getter(SearchRoomsResponse.getter(SearchRoomsResponse::totalCount)).setter(SearchRoomsResponse.setter(Builder::totalCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROOMS_FIELD, NEXT_TOKEN_FIELD, TOTAL_COUNT_FIELD));
    private final List<RoomData> rooms;
    private final String nextToken;
    private final Integer totalCount;

    private SearchRoomsResponse(BuilderImpl builder) {
        super(builder);
        this.rooms = builder.rooms;
        this.nextToken = builder.nextToken;
        this.totalCount = builder.totalCount;
    }

    public final boolean hasRooms() {
        return this.rooms != null && !(this.rooms instanceof SdkAutoConstructList);
    }

    public final List<RoomData> rooms() {
        return this.rooms;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer totalCount() {
        return this.totalCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRooms() ? this.rooms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRoomsResponse)) {
            return false;
        }
        SearchRoomsResponse other = (SearchRoomsResponse)((Object)obj);
        return this.hasRooms() == other.hasRooms() && Objects.equals(this.rooms(), other.rooms()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.totalCount(), other.totalCount());
    }

    public final String toString() {
        return ToString.builder((String)"SearchRoomsResponse").add("Rooms", this.hasRooms() ? this.rooms() : null).add("NextToken", (Object)this.nextToken()).add("TotalCount", (Object)this.totalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Rooms": {
                return Optional.ofNullable(clazz.cast(this.rooms()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TotalCount": {
                return Optional.ofNullable(clazz.cast(this.totalCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchRoomsResponse, T> g) {
        return obj -> g.apply((SearchRoomsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AlexaForBusinessResponse.BuilderImpl
    implements Builder {
        private List<RoomData> rooms = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer totalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRoomsResponse model) {
            super(model);
            this.rooms(model.rooms);
            this.nextToken(model.nextToken);
            this.totalCount(model.totalCount);
        }

        public final List<RoomData.Builder> getRooms() {
            List<RoomData.Builder> result = RoomDataListCopier.copyToBuilder(this.rooms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rooms(Collection<RoomData> rooms) {
            this.rooms = RoomDataListCopier.copy(rooms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(RoomData ... rooms) {
            this.rooms(Arrays.asList(rooms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rooms(Consumer<RoomData.Builder> ... rooms) {
            this.rooms(Stream.of(rooms).map(c -> (RoomData)((RoomData.Builder)RoomData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRooms(Collection<RoomData.BuilderImpl> rooms) {
            this.rooms = RoomDataListCopier.copyFromBuilder(rooms);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getTotalCount() {
            return this.totalCount;
        }

        @Override
        public final Builder totalCount(Integer totalCount) {
            this.totalCount = totalCount;
            return this;
        }

        public final void setTotalCount(Integer totalCount) {
            this.totalCount = totalCount;
        }

        @Override
        public SearchRoomsResponse build() {
            return new SearchRoomsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AlexaForBusinessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchRoomsResponse> {
        public Builder rooms(Collection<RoomData> var1);

        public Builder rooms(RoomData ... var1);

        public Builder rooms(Consumer<RoomData.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder totalCount(Integer var1);
    }
}

