/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.alexaforbusiness.model.ConferenceProviderType;
import software.amazon.awssdk.services.alexaforbusiness.model.IPDialIn;
import software.amazon.awssdk.services.alexaforbusiness.model.MeetingSetting;
import software.amazon.awssdk.services.alexaforbusiness.model.PSTNDialIn;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConferenceProvider
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConferenceProvider> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(ConferenceProvider.getter(ConferenceProvider::arn)).setter(ConferenceProvider.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(ConferenceProvider.getter(ConferenceProvider::name)).setter(ConferenceProvider.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ConferenceProvider.getter(ConferenceProvider::typeAsString)).setter(ConferenceProvider.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<IPDialIn> IP_DIAL_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IPDialIn").getter(ConferenceProvider.getter(ConferenceProvider::ipDialIn)).setter(ConferenceProvider.setter(Builder::ipDialIn)).constructor(IPDialIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IPDialIn").build()}).build();
    private static final SdkField<PSTNDialIn> PSTN_DIAL_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PSTNDialIn").getter(ConferenceProvider.getter(ConferenceProvider::pstnDialIn)).setter(ConferenceProvider.setter(Builder::pstnDialIn)).constructor(PSTNDialIn::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PSTNDialIn").build()}).build();
    private static final SdkField<MeetingSetting> MEETING_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MeetingSetting").getter(ConferenceProvider.getter(ConferenceProvider::meetingSetting)).setter(ConferenceProvider.setter(Builder::meetingSetting)).constructor(MeetingSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MeetingSetting").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, TYPE_FIELD, IP_DIAL_IN_FIELD, PSTN_DIAL_IN_FIELD, MEETING_SETTING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String type;
    private final IPDialIn ipDialIn;
    private final PSTNDialIn pstnDialIn;
    private final MeetingSetting meetingSetting;

    private ConferenceProvider(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.type = builder.type;
        this.ipDialIn = builder.ipDialIn;
        this.pstnDialIn = builder.pstnDialIn;
        this.meetingSetting = builder.meetingSetting;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final ConferenceProviderType type() {
        return ConferenceProviderType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final IPDialIn ipDialIn() {
        return this.ipDialIn;
    }

    public final PSTNDialIn pstnDialIn() {
        return this.pstnDialIn;
    }

    public final MeetingSetting meetingSetting() {
        return this.meetingSetting;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.pstnDialIn());
        hashCode = 31 * hashCode + Objects.hashCode(this.meetingSetting());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConferenceProvider)) {
            return false;
        }
        ConferenceProvider other = (ConferenceProvider)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ipDialIn(), other.ipDialIn()) && Objects.equals(this.pstnDialIn(), other.pstnDialIn()) && Objects.equals(this.meetingSetting(), other.meetingSetting());
    }

    public final String toString() {
        return ToString.builder((String)"ConferenceProvider").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("IPDialIn", (Object)this.ipDialIn()).add("PSTNDialIn", (Object)this.pstnDialIn()).add("MeetingSetting", (Object)this.meetingSetting()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "IPDialIn": {
                return Optional.ofNullable(clazz.cast(this.ipDialIn()));
            }
            case "PSTNDialIn": {
                return Optional.ofNullable(clazz.cast(this.pstnDialIn()));
            }
            case "MeetingSetting": {
                return Optional.ofNullable(clazz.cast(this.meetingSetting()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConferenceProvider, T> g) {
        return obj -> g.apply((ConferenceProvider)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String type;
        private IPDialIn ipDialIn;
        private PSTNDialIn pstnDialIn;
        private MeetingSetting meetingSetting;

        private BuilderImpl() {
        }

        private BuilderImpl(ConferenceProvider model) {
            this.arn(model.arn);
            this.name(model.name);
            this.type(model.type);
            this.ipDialIn(model.ipDialIn);
            this.pstnDialIn(model.pstnDialIn);
            this.meetingSetting(model.meetingSetting);
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ConferenceProviderType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final IPDialIn.Builder getIpDialIn() {
            return this.ipDialIn != null ? this.ipDialIn.toBuilder() : null;
        }

        @Override
        public final Builder ipDialIn(IPDialIn ipDialIn) {
            this.ipDialIn = ipDialIn;
            return this;
        }

        public final void setIpDialIn(IPDialIn.BuilderImpl ipDialIn) {
            this.ipDialIn = ipDialIn != null ? ipDialIn.build() : null;
        }

        public final PSTNDialIn.Builder getPstnDialIn() {
            return this.pstnDialIn != null ? this.pstnDialIn.toBuilder() : null;
        }

        @Override
        public final Builder pstnDialIn(PSTNDialIn pstnDialIn) {
            this.pstnDialIn = pstnDialIn;
            return this;
        }

        public final void setPstnDialIn(PSTNDialIn.BuilderImpl pstnDialIn) {
            this.pstnDialIn = pstnDialIn != null ? pstnDialIn.build() : null;
        }

        public final MeetingSetting.Builder getMeetingSetting() {
            return this.meetingSetting != null ? this.meetingSetting.toBuilder() : null;
        }

        @Override
        public final Builder meetingSetting(MeetingSetting meetingSetting) {
            this.meetingSetting = meetingSetting;
            return this;
        }

        public final void setMeetingSetting(MeetingSetting.BuilderImpl meetingSetting) {
            this.meetingSetting = meetingSetting != null ? meetingSetting.build() : null;
        }

        public ConferenceProvider build() {
            return new ConferenceProvider(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConferenceProvider> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(ConferenceProviderType var1);

        public Builder ipDialIn(IPDialIn var1);

        default public Builder ipDialIn(Consumer<IPDialIn.Builder> ipDialIn) {
            return this.ipDialIn((IPDialIn)((IPDialIn.Builder)IPDialIn.builder().applyMutation(ipDialIn)).build());
        }

        public Builder pstnDialIn(PSTNDialIn var1);

        default public Builder pstnDialIn(Consumer<PSTNDialIn.Builder> pstnDialIn) {
            return this.pstnDialIn((PSTNDialIn)((PSTNDialIn.Builder)PSTNDialIn.builder().applyMutation(pstnDialIn)).build());
        }

        public Builder meetingSetting(MeetingSetting var1);

        default public Builder meetingSetting(Consumer<MeetingSetting.Builder> meetingSetting) {
            return this.meetingSetting((MeetingSetting)((MeetingSetting.Builder)MeetingSetting.builder().applyMutation(meetingSetting)).build());
        }
    }
}

