/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.alexaforbusiness.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Category
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Category> {
    private static final SdkField<Long> CATEGORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CategoryId").getter(Category.getter(Category::categoryId)).setter(Category.setter(Builder::categoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryId").build()}).build();
    private static final SdkField<String> CATEGORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CategoryName").getter(Category.getter(Category::categoryName)).setter(Category.setter(Builder::categoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CategoryName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATEGORY_ID_FIELD, CATEGORY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long categoryId;
    private final String categoryName;

    private Category(BuilderImpl builder) {
        this.categoryId = builder.categoryId;
        this.categoryName = builder.categoryName;
    }

    public final Long categoryId() {
        return this.categoryId;
    }

    public final String categoryName() {
        return this.categoryName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Category)) {
            return false;
        }
        Category other = (Category)obj;
        return Objects.equals(this.categoryId(), other.categoryId()) && Objects.equals(this.categoryName(), other.categoryName());
    }

    public final String toString() {
        return ToString.builder((String)"Category").add("CategoryId", (Object)this.categoryId()).add("CategoryName", (Object)this.categoryName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CategoryId": {
                return Optional.ofNullable(clazz.cast(this.categoryId()));
            }
            case "CategoryName": {
                return Optional.ofNullable(clazz.cast(this.categoryName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Category, T> g) {
        return obj -> g.apply((Category)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long categoryId;
        private String categoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(Category model) {
            this.categoryId(model.categoryId);
            this.categoryName(model.categoryName);
        }

        public final Long getCategoryId() {
            return this.categoryId;
        }

        @Override
        public final Builder categoryId(Long categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public final void setCategoryId(Long categoryId) {
            this.categoryId = categoryId;
        }

        public final String getCategoryName() {
            return this.categoryName;
        }

        @Override
        public final Builder categoryName(String categoryName) {
            this.categoryName = categoryName;
            return this;
        }

        public final void setCategoryName(String categoryName) {
            this.categoryName = categoryName;
        }

        public Category build() {
            return new Category(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Category> {
        public Builder categoryId(Long var1);

        public Builder categoryName(String var1);
    }
}

