/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerAsyncClient;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzedResourceSummary;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse;

public class ListAnalyzedResourcesPublisher
implements SdkPublisher<ListAnalyzedResourcesResponse> {
    private final AccessAnalyzerAsyncClient client;
    private final ListAnalyzedResourcesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAnalyzedResourcesPublisher(AccessAnalyzerAsyncClient client, ListAnalyzedResourcesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAnalyzedResourcesPublisher(AccessAnalyzerAsyncClient client, ListAnalyzedResourcesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAnalyzedResourcesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAnalyzedResourcesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AnalyzedResourceSummary> analyzedResources() {
        Function<ListAnalyzedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.analyzedResources() != null) {
                return response.analyzedResources().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAnalyzedResourcesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAnalyzedResourcesResponseFetcher
    implements AsyncPageFetcher<ListAnalyzedResourcesResponse> {
        private ListAnalyzedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListAnalyzedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAnalyzedResourcesResponse> nextPage(ListAnalyzedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListAnalyzedResourcesPublisher.this.client.listAnalyzedResources(ListAnalyzedResourcesPublisher.this.firstRequest);
            }
            return ListAnalyzedResourcesPublisher.this.client.listAnalyzedResources((ListAnalyzedResourcesRequest)((Object)ListAnalyzedResourcesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

