/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.ActionListCopier;
import software.amazon.awssdk.services.accessanalyzer.model.FindingStatus;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceType;
import software.amazon.awssdk.services.accessanalyzer.model.SharedViaListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzedResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AnalyzedResource> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actions").getter(AnalyzedResource.getter(AnalyzedResource::actions)).setter(AnalyzedResource.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("analyzedAt").getter(AnalyzedResource.getter(AnalyzedResource::analyzedAt)).setter(AnalyzedResource.setter(Builder::analyzedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AnalyzedResource.getter(AnalyzedResource::createdAt)).setter(AnalyzedResource.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(AnalyzedResource.getter(AnalyzedResource::error)).setter(AnalyzedResource.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isPublic").getter(AnalyzedResource.getter(AnalyzedResource::isPublic)).setter(AnalyzedResource.setter(Builder::isPublic)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(AnalyzedResource.getter(AnalyzedResource::resourceArn)).setter(AnalyzedResource.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwnerAccount").getter(AnalyzedResource.getter(AnalyzedResource::resourceOwnerAccount)).setter(AnalyzedResource.setter(Builder::resourceOwnerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceType").getter(AnalyzedResource.getter(AnalyzedResource::resourceTypeAsString)).setter(AnalyzedResource.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()}).build();
    private static final SdkField<List<String>> SHARED_VIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sharedVia").getter(AnalyzedResource.getter(AnalyzedResource::sharedVia)).setter(AnalyzedResource.setter(Builder::sharedVia)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedVia").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AnalyzedResource.getter(AnalyzedResource::statusAsString)).setter(AnalyzedResource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AnalyzedResource.getter(AnalyzedResource::updatedAt)).setter(AnalyzedResource.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD, ANALYZED_AT_FIELD, CREATED_AT_FIELD, ERROR_FIELD, IS_PUBLIC_FIELD, RESOURCE_ARN_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, RESOURCE_TYPE_FIELD, SHARED_VIA_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> actions;
    private final Instant analyzedAt;
    private final Instant createdAt;
    private final String error;
    private final Boolean isPublic;
    private final String resourceArn;
    private final String resourceOwnerAccount;
    private final String resourceType;
    private final List<String> sharedVia;
    private final String status;
    private final Instant updatedAt;

    private AnalyzedResource(BuilderImpl builder) {
        this.actions = builder.actions;
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.isPublic = builder.isPublic;
        this.resourceArn = builder.resourceArn;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceType = builder.resourceType;
        this.sharedVia = builder.sharedVia;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<String> actions() {
        return this.actions;
    }

    public final Instant analyzedAt() {
        return this.analyzedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String error() {
        return this.error;
    }

    public final Boolean isPublic() {
        return this.isPublic;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceOwnerAccount() {
        return this.resourceOwnerAccount;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final boolean hasSharedVia() {
        return this.sharedVia != null && !(this.sharedVia instanceof SdkAutoConstructList);
    }

    public final List<String> sharedVia() {
        return this.sharedVia;
    }

    public final FindingStatus status() {
        return FindingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.error());
        hashCode = 31 * hashCode + Objects.hashCode(this.isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSharedVia() ? this.sharedVia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzedResource)) {
            return false;
        }
        AnalyzedResource other = (AnalyzedResource)obj;
        return this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.analyzedAt(), other.analyzedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.error(), other.error()) && Objects.equals(this.isPublic(), other.isPublic()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceOwnerAccount(), other.resourceOwnerAccount()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasSharedVia() == other.hasSharedVia() && Objects.equals(this.sharedVia(), other.sharedVia()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzedResource").add("Actions", this.hasActions() ? this.actions() : null).add("AnalyzedAt", (Object)this.analyzedAt()).add("CreatedAt", (Object)this.createdAt()).add("Error", (Object)this.error()).add("IsPublic", (Object)this.isPublic()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceOwnerAccount", (Object)this.resourceOwnerAccount()).add("ResourceType", (Object)this.resourceTypeAsString()).add("SharedVia", this.hasSharedVia() ? this.sharedVia() : null).add("Status", (Object)this.statusAsString()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "analyzedAt": {
                return Optional.ofNullable(clazz.cast(this.analyzedAt()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "error": {
                return Optional.ofNullable(clazz.cast(this.error()));
            }
            case "isPublic": {
                return Optional.ofNullable(clazz.cast(this.isPublic()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "resourceOwnerAccount": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAccount()));
            }
            case "resourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "sharedVia": {
                return Optional.ofNullable(clazz.cast(this.sharedVia()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzedResource, T> g) {
        return obj -> g.apply((AnalyzedResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();
        private Instant analyzedAt;
        private Instant createdAt;
        private String error;
        private Boolean isPublic;
        private String resourceArn;
        private String resourceOwnerAccount;
        private String resourceType;
        private List<String> sharedVia = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzedResource model) {
            this.actions(model.actions);
            this.analyzedAt(model.analyzedAt);
            this.createdAt(model.createdAt);
            this.error(model.error);
            this.isPublic(model.isPublic);
            this.resourceArn(model.resourceArn);
            this.resourceOwnerAccount(model.resourceOwnerAccount);
            this.resourceType(model.resourceType);
            this.sharedVia(model.sharedVia);
            this.status(model.status);
            this.updatedAt(model.updatedAt);
        }

        public final Collection<String> getActions() {
            if (this.actions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        public final Instant getAnalyzedAt() {
            return this.analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getError() {
            return this.error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final Boolean getIsPublic() {
            return this.isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceOwnerAccount() {
            return this.resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getSharedVia() {
            if (this.sharedVia instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sharedVia;
        }

        @Override
        public final Builder sharedVia(Collection<String> sharedVia) {
            this.sharedVia = SharedViaListCopier.copy(sharedVia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedVia(String ... sharedVia) {
            this.sharedVia(Arrays.asList(sharedVia));
            return this;
        }

        public final void setSharedVia(Collection<String> sharedVia) {
            this.sharedVia = SharedViaListCopier.copy(sharedVia);
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        public AnalyzedResource build() {
            return new AnalyzedResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AnalyzedResource> {
        public Builder actions(Collection<String> var1);

        public Builder actions(String ... var1);

        public Builder analyzedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder error(String var1);

        public Builder isPublic(Boolean var1);

        public Builder resourceArn(String var1);

        public Builder resourceOwnerAccount(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder sharedVia(Collection<String> var1);

        public Builder sharedVia(String ... var1);

        public Builder status(String var1);

        public Builder status(FindingStatus var1);

        public Builder updatedAt(Instant var1);
    }
}

