/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AccessPreviewStatus {
    COMPLETED("COMPLETED"),
    CREATING("CREATING"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AccessPreviewStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AccessPreviewStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AccessPreviewStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AccessPreviewStatus> knownValues() {
        return Stream.of(AccessPreviewStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

