/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import twitter4j.HttpResponse;
import twitter4j.JSONObject;
import twitter4j.PagableResponseList;
import twitter4j.ParseUtil;
import twitter4j.RateLimitStatus;
import twitter4j.ResponseListImpl;
import twitter4j.TwitterResponse;

class PagableResponseListImpl<T extends TwitterResponse>
extends ResponseListImpl<T>
implements PagableResponseList<T> {
    private static final long serialVersionUID = -8603601553967559275L;
    private final long previousCursor;
    private final long nextCursor;

    PagableResponseListImpl(RateLimitStatus rateLimitStatus, int accessLevel) {
        super(rateLimitStatus, accessLevel);
        this.previousCursor = 0L;
        this.nextCursor = 0L;
    }

    PagableResponseListImpl(int size, JSONObject json, HttpResponse res) {
        super(size, res);
        this.previousCursor = ParseUtil.getLong("previous_cursor", json);
        this.nextCursor = ParseUtil.getLong("next_cursor", json);
    }

    @Override
    public boolean hasPrevious() {
        return 0L != this.previousCursor;
    }

    @Override
    public long getPreviousCursor() {
        return this.previousCursor;
    }

    @Override
    public boolean hasNext() {
        return 0L != this.nextCursor;
    }

    @Override
    public long getNextCursor() {
        return this.nextCursor;
    }
}

