/*
 * =============================================================================
 * 
 *   Copyright (c) 2011-2016, The THYMELEAF team (http://www.thymeleaf.org)
 * 
 *   Licensed under the Apache License, Version 2.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 * 
 *       http://www.apache.org/licenses/LICENSE-2.0
 * 
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 * 
 * =============================================================================
 */
package org.thymeleaf.engine;

/**
 * <p>
 *   This is a marker interface that determines that the marked structure
 *   needs to be set the AttributeDefinitions object from the engine during the configuration
 *   phase.
 * </p>
 * <p>
 *   This interface can be applied to processors, pre-processors and post-processors.
 * </p>
 * <p>
 *   This interface is <strong>only for internal use</strong>.
 * </p>
 *
 * @author Daniel Fern&aacute;ndez
 *
 * @since 3.0.0
 *
 */
public interface IAttributeDefinitionsAware {

    public void setAttributeDefinitions(final AttributeDefinitions attributeDefinitions);

}
