/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.DataProviderHolder;
import org.testng.IAttributes;
import org.testng.IClassListener;
import org.testng.IConfigurationListener;
import org.testng.IDataProviderInterceptor;
import org.testng.IDataProviderListener;
import org.testng.IExecutionVisualiser;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInterceptor;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ISuiteResult;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ITestRunnerFactory;
import org.testng.SuiteResult;
import org.testng.SuiteRunState;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.Attributes;
import org.testng.internal.IConfiguration;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.invokers.ConfigMethodArguments;
import org.testng.internal.invokers.IInvocationStatus;
import org.testng.internal.invokers.IInvoker;
import org.testng.internal.invokers.InvokedMethod;
import org.testng.internal.objects.ObjectFactoryImpl;
import org.testng.internal.thread.ThreadUtil;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.TestHTMLReporter;
import org.testng.reporters.TextReporter;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class SuiteRunner
implements ISuite,
IInvokedMethodListener {
    private static final String DEFAULT_OUTPUT_DIR = "test-output";
    private final Map<String, ISuiteResult> suiteResults = Collections.synchronizedMap(Maps.newLinkedHashMap());
    private final List<TestRunner> testRunners = Lists.newArrayList();
    private final Map<Class<? extends ISuiteListener>, ISuiteListener> listeners = Maps.newLinkedHashMap();
    private String outputDir;
    private XmlSuite xmlSuite;
    private Injector parentInjector;
    private final List<ITestListener> testListeners = Lists.newArrayList();
    private final Map<Class<? extends IClassListener>, IClassListener> classListeners = Maps.newLinkedHashMap();
    private ITestRunnerFactory tmpRunnerFactory;
    private final DataProviderHolder holder = new DataProviderHolder();
    private boolean useDefaultListeners = true;
    private String remoteHost;
    private IConfiguration configuration;
    private ITestObjectFactory objectFactory;
    private Boolean skipFailedInvocationCounts = Boolean.FALSE;
    private final List<IReporter> reporters = Lists.newArrayList();
    private Map<Class<? extends IInvokedMethodListener>, IInvokedMethodListener> invokedMethodListeners;
    private final SuiteRunState suiteState = new SuiteRunState();
    private final IAttributes attributes = new Attributes();
    private final Set<IExecutionVisualiser> visualisers = Sets.newHashSet();

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, runnerFactory, false, comparator);
    }

    public SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, Comparator<ITestNGMethod> comparator) {
        this(configuration, suite, outputDir, runnerFactory, useDefaultListeners, new ArrayList<IMethodInterceptor>(), null, null, null, new DataProviderHolder(), comparator);
    }

    protected SuiteRunner(IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListeners, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners, DataProviderHolder holder, Comparator<ITestNGMethod> comparator) {
        this.init(configuration, suite, outputDir, runnerFactory, useDefaultListeners, methodInterceptors, invokedMethodListeners, testListeners, classListeners, holder, comparator);
    }

    private void init(final IConfiguration configuration, XmlSuite suite, String outputDir, ITestRunnerFactory runnerFactory, boolean useDefaultListeners, List<IMethodInterceptor> methodInterceptors, Collection<IInvokedMethodListener> invokedMethodListener, Collection<ITestListener> testListeners, Collection<IClassListener> classListeners, DataProviderHolder attribs, Comparator<ITestNGMethod> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("comparator must not be null");
        }
        this.holder.merge(attribs);
        this.configuration = configuration;
        this.xmlSuite = suite;
        this.useDefaultListeners = useDefaultListeners;
        this.tmpRunnerFactory = runnerFactory;
        List localMethodInterceptors = Optional.ofNullable(methodInterceptors).orElse(Lists.newArrayList());
        this.setOutputDir(outputDir);
        if (configuration.getObjectFactory() == null) {
            configuration.setObjectFactory(new ObjectFactoryImpl());
        }
        if (suite.getObjectFactoryClass() == null) {
            this.objectFactory = configuration.getObjectFactory();
        } else {
            ITestObjectFactory suiteObjectFactory;
            boolean create;
            boolean bl = create = !configuration.getObjectFactory().getClass().equals(suite.getObjectFactoryClass());
            if (create) {
                if (this.objectFactory == null) {
                    this.objectFactory = configuration.getObjectFactory();
                }
                suiteObjectFactory = this.objectFactory.newInstance(suite.getObjectFactoryClass(), new Object[0]);
            } else {
                suiteObjectFactory = configuration.getObjectFactory();
            }
            this.objectFactory = new ITestObjectFactory(){

                @Override
                public <T> T newInstance(Class<T> cls, Object ... parameters) {
                    try {
                        return suiteObjectFactory.newInstance(cls, parameters);
                    }
                    catch (Exception e) {
                        return configuration.getObjectFactory().newInstance(cls, parameters);
                    }
                }

                @Override
                public <T> T newInstance(String clsName, Object ... parameters) {
                    try {
                        return suiteObjectFactory.newInstance(clsName, parameters);
                    }
                    catch (Exception e) {
                        return configuration.getObjectFactory().newInstance(clsName, parameters);
                    }
                }

                @Override
                public <T> T newInstance(Constructor<T> constructor, Object ... parameters) {
                    try {
                        return suiteObjectFactory.newInstance(constructor, parameters);
                    }
                    catch (Exception e) {
                        return configuration.getObjectFactory().newInstance(constructor, parameters);
                    }
                }
            };
        }
        this.invokedMethodListeners = Maps.synchronizedLinkedHashMap();
        for (IInvokedMethodListener listener : (Collection)Optional.ofNullable(invokedMethodListener).orElse(Collections.emptyList())) {
            this.invokedMethodListeners.put(listener.getClass(), listener);
        }
        this.invokedMethodListeners.put(this.getClass(), this);
        this.skipFailedInvocationCounts = suite.skipFailedInvocationCounts();
        if (null != testListeners) {
            this.testListeners.addAll(testListeners);
        }
        for (IClassListener classListener : (Collection)Optional.ofNullable(classListeners).orElse(Collections.emptyList())) {
            this.classListeners.put(classListener.getClass(), classListener);
        }
        ITestRunnerFactory iTestRunnerFactory = this.buildRunnerFactory(comparator);
        List<XmlTest> xmlTests = this.xmlSuite.getTests();
        xmlTests.sort(Comparator.comparingInt(XmlTest::getIndex));
        for (XmlTest test : xmlTests) {
            TestRunner tr = iTestRunnerFactory.newTestRunner((ISuite)this, test, this.invokedMethodListeners.values(), Lists.newArrayList(this.classListeners.values()), this.holder);
            for (IMethodInterceptor methodInterceptor : localMethodInterceptors) {
                tr.addMethodInterceptor(methodInterceptor);
            }
            this.testRunners.add(tr);
        }
    }

    @Override
    public XmlSuite getXmlSuite() {
        return this.xmlSuite;
    }

    @Override
    public String getName() {
        return this.xmlSuite.getName();
    }

    public void setObjectFactory(ITestObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    public void setReportResults(boolean reportResults) {
        this.useDefaultListeners = reportResults;
    }

    private void invokeListeners(boolean start) {
        if (start) {
            for (ISuiteListener sl : Lists.newArrayList(this.listeners.values())) {
                sl.onStart(this);
            }
        } else {
            List<ISuiteListener> suiteListenersReversed = Lists.newReversedArrayList(this.listeners.values());
            for (ISuiteListener sl : suiteListenersReversed) {
                sl.onFinish(this);
            }
        }
    }

    private void setOutputDir(String outputdir) {
        if (Utils.isStringBlank(outputdir) && this.useDefaultListeners) {
            outputdir = DEFAULT_OUTPUT_DIR;
        }
        this.outputDir = null != outputdir ? new File(outputdir).getAbsolutePath() : null;
    }

    private ITestRunnerFactory buildRunnerFactory(Comparator<ITestNGMethod> comparator) {
        ITestRunnerFactory factory = null == this.tmpRunnerFactory ? new DefaultTestRunnerFactory(this.configuration, this.testListeners.toArray(new ITestListener[0]), this.useDefaultListeners, this.skipFailedInvocationCounts, comparator) : new ProxyTestRunnerFactory(this.testListeners.toArray(new ITestListener[0]), this.tmpRunnerFactory);
        return factory;
    }

    @Override
    public String getParallel() {
        return this.xmlSuite.getParallel().toString();
    }

    @Override
    public String getParentModule() {
        return this.xmlSuite.getParentModule();
    }

    @Override
    public String getGuiceStage() {
        return this.xmlSuite.getGuiceStage();
    }

    @Override
    public Injector getParentInjector() {
        return this.parentInjector;
    }

    @Override
    public void setParentInjector(Injector injector) {
        this.parentInjector = injector;
    }

    @Override
    public void run() {
        this.invokeListeners(true);
        try {
            this.privateRun();
        }
        finally {
            this.invokeListeners(false);
        }
    }

    private void privateRun() {
        LinkedHashMap<Method, ITestNGMethod> beforeSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        LinkedHashMap<Method, ITestNGMethod> afterSuiteMethods = new LinkedHashMap<Method, ITestNGMethod>();
        IInvoker invoker = null;
        for (TestRunner tr : this.testRunners) {
            invoker = tr.getInvoker();
            for (ITestNGMethod m : tr.getBeforeSuiteMethods()) {
                beforeSuiteMethods.put(m.getConstructorOrMethod().getMethod(), m);
            }
            for (ITestNGMethod m : tr.getAfterSuiteMethods()) {
                afterSuiteMethods.put(m.getConstructorOrMethod().getMethod(), m);
            }
        }
        if (invoker != null) {
            if (!beforeSuiteMethods.values().isEmpty()) {
                ConfigMethodArguments arguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(beforeSuiteMethods.values()).forSuite(this.xmlSuite).usingParameters(this.xmlSuite.getParameters()).build();
                invoker.getConfigInvoker().invokeConfigurations(arguments);
            }
            Utils.log("SuiteRunner", 3, "Created " + this.testRunners.size() + " TestRunners");
            boolean testsInParallel = XmlSuite.ParallelMode.TESTS.equals((Object)this.xmlSuite.getParallel());
            if (RuntimeBehavior.strictParallelism()) {
                boolean bl = testsInParallel = !XmlSuite.ParallelMode.NONE.equals((Object)this.xmlSuite.getParallel());
            }
            if (testsInParallel) {
                this.runInParallelTestMode();
            } else {
                this.runSequentially();
            }
            if (!afterSuiteMethods.values().isEmpty()) {
                ConfigMethodArguments arguments = new ConfigMethodArguments.Builder().usingConfigMethodsAs(afterSuiteMethods.values()).forSuite(this.xmlSuite).usingParameters(this.xmlSuite.getAllParameters()).build();
                invoker.getConfigInvoker().invokeConfigurations(arguments);
            }
        }
    }

    private void addVisualiser(IExecutionVisualiser visualiser) {
        this.visualisers.add(visualiser);
    }

    private void addReporter(IReporter listener) {
        this.reporters.add(listener);
    }

    void addConfigurationListener(IConfigurationListener listener) {
        this.configuration.addConfigurationListener(listener);
    }

    public List<IReporter> getReporters() {
        return this.reporters;
    }

    public Collection<IDataProviderListener> getDataProviderListeners() {
        return this.holder.getListeners();
    }

    private void runSequentially() {
        for (TestRunner tr : this.testRunners) {
            this.runTest(tr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(TestRunner tr) {
        this.visualisers.forEach(tr::addListener);
        tr.run();
        SuiteResult sr = new SuiteResult(this.xmlSuite, tr);
        Map<String, ISuiteResult> map = this.suiteResults;
        synchronized (map) {
            this.suiteResults.put(tr.getName(), sr);
        }
    }

    private void runInParallelTestMode() {
        List tasks = Lists.newArrayList(this.testRunners.size());
        for (TestRunner tr : this.testRunners) {
            tasks.add(new SuiteWorker(tr));
        }
        ThreadUtil.execute("tests", tasks, this.xmlSuite.getThreadCount(), this.xmlSuite.getTimeOut(Integer.MAX_VALUE));
    }

    protected void addListener(ISuiteListener reporter) {
        this.listeners.putIfAbsent(reporter.getClass(), reporter);
    }

    @Override
    public void addListener(ITestNGListener listener) {
        if (listener instanceof IInvokedMethodListener) {
            IInvokedMethodListener invokedMethodListener = (IInvokedMethodListener)listener;
            this.invokedMethodListeners.put(invokedMethodListener.getClass(), invokedMethodListener);
        }
        if (listener instanceof ISuiteListener) {
            this.addListener((ISuiteListener)listener);
        }
        if (listener instanceof IExecutionVisualiser) {
            this.addVisualiser((IExecutionVisualiser)listener);
        }
        if (listener instanceof IReporter) {
            this.addReporter((IReporter)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
        if (listener instanceof IClassListener) {
            IClassListener classListener = (IClassListener)listener;
            this.classListeners.putIfAbsent(classListener.getClass(), classListener);
        }
        if (listener instanceof IDataProviderListener) {
            IDataProviderListener listenerObject = (IDataProviderListener)listener;
            this.holder.addListener(listenerObject);
        }
        if (listener instanceof IDataProviderInterceptor) {
            IDataProviderInterceptor interceptor = (IDataProviderInterceptor)listener;
            this.holder.addInterceptor(interceptor);
        }
        if (listener instanceof ITestListener) {
            for (TestRunner testRunner : this.testRunners) {
                testRunner.addTestListener((ITestListener)listener);
            }
        }
    }

    @Override
    public String getOutputDirectory() {
        return this.outputDir + File.separatorChar + this.getName();
    }

    @Override
    public Map<String, ISuiteResult> getResults() {
        return this.suiteResults;
    }

    @Override
    public String getParameter(String parameterName) {
        return this.xmlSuite.getParameter(parameterName);
    }

    @Override
    public Map<String, Collection<ITestNGMethod>> getMethodsByGroups() {
        Map<String, Collection<ITestNGMethod>> result = Maps.newHashMap();
        for (TestRunner tr : this.testRunners) {
            ITestNGMethod[] methods;
            for (ITestNGMethod m : methods = tr.getAllTestMethods()) {
                String[] groups;
                for (String groupName : groups = m.getGroups()) {
                    Collection testMethods = result.computeIfAbsent(groupName, k -> Lists.newArrayList());
                    testMethods.add(m);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        return this.testRunners.stream().flatMap(tr -> tr.getExcludedMethods().stream()).collect(Collectors.toList());
    }

    @Override
    public ITestObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public IAnnotationFinder getAnnotationFinder() {
        return this.configuration.getAnnotationFinder();
    }

    public void setHost(String host) {
        this.remoteHost = host;
    }

    @Override
    public String getHost() {
        return this.remoteHost;
    }

    @Override
    public SuiteRunState getSuiteState() {
        return this.suiteState;
    }

    public void setSkipFailedInvocationCounts(Boolean skipFailedInvocationCounts) {
        if (skipFailedInvocationCounts != null) {
            this.skipFailedInvocationCounts = skipFailedInvocationCounts;
        }
    }

    @Override
    public Object getAttribute(String name) {
        return this.attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.attributes.removeAttribute(name);
    }

    @Override
    public void afterInvocation(IInvokedMethod method, ITestResult testResult) {
    }

    @Override
    public void beforeInvocation(IInvokedMethod method, ITestResult testResult) {
        if (method == null) {
            throw new NullPointerException("Method should not be null");
        }
        if (method.getTestMethod() instanceof IInvocationStatus) {
            ((IInvocationStatus)((Object)method.getTestMethod())).setInvokedAt(method.getDate());
        }
    }

    @Override
    public List<IInvokedMethod> getAllInvokedMethods() {
        return this.testRunners.stream().flatMap(tr -> {
            HashSet<ITestResult> results = new HashSet<ITestResult>();
            results.addAll(tr.getConfigurationsScheduledForInvocation().getAllResults());
            results.addAll(tr.getPassedConfigurations().getAllResults());
            results.addAll(tr.getFailedConfigurations().getAllResults());
            results.addAll(tr.getSkippedConfigurations().getAllResults());
            results.addAll(tr.getPassedTests().getAllResults());
            results.addAll(tr.getFailedTests().getAllResults());
            results.addAll(tr.getFailedButWithinSuccessPercentageTests().getAllResults());
            results.addAll(tr.getSkippedTests().getAllResults());
            return results.stream();
        }).filter(tr -> tr.getMethod() instanceof IInvocationStatus).filter(tr -> ((IInvocationStatus)((Object)tr.getMethod())).getInvocationTime() > 0L).map(tr -> new InvokedMethod(((IInvocationStatus)((Object)tr.getMethod())).getInvocationTime(), (ITestResult)tr)).collect(Collectors.toList());
    }

    @Override
    public List<ITestNGMethod> getAllMethods() {
        return this.testRunners.stream().flatMap(tr -> Arrays.stream(tr.getAllTestMethods())).collect(Collectors.toList());
    }

    private static class ProxyTestRunnerFactory
    implements ITestRunnerFactory {
        private final ITestListener[] failureGenerators;
        private final ITestRunnerFactory target;

        public ProxyTestRunnerFactory(ITestListener[] failureListeners, ITestRunnerFactory target) {
            this.failureGenerators = failureListeners;
            this.target = target;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners) {
            return this.newTestRunner(suite, test, listeners, classListeners, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
            DataProviderHolder holder = new DataProviderHolder();
            holder.addListeners(dataProviderListeners.values());
            return this.newTestRunner(suite, test, listeners, classListeners, holder);
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, DataProviderHolder holder) {
            TestRunner testRunner = this.target.newTestRunner(suite, test, listeners, classListeners, holder);
            testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            for (ITestListener itl : this.failureGenerators) {
                testRunner.addListener(itl);
            }
            return testRunner;
        }
    }

    private static class DefaultTestRunnerFactory
    implements ITestRunnerFactory {
        private final ITestListener[] failureGenerators;
        private final boolean useDefaultListeners;
        private final boolean skipFailedInvocationCounts;
        private final IConfiguration configuration;
        private final Comparator<ITestNGMethod> comparator;

        public DefaultTestRunnerFactory(IConfiguration configuration, ITestListener[] failureListeners, boolean useDefaultListeners, boolean skipFailedInvocationCounts, Comparator<ITestNGMethod> comparator) {
            this.configuration = configuration;
            this.failureGenerators = failureListeners;
            this.useDefaultListeners = useDefaultListeners;
            this.skipFailedInvocationCounts = skipFailedInvocationCounts;
            this.comparator = comparator;
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners) {
            return this.newTestRunner(suite, test, listeners, classListeners, Collections.emptyMap());
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
            DataProviderHolder holder = new DataProviderHolder();
            holder.addListeners(dataProviderListeners.values());
            return this.newTestRunner(suite, test, listeners, classListeners, holder);
        }

        @Override
        public TestRunner newTestRunner(ISuite suite, XmlTest test, Collection<IInvokedMethodListener> listeners, List<IClassListener> classListeners, DataProviderHolder holder) {
            boolean skip = this.skipFailedInvocationCounts;
            if (!skip) {
                skip = test.skipFailedInvocationCounts();
            }
            TestRunner testRunner = new TestRunner(this.configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(), skip, listeners, classListeners, this.comparator, holder);
            if (this.useDefaultListeners) {
                testRunner.addListener(new TestHTMLReporter());
                testRunner.addListener(new JUnitXMLReporter());
                testRunner.addListener(new TextReporter(testRunner.getName(), TestRunner.getVerbose()));
            }
            for (ITestListener itl : this.failureGenerators) {
                testRunner.addTestListener(itl);
            }
            for (IConfigurationListener cl : this.configuration.getConfigurationListeners()) {
                testRunner.addConfigurationListener(cl);
            }
            return testRunner;
        }
    }

    private class SuiteWorker
    implements Runnable {
        private final TestRunner testRunner;

        public SuiteWorker(TestRunner tr) {
            this.testRunner = tr;
        }

        @Override
        public void run() {
            Utils.log("[SuiteWorker]", 4, "Running XML Test '" + this.testRunner.getTest().getName() + "' in Parallel");
            SuiteRunner.this.runTest(this.testRunner);
        }
    }
}

