/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.testng.IClass;
import org.testng.IConfigurationListener;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.ITestResult;
import org.testng.ListenerComparator;
import org.testng.TestNGException;
import org.testng.annotations.IListenersAnnotation;
import org.testng.internal.DefaultListenerFactory;
import org.testng.internal.IObject;
import org.testng.internal.ListenerOrderDeterminer;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.annotations.IAnnotationFinder;

public final class TestListenerHelper {
    private TestListenerHelper() {
    }

    public static void runPreConfigurationListeners(ITestResult tr, ITestNGMethod tm, List<IConfigurationListener> listeners, IConfigurationListener internal, ListenerComparator comparator) {
        internal.beforeConfiguration(tr);
        List<IConfigurationListener> original = ListenerOrderDeterminer.order(listeners, comparator);
        for (IConfigurationListener icl : original) {
            icl.beforeConfiguration(tr);
            try {
                icl.beforeConfiguration(tr, tm);
            }
            catch (Exception e) {
                TestListenerHelper.ignoreInternalGradleException(e);
            }
        }
    }

    public static void runPostConfigurationListeners(ITestResult tr, ITestNGMethod tm, List<IConfigurationListener> listeners, IConfigurationListener internal, ListenerComparator comparator) {
        List<IConfigurationListener> listenersreversed = ListenerOrderDeterminer.reversedOrder(listeners, comparator);
        listenersreversed.add(internal);
        block11: for (IConfigurationListener icl : listenersreversed) {
            switch (tr.getStatus()) {
                case 3: {
                    icl.onConfigurationSkip(tr);
                    try {
                        icl.onConfigurationSkip(tr, tm);
                    }
                    catch (Exception e) {
                        TestListenerHelper.ignoreInternalGradleException(e);
                    }
                    continue block11;
                }
                case 2: {
                    icl.onConfigurationFailure(tr);
                    try {
                        icl.onConfigurationFailure(tr, tm);
                    }
                    catch (Exception e) {
                        TestListenerHelper.ignoreInternalGradleException(e);
                    }
                    continue block11;
                }
                case 1: {
                    icl.onConfigurationSuccess(tr);
                    try {
                        icl.onConfigurationSuccess(tr, tm);
                    }
                    catch (Exception e) {
                        TestListenerHelper.ignoreInternalGradleException(e);
                    }
                    continue block11;
                }
            }
            throw new AssertionError((Object)("Unexpected value: " + tr.getStatus()));
        }
    }

    private static void ignoreInternalGradleException(Exception e) {
        if (!e.getClass().getPackage().getName().startsWith("org.gradle.internal")) {
            throw new ListenerInvocationException(e);
        }
    }

    public static void runTestListeners(ITestResult tr, List<ITestListener> listeners) {
        block7: for (ITestListener itl : listeners) {
            switch (tr.getStatus()) {
                case 3: {
                    itl.onTestSkipped(tr);
                    continue block7;
                }
                case 4: {
                    itl.onTestFailedButWithinSuccessPercentage(tr);
                    continue block7;
                }
                case 2: {
                    if (ITestResult.wasFailureDueToTimeout(tr)) {
                        itl.onTestFailedWithTimeout(tr);
                        continue block7;
                    }
                    itl.onTestFailure(tr);
                    continue block7;
                }
                case 1: {
                    itl.onTestSuccess(tr);
                    continue block7;
                }
                case 16: {
                    itl.onTestStart(tr);
                    continue block7;
                }
            }
            throw new AssertionError((Object)("Unknown status: " + tr.getStatus()));
        }
    }

    public static ListenerHolder findAllListeners(Class<?> cls, IAnnotationFinder finder) {
        ListenerHolder result = new ListenerHolder();
        while (cls != Object.class) {
            List<IListenersAnnotation> annotations = finder.findInheritedAnnotations(cls, IListenersAnnotation.class);
            Optional.ofNullable(finder.findAnnotation(cls, IListenersAnnotation.class)).ifPresent(annotations::add);
            annotations.stream().flatMap(it -> Arrays.stream(it.getValue())).forEach(result::addListener);
            cls = cls.getSuperclass();
        }
        return result;
    }

    @Deprecated
    public static ITestNGListenerFactory createListenerFactory(ITestObjectFactory objectFactory, TestNGClassFinder finder, Class<? extends ITestNGListenerFactory> factoryClass, ITestContext context) {
        ITestNGListenerFactory listenerFactory = null;
        try {
            IClass ic;
            IObject.IdentifiableObject[] created;
            if (finder != null && (created = IObject.objects(ic = finder.getIClass(factoryClass), false)).length != 0) {
                listenerFactory = (ITestNGListenerFactory)created[0].getInstance();
            }
            if (listenerFactory == null) {
                listenerFactory = DefaultListenerFactory.class.equals(factoryClass) ? new DefaultListenerFactory(objectFactory, context) : (factoryClass != null ? objectFactory.newInstance(factoryClass, new Object[0]) : null);
            }
            return listenerFactory;
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + ex, ex);
        }
    }

    static class ListenerInvocationException
    extends RuntimeException {
        public ListenerInvocationException(Throwable cause) {
            super(cause);
        }
    }

    public static class ListenerHolder {
        private final List<Class<? extends ITestNGListener>> listenerClasses = new ArrayList<Class<? extends ITestNGListener>>();
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        public void addListener(Class<? extends ITestNGListener> c) {
            if (!this.listenerClasses.contains(c)) {
                this.listenerClasses.add(c);
            }
            if (ITestNGListenerFactory.class.isAssignableFrom(c)) {
                this.setListenerFactoryClass(c);
            }
        }

        private void setListenerFactoryClass(Class<? extends ITestNGListenerFactory> c) {
            if (c.equals(this.listenerFactoryClass)) {
                return;
            }
            if (this.listenerFactoryClass != null) {
                throw new TestNGException("Found more than one class implementing ITestNGListenerFactory:" + c + " and " + this.listenerFactoryClass);
            }
            this.listenerFactoryClass = c;
        }

        public List<Class<? extends ITestNGListener>> getListenerClasses() {
            return this.listenerClasses;
        }

        public Class<? extends ITestNGListenerFactory> getListenerFactoryClass() {
            return this.listenerFactoryClass;
        }
    }
}

