/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.util.ArrayList;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.internal.Utils;

public class TextReporter
extends TestListenerAdapter {
    private static final String LINE = "\n===============================================\n";
    private final int m_verbose;
    private final String m_testName;

    public TextReporter(String testName, int verbose) {
        this.m_testName = testName;
        this.m_verbose = verbose;
    }

    @Override
    public void onFinish(ITestContext context) {
        if (this.m_verbose >= 2) {
            this.logResults();
        }
    }

    private static List<ITestNGMethod> resultsToMethods(List<ITestResult> results) {
        ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>(results.size());
        for (ITestResult tr : results) {
            result.add(tr.getMethod());
        }
        return result;
    }

    private void logResults() {
        Object stackTrace;
        Throwable ex;
        for (ITestResult tr : this.getConfigurationFailures()) {
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.shortStackTrace(ex, false);
            }
            this.logResult("FAILED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), (String)stackTrace, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult tr : this.getConfigurationSkips()) {
            this.logResult("SKIPPED CONFIGURATION", Utils.detailedMethodName(tr.getMethod(), false), tr.getMethod().getDescription(), null, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
        }
        for (ITestResult tr : this.getPassedTests()) {
            this.logResult("PASSED", tr, null);
        }
        for (ITestResult tr : this.getFailedTests()) {
            ex = tr.getThrowable();
            stackTrace = "";
            if (ex != null && this.m_verbose >= 2) {
                stackTrace = Utils.shortStackTrace(ex, false);
            }
            this.logResult("FAILED", tr, (String)stackTrace);
        }
        List<ITestResult> rawskipped = this.getSkippedTests();
        List<ITestResult> skippedTests = Lists.newArrayList();
        List<ITestResult> retriedTests = Lists.newArrayList();
        for (ITestResult result : rawskipped) {
            if (result.wasRetried()) {
                retriedTests.add(result);
                continue;
            }
            skippedTests.add(result);
        }
        this.logExceptions("SKIPPED", skippedTests);
        this.logExceptions("RETRIED", retriedTests);
        List<ITestNGMethod> ft = TextReporter.resultsToMethods(this.getFailedTests());
        StringBuilder logBuf = new StringBuilder(LINE);
        logBuf.append("    ").append(this.m_testName).append("\n");
        logBuf.append("    Tests run: ").append(this.getAllTestMethods().length).append(", Failures: ").append(ft.size()).append(", Skips: ").append(TextReporter.resultsToMethods(skippedTests).size());
        if (!retriedTests.isEmpty()) {
            logBuf.append(", Retries: ").append(TextReporter.resultsToMethods(retriedTests).size());
        }
        int confFailures = this.getConfigurationFailures().size();
        int confSkips = this.getConfigurationSkips().size();
        if (confFailures > 0 || confSkips > 0) {
            logBuf.append("\n").append("    Configuration Failures: ").append(confFailures).append(", Skips: ").append(confSkips);
        }
        logBuf.append(LINE);
        this.logResult("", logBuf.toString());
    }

    private void logResult(String status, ITestResult tr, String stackTrace) {
        this.logResult(status, tr.getName(), tr.getMethod().getDescription(), stackTrace, tr.getParameters(), tr.getMethod().getConstructorOrMethod().getParameterTypes());
    }

    private void logExceptions(String status, List<ITestResult> results) {
        results.forEach(tr -> {
            Throwable throwable = tr.getThrowable();
            this.logResult(status, (ITestResult)tr, throwable != null ? Utils.shortStackTrace(throwable, false) : null);
        });
    }

    private void logResult(String status, String message) {
        StringBuilder buf = new StringBuilder();
        if (Utils.isStringNotBlank(status)) {
            buf.append(status).append(": ");
        }
        buf.append(message);
        System.out.println(buf);
    }

    private void logResult(String status, String name, String description, String stackTrace, Object[] params, Class<?>[] paramTypes) {
        int i;
        StringBuilder msg = new StringBuilder(name);
        if (null != params && params.length > 0) {
            msg.append("(");
            if (params.length != paramTypes.length) {
                msg.append(name).append(": Wrong number of arguments were passed by ").append("the Data Provider: found ").append(params.length).append(" but ").append("expected ").append(paramTypes.length).append(")");
            } else {
                for (i = 0; i < params.length; ++i) {
                    if (i > 0) {
                        msg.append(", ");
                    }
                    msg.append(Utils.toString(params[i], paramTypes[i]));
                }
                msg.append(")");
            }
        }
        if (!Utils.isStringEmpty(description)) {
            msg.append("\n");
            for (i = 0; i < status.length() + 2; ++i) {
                msg.append(" ");
            }
            msg.append(description);
        }
        if (!Utils.isStringEmpty(stackTrace)) {
            msg.append("\n").append(stackTrace);
        }
        this.logResult(status, msg.toString());
    }
}

