/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.testng.ITestNGMethod;
import org.testng.annotations.IAnnotation;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.IDataProviderAnnotation;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IParametersAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Maps;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.ConfigurationAnnotation;
import org.testng.internal.annotations.IAfterClass;
import org.testng.internal.annotations.IAfterGroups;
import org.testng.internal.annotations.IAfterMethod;
import org.testng.internal.annotations.IAfterSuite;
import org.testng.internal.annotations.IAfterTest;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IBeforeClass;
import org.testng.internal.annotations.IBeforeGroups;
import org.testng.internal.annotations.IBeforeMethod;
import org.testng.internal.annotations.IBeforeSuite;
import org.testng.internal.annotations.IBeforeTest;
import org.testng.internal.reflect.ReflectionHelper;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlTest;

public class AnnotationHelper {
    private static final Logger LOGGER = Logger.getLogger(AnnotationHelper.class);
    private static final String SUFFIX = "Please check if all classes being referred to, in the annotation are available in the classpath.";
    private static final List<Class<? extends IAnnotation>> ALL_ANNOTATIONS = Arrays.asList(ITestAnnotation.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class, IDataProviderAnnotation.class, IFactoryAnnotation.class, IParametersAnnotation.class, IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class);
    private static final List<Class<? extends IAnnotation>> CONFIGURATION_CLASSES = Arrays.asList(IBeforeSuite.class, IAfterSuite.class, IBeforeTest.class, IAfterTest.class, IBeforeGroups.class, IAfterGroups.class, IBeforeClass.class, IAfterClass.class, IBeforeMethod.class, IAfterMethod.class);

    private AnnotationHelper() {
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Class<?> cls) {
        return finder.findAnnotation(cls, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, Method m) {
        return finder.findAnnotation(m, ITestAnnotation.class);
    }

    public static ITestAnnotation findTest(IAnnotationFinder finder, ITestNGMethod m) {
        return finder.findAnnotation(m, ITestAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Method m) {
        return finder.findAnnotation(m, IFactoryAnnotation.class);
    }

    public static IFactoryAnnotation findFactory(IAnnotationFinder finder, Constructor c) {
        return finder.findAnnotation(c, IFactoryAnnotation.class);
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, ConstructorOrMethod m) {
        IConfigurationAnnotation result = null;
        IConfigurationAnnotation bs = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IBeforeSuite.class));
        IConfigurationAnnotation as = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IAfterSuite.class));
        IConfigurationAnnotation bt = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IBeforeTest.class));
        IConfigurationAnnotation at = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IAfterTest.class));
        IConfigurationAnnotation bg = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IBeforeGroups.class));
        IConfigurationAnnotation ag = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IAfterGroups.class));
        IConfigurationAnnotation bc = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IBeforeClass.class));
        IConfigurationAnnotation ac = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IAfterClass.class));
        IConfigurationAnnotation bm = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IBeforeMethod.class));
        IConfigurationAnnotation am = (IConfigurationAnnotation)((Object)finder.findAnnotation(m, IAfterMethod.class));
        if (bs != null || as != null || bt != null || at != null || bg != null || ag != null || bc != null || ac != null || bm != null || am != null) {
            result = AnnotationHelper.createConfiguration(bs, as, bt, at, bg, ag, bc, ac, bm, am);
        }
        return result;
    }

    public static IConfigurationAnnotation findConfiguration(IAnnotationFinder finder, Method m) {
        return AnnotationHelper.findConfiguration(finder, new ConstructorOrMethod(m));
    }

    private static IConfigurationAnnotation createConfiguration(IConfigurationAnnotation bs, IConfigurationAnnotation as, IConfigurationAnnotation bt, IConfigurationAnnotation at, IConfigurationAnnotation bg, IConfigurationAnnotation ag, IConfigurationAnnotation bc, IConfigurationAnnotation ac, IConfigurationAnnotation bm, IConfigurationAnnotation am) {
        ConfigurationAnnotation result = new ConfigurationAnnotation();
        if (bs != null) {
            result.setBeforeSuite(true);
            AnnotationHelper.finishInitialize(result, bs);
        }
        if (as != null) {
            result.setAfterSuite(true);
            AnnotationHelper.finishInitialize(result, as);
        }
        if (bt != null) {
            result.setBeforeTest(true);
            AnnotationHelper.finishInitialize(result, bt);
        }
        if (at != null) {
            result.setAfterTest(true);
            AnnotationHelper.finishInitialize(result, at);
        }
        if (bg != null) {
            result.setBeforeGroups(bg.getBeforeGroups());
            AnnotationHelper.finishInitialize(result, bg);
        }
        if (ag != null) {
            result.setAfterGroups(ag.getAfterGroups());
            AnnotationHelper.finishInitialize(result, ag);
        }
        if (bc != null) {
            result.setBeforeTestClass(true);
            AnnotationHelper.finishInitialize(result, bc);
        }
        if (ac != null) {
            result.setAfterTestClass(true);
            AnnotationHelper.finishInitialize(result, ac);
        }
        if (bm != null) {
            result.setBeforeTestMethod(true);
            AnnotationHelper.finishInitialize(result, bm);
        }
        if (am != null) {
            result.setAfterTestMethod(true);
            AnnotationHelper.finishInitialize(result, am);
        }
        return result;
    }

    private static void finishInitialize(ConfigurationAnnotation result, IConfigurationAnnotation bs) {
        result.setFakeConfiguration(true);
        result.setAlwaysRun(bs.getAlwaysRun());
        result.setDependsOnGroups(bs.getDependsOnGroups());
        result.setDependsOnMethods(bs.getDependsOnMethods());
        result.setDescription(bs.getDescription());
        result.setEnabled(bs.getEnabled());
        result.setGroups(bs.getGroups());
        result.setInheritGroups(bs.getInheritGroups());
        result.setTimeOut(bs.getTimeOut());
    }

    public static List<Class<? extends IAnnotation>> getAllAnnotations() {
        return ALL_ANNOTATIONS;
    }

    public static ITestNGMethod[] findMethodsWithAnnotation(Class<?> rootClass, Class<? extends IAnnotation> annotationClass, IAnnotationFinder annotationFinder, XmlTest xmlTest) {
        Map<String, TestNGMethod> vResult = Maps.newHashMap();
        try {
            vResult = Maps.newHashMap();
            for (Class<?> cls = rootClass; null != cls; cls = cls.getSuperclass()) {
                Method[] methods;
                boolean hasClassAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, cls, annotationClass);
                for (Method m : methods = ReflectionHelper.getLocalMethods(cls)) {
                    boolean hasMethodAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, annotationClass);
                    boolean hasTestNGAnnotation = AnnotationHelper.isAnnotationPresent(annotationFinder, m, IFactoryAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m, ITestAnnotation.class) || AnnotationHelper.isAnnotationPresent(annotationFinder, m);
                    boolean isPublic = Modifier.isPublic(m.getModifiers());
                    boolean isSynthetic = m.isSynthetic();
                    if ((!isPublic || !hasClassAnnotation || isSynthetic || hasTestNGAnnotation) && !hasMethodAnnotation) continue;
                    if (AnnotationHelper.isAnnotationPresent(annotationFinder, m, IConfigurationAnnotation.class) && AnnotationHelper.isAnnotationPresent(annotationFinder, cls, ITestAnnotation.class)) {
                        Utils.log("", 3, "Method " + m + " has a configuration annotation and a class-level @Test. This method will only be kept as a configuration method.");
                        continue;
                    }
                    if (m.getReturnType() != Void.TYPE && !xmlTest.getAllowReturnValues().booleanValue()) {
                        Utils.log("", 2, "Method " + m + " has a @Test annotation but also a return value: ignoring it. Use <suite allow-return-values=\"true\"> to fix this");
                        continue;
                    }
                    String key = AnnotationHelper.createMethodKey(m);
                    if (null != vResult.get(key)) continue;
                    TestNGMethod tm = new TestNGMethod(m, annotationFinder, xmlTest, null);
                    vResult.put(key, tm);
                }
            }
        }
        catch (SecurityException e) {
            LOGGER.error(e.getMessage(), e);
        }
        return vResult.values().toArray(new ITestNGMethod[0]);
    }

    public static <A extends Annotation> A findAnnotationSuperClasses(Class<A> annotationClass, Class<?> parameterClass) {
        for (Class<?> c = parameterClass; c != null; c = c.getSuperclass()) {
            A result = c.getAnnotation(annotationClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m) {
        for (Class<? extends IAnnotation> a : CONFIGURATION_CLASSES) {
            if (annotationFinder.findAnnotation(m, a) == null) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Method m, Class<? extends IAnnotation> annotationClass) {
        if (!annotationClass.equals(IConfigurationAnnotation.class)) {
            return annotationFinder.findAnnotation(m, annotationClass) != null;
        }
        boolean found = false;
        for (Class<? extends IAnnotation> clazz : CONFIGURATION_CLASSES) {
            if (annotationFinder.findAnnotation(m, clazz) == null) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean isAnnotationPresent(IAnnotationFinder annotationFinder, Class<?> cls, Class<? extends IAnnotation> annotationClass) {
        return annotationFinder.findAnnotation(cls, annotationClass) != null;
    }

    private static String createMethodKey(Method m) {
        StringBuilder result = new StringBuilder(m.getName());
        for (Class<?> paramClass : m.getParameterTypes()) {
            result.append(' ').append(paramClass.toString());
        }
        return result.toString();
    }

    static <A extends Annotation> A getAnnotationFromClass(Class<?> clazz, Class<A> a) {
        Objects.requireNonNull(clazz, "Cannot retrieve annotations from a null class.");
        Objects.requireNonNull(a, "Cannot work with a null annotation");
        try {
            return clazz.getAnnotation(a);
        }
        catch (Throwable t) {
            String msg = "Encountered problems when parsing the annotation on class " + clazz.getCanonicalName() + ". ";
            msg = msg + SUFFIX;
            throw new TypeNotPresentException(msg, t);
        }
    }

    static <A extends Annotation> A getAnnotationFromMethod(Method method, Class<A> a) {
        Objects.requireNonNull(method, "Cannot retrieve annotations from a null method.");
        Objects.requireNonNull(a, "Cannot work with a null annotation");
        try {
            return method.getAnnotation(a);
        }
        catch (Throwable t) {
            String mname = method.getDeclaringClass().getCanonicalName() + "." + method.getName();
            String msg = "Encountered problems when parsing the annotation on method " + mname + "(). ";
            msg = msg + SUFFIX;
            throw new TypeNotPresentException(msg, t);
        }
    }

    static <A extends Annotation> A getAnnotationFromConstructor(Constructor<?> c, Class<A> a) {
        Objects.requireNonNull(c, "Cannot retrieve annotations from a null constructor.");
        Objects.requireNonNull(a, "Cannot work with a null annotation");
        try {
            return (A)c.getAnnotation(a);
        }
        catch (Throwable t) {
            String msg = "Encountered problems when parsing the annotation on constructor " + c.getName() + ". ";
            msg = msg + SUFFIX;
            throw new TypeNotPresentException(msg, t);
        }
    }
}

