/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.TestRunner;
import org.testng.collections.Lists;
import org.testng.internal.RuntimeBehavior;
import org.testng.log4testng.Logger;
import org.testng.reporters.XMLStringBuffer;

public final class Utils {
    private static final String LINE_SEP = RuntimeBehavior.getDefaultLineSeparator();
    private static final char[] SPECIAL_CHARACTERS = new char[]{'*', '/', '\\', '?', '%', ':', ';', '<', '>', '&', '~', '|'};
    public static final char CHAR_REPLACEMENT = '_';
    public static final char UNICODE_REPLACEMENT = '\ufffd';
    private static final String FORMAT = String.format("[%s]", Utils.class.getSimpleName());
    private static final Logger LOG = Logger.getLogger(Utils.class);
    private static final Map<Character, String> ESCAPES = new HashMap<Character, String>();

    private Utils() {
    }

    public static void writeUtf8File(@Nullable String outputDir, String fileName, XMLStringBuffer xsb, String prefix) {
        try {
            File file;
            File outDir;
            File file2 = outDir = outputDir != null ? new File(outputDir) : new File("").getAbsoluteFile();
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            if (!(file = new File(outDir, fileName)).exists()) {
                file.createNewFile();
            }
            try (OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);){
                if (prefix != null) {
                    w.append(prefix);
                }
                xsb.toWriter(w);
            }
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), ex);
        }
    }

    public static void writeUtf8File(@Nullable String outputDir, String fileName, String sb) {
        String outDirPath = outputDir != null ? outputDir : "";
        File outDir = new File(outDirPath);
        Utils.writeFile(outDir, fileName, Utils.escapeUnicode(sb), "UTF-8");
    }

    public static void writeFile(@Nullable String outputDir, String fileName, String sb) {
        String outDirPath = outputDir != null ? outputDir : "";
        File outDir = new File(outDirPath);
        Utils.writeFile(outDir, fileName, sb, null);
    }

    private static void writeFile(@Nullable File outputFolder, String fileNameParameter, String sb, @Nullable String encoding) {
        File outDir = outputFolder;
        String fileName = fileNameParameter;
        try {
            if (outDir == null) {
                outDir = new File("").getAbsoluteFile();
            }
            if (!outDir.exists()) {
                outDir.mkdirs();
            }
            fileName = Utils.replaceSpecialCharacters(fileName);
            File outputFile = new File(outDir, fileName);
            outputFile.delete();
            Utils.log(FORMAT, 3, "Attempting to create " + outputFile);
            Utils.log(FORMAT, 3, "  Directory " + outDir + " exists: " + outDir.exists());
            outputFile.createNewFile();
            Utils.writeFile(outputFile, sb, encoding);
        }
        catch (IOException e) {
            if (TestRunner.getVerbose() > 1) {
                LOG.error(e.getMessage(), e);
            }
            Utils.log(FORMAT, 1, e.getMessage());
        }
    }

    private static void writeFile(File outputFile, String sb, @Nullable String encoding) {
        try (BufferedWriter fw = Utils.openWriter(outputFile, encoding);){
            fw.write(sb);
            Utils.log("", 3, "Creating " + outputFile.getAbsolutePath());
        }
        catch (IOException ex) {
            if (TestRunner.getVerbose() > 1) {
                LOG.error("ERROR WHILE WRITING TO " + outputFile, ex);
            }
            Utils.log(FORMAT, 1, "Error while writing to " + outputFile + ": " + ex.getMessage());
        }
    }

    public static BufferedWriter openWriter(@Nullable String outputDir, String fileNameParameter) throws IOException {
        String fileName = fileNameParameter;
        String outDirPath = outputDir != null ? outputDir : "";
        File outDir = new File(outDirPath);
        if (!outDir.exists()) {
            outDir.mkdirs();
        }
        fileName = Utils.replaceSpecialCharacters(fileName);
        File outputFile = new File(outDir, fileName);
        outputFile.delete();
        return Utils.openWriter(outputFile, null);
    }

    private static BufferedWriter openWriter(File outputFile, @Nullable String encoding) throws IOException {
        if (!outputFile.exists()) {
            outputFile.createNewFile();
        }
        OutputStreamWriter osw = null != encoding ? new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding) : new OutputStreamWriter(new FileOutputStream(outputFile));
        return new BufferedWriter(osw);
    }

    public static void log(String msg) {
        Utils.log("Utils", 2, msg);
    }

    public static void log(String cls, int level, String msg) {
        if (TestRunner.getVerbose() >= level) {
            if (cls.length() > 0) {
                LOG.info("[" + cls + "] " + msg);
            } else {
                LOG.info(msg);
            }
        }
    }

    public static void error(String errorMessage) {
        LOG.error("[Error] " + errorMessage);
    }

    public static String[] split(String string, String sep) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        int start = 0;
        int idx = string.indexOf(sep, start);
        int len = sep.length();
        List strings = Lists.newArrayList();
        while (idx != -1) {
            strings.add(string.substring(start, idx).trim());
            start = idx + len;
            idx = string.indexOf(sep, start);
        }
        strings.add(string.substring(start).trim());
        return strings.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeResourceToFile(File file, String resourceName, Class<?> clasz) throws IOException {
        InputStream inputStream = clasz.getResourceAsStream("/" + resourceName);
        if (inputStream == null) {
            LOG.error("Couldn't find resource on the class path: " + resourceName);
            return;
        }
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            int nread;
            byte[] buffer = new byte[4096];
            while (0 < (nread = inputStream.read(buffer))) {
                outputStream.write(buffer, 0, nread);
            }
        }
        finally {
            inputStream.close();
        }
    }

    public static String defaultIfStringEmpty(String s, String defaultValue) {
        return Utils.isStringEmpty(s) ? defaultValue : s;
    }

    public static boolean isStringBlank(String s) {
        return s == null || "".equals(s.trim());
    }

    public static boolean isStringEmpty(String s) {
        return s == null || "".equals(s);
    }

    public static boolean isStringNotBlank(String s) {
        return !Utils.isStringBlank(s);
    }

    public static boolean isStringNotEmpty(String s) {
        return !Utils.isStringEmpty(s);
    }

    public static String longStackTrace(Throwable t, boolean toHtml) {
        return Utils.buildStackTrace(t, toHtml, StackTraceType.FULL);
    }

    public static String shortStackTrace(Throwable t, boolean toHtml) {
        return Utils.buildStackTrace(t, toHtml, StackTraceType.SHORT);
    }

    private static String buildStackTrace(Throwable t, boolean toHtml, StackTraceType type) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        String stackTrace = sw.getBuffer().toString();
        if (type == StackTraceType.SHORT && !Utils.isTooVerbose()) {
            stackTrace = Utils.filterTrace(sw.getBuffer().toString());
        }
        if (toHtml) {
            stackTrace = Utils.escapeHtml(stackTrace);
        }
        return stackTrace;
    }

    private static boolean isTooVerbose() {
        return RuntimeBehavior.showTestNGStackFrames() || TestRunner.getVerbose() >= 2;
    }

    public static String escapeHtml(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            String nc = ESCAPES.get(Character.valueOf(c));
            if (nc != null) {
                result.append(nc);
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    public static String escapeUnicode(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            char ca = Character.isDefined(c) ? c : (char)'\ufffd';
            result.append(ca);
        }
        return result.toString();
    }

    static String filterTrace(String trace) {
        StringReader stringReader = new StringReader(trace);
        BufferedReader bufferedReader = new BufferedReader(stringReader);
        StringBuilder buf = new StringBuilder();
        try {
            String line = bufferedReader.readLine();
            if (line == null) {
                return "";
            }
            buf.append(line).append(LINE_SEP);
            String[] excludedStrings = new String[]{"org.testng", "reflect", "org.gradle", "org.apache.maven.surefire"};
            int excludedCount = 0;
            while ((line = bufferedReader.readLine()) != null) {
                boolean isExcluded = false;
                for (String excluded : excludedStrings) {
                    if (!line.contains(excluded)) continue;
                    isExcluded = true;
                    ++excludedCount;
                    break;
                }
                if (isExcluded) continue;
                buf.append(line).append(LINE_SEP);
            }
            if (excludedCount > 0) {
                buf.append("... Removed ").append(excludedCount).append(" stack frames");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buf.toString();
    }

    public static String toString(Object object, Class<?> objectClass) {
        if (null == object) {
            return "null";
        }
        String toString = object.toString();
        if (Utils.isStringEmpty(toString)) {
            return "\"\"";
        }
        if (String.class.equals(objectClass)) {
            return "\"" + toString + '\"';
        }
        return toString;
    }

    public static String detailedMethodName(ITestNGMethod method, boolean fqn) {
        String tempName = Utils.annotationFormFor(method);
        if (!tempName.isEmpty()) {
            tempName = tempName + " ";
        }
        return tempName + (fqn ? method.toString() : method.getMethodName());
    }

    public static String annotationFormFor(ITestNGMethod method) {
        if (method.isBeforeSuiteConfiguration()) {
            return "@BeforeSuite";
        }
        if (method.isBeforeTestConfiguration()) {
            return "@BeforeTest";
        }
        if (method.isBeforeClassConfiguration()) {
            return "@BeforeClass";
        }
        if (method.isBeforeGroupsConfiguration()) {
            return "@BeforeGroups";
        }
        if (method.isBeforeMethodConfiguration()) {
            return "@BeforeMethod";
        }
        if (method.isAfterMethodConfiguration()) {
            return "@AfterMethod";
        }
        if (method.isAfterGroupsConfiguration()) {
            return "@AfterGroups";
        }
        if (method.isAfterClassConfiguration()) {
            return "@AfterClass";
        }
        if (method.isAfterTestConfiguration()) {
            return "@AfterTest";
        }
        if (method.isAfterSuiteConfiguration()) {
            return "@AfterSuite";
        }
        return "";
    }

    public static String arrayToString(String[] strings) {
        return String.join((CharSequence)", ", strings);
    }

    public static String replaceSpecialCharacters(String fileNameParameter) {
        String fileName = fileNameParameter;
        if (fileName == null || fileName.length() == 0) {
            return fileName;
        }
        for (char element : SPECIAL_CHARACTERS) {
            fileName = fileName.replace(element, '_');
        }
        return fileName;
    }

    public static <T> String join(List<T> objects, String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < objects.size(); ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(objects.get(i).toString());
        }
        return result.toString();
    }

    public static void checkInstanceOrStatic(Object instance, Method method) {
        if (instance == null && method != null && !Modifier.isStatic(method.getModifiers())) {
            throw new TestNGException("Can't invoke " + method + ": either make it static or add a no-args constructor to your class");
        }
    }

    public static void checkReturnType(Method method, Class<?> ... returnTypes) {
        if (method == null) {
            return;
        }
        for (Class<?> returnType : returnTypes) {
            if (method.getReturnType() != returnType) continue;
            return;
        }
        throw new TestNGException(method.getDeclaringClass().getName() + "." + method.getName() + " MUST return " + Utils.toString(returnTypes) + " but returns " + method.getReturnType().getName());
    }

    private static String toString(Class<?>[] classes) {
        StringBuilder sb = new StringBuilder("[ ");
        for (int i = 0; i < classes.length; ++i) {
            Class<?> clazz = classes[i];
            if (clazz.isArray()) {
                sb.append(clazz.getComponentType().getName()).append("[]");
            } else {
                sb.append(clazz.getName());
            }
            if (i + 1 >= classes.length) continue;
            sb.append(" or ");
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static String toString(Object obj) {
        String result = obj != null ? (obj instanceof boolean[] ? Arrays.toString((boolean[])obj) : (obj instanceof byte[] ? Arrays.toString((byte[])obj) : (obj instanceof char[] ? Arrays.toString((char[])obj) : (obj instanceof double[] ? Arrays.toString((double[])obj) : (obj instanceof float[] ? Arrays.toString((float[])obj) : (obj instanceof int[] ? Arrays.toString((int[])obj) : (obj instanceof long[] ? Arrays.toString((long[])obj) : (obj instanceof Object[] ? Arrays.deepToString((Object[])obj) : (obj instanceof short[] ? Arrays.toString((short[])obj) : obj.toString()))))))))) : "null";
        return result;
    }

    static {
        ESCAPES.put(Character.valueOf('<'), "&lt;");
        ESCAPES.put(Character.valueOf('>'), "&gt;");
        ESCAPES.put(Character.valueOf('\''), "&apos;");
        ESCAPES.put(Character.valueOf('\"'), "&quot;");
        ESCAPES.put(Character.valueOf('&'), "&amp;");
    }

    private static enum StackTraceType {
        SHORT,
        FULL;

    }
}

