/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testng.IInvokedMethod;
import org.testng.IMethodInstance;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.annotations.IConfigurationAnnotation;
import org.testng.annotations.ITestAnnotation;
import org.testng.annotations.ITestOrConfiguration;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.Graph;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodInheritance;
import org.testng.internal.MethodInstance;
import org.testng.internal.RunInfo;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.collections.Pair;

public class MethodHelper {
    private static final Map<ITestNGMethod[], Graph<ITestNGMethod>> GRAPH_CACHE = new ConcurrentHashMap<ITestNGMethod[], Graph<ITestNGMethod>>();
    private static final Map<Method, String> CANONICAL_NAME_CACHE = new ConcurrentHashMap<Method, String>();
    private static final Map<Pair<String, String>, Boolean> MATCH_CACHE = new ConcurrentHashMap<Pair<String, String>, Boolean>();

    public static ITestNGMethod[] collectAndOrderMethods(List<ITestNGMethod> methods, boolean forTests, RunInfo runInfo, IAnnotationFinder finder, boolean unique, List<ITestNGMethod> outExcludedMethods, Comparator<ITestNGMethod> comparator) {
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        MethodGroupsHelper.collectMethodsByGroup(methods.toArray(new ITestNGMethod[0]), forTests, includedMethods, outExcludedMethods, runInfo, finder, unique);
        return MethodHelper.sortMethods(forTests, includedMethods, comparator).toArray(new ITestNGMethod[0]);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m, List<ITestNGMethod> methods) {
        ITestNGMethod[] methodsArray = methods.toArray(new ITestNGMethod[0]);
        return MethodHelper.findDependedUponMethods(m, methodsArray);
    }

    protected static ITestNGMethod[] findDependedUponMethods(ITestNGMethod m, ITestNGMethod[] methods) {
        String canonicalMethodName = MethodHelper.calculateMethodCanonicalName(m);
        List vResult = Lists.newArrayList();
        String regexp = null;
        for (String fullyQualifiedRegexp : m.getMethodsDependedUpon()) {
            boolean foundAtLeastAMethod = false;
            if (null != fullyQualifiedRegexp) {
                int lastIndex;
                regexp = fullyQualifiedRegexp.replace("$", "\\$");
                MatchResults results = MethodHelper.matchMethod(methods, regexp);
                foundAtLeastAMethod = results.foundAtLeastAMethod;
                vResult.addAll(results.matchedMethods);
                if (!foundAtLeastAMethod && (lastIndex = regexp.lastIndexOf(46)) != -1) {
                    String newMethodName = m.getTestClass().getRealClass().getName() + regexp.substring(lastIndex);
                    results = MethodHelper.matchMethod(methods, newMethodName);
                    foundAtLeastAMethod = results.foundAtLeastAMethod;
                    vResult.addAll(results.matchedMethods);
                }
            }
            if (foundAtLeastAMethod || m.ignoreMissingDependencies() || m.isAlwaysRun()) continue;
            Method maybeReferringTo = MethodHelper.findMethodByName(m, regexp);
            if (maybeReferringTo != null) {
                throw new TestNGException(canonicalMethodName + "() is depending on method " + maybeReferringTo + ", which is not annotated with @Test or not included.");
            }
            throw new TestNGException(canonicalMethodName + "() depends on nonexistent method " + regexp);
        }
        return vResult.toArray(new ITestNGMethod[0]);
    }

    private static Method findMethodByName(ITestNGMethod testngMethod, String regExp) {
        String methodName;
        String className;
        if (regExp == null) {
            return null;
        }
        int lastDot = regExp.lastIndexOf(46);
        if (lastDot == -1) {
            className = testngMethod.getConstructorOrMethod().getDeclaringClass().getCanonicalName();
            methodName = regExp;
        } else {
            methodName = regExp.substring(lastDot + 1);
            className = regExp.substring(0, lastDot);
        }
        try {
            Class<?> c = Class.forName(className);
            for (Method m : c.getDeclaredMethods()) {
                if (!methodName.equals(m.getName())) continue;
                return m;
            }
        }
        catch (Exception e) {
            Utils.log("MethodHelper", 3, "Caught exception while searching for methods using regex");
        }
        return null;
    }

    protected static boolean isEnabled(Class<?> objectClass, IAnnotationFinder finder) {
        ITestAnnotation testClassAnnotation = AnnotationHelper.findTest(finder, objectClass);
        return MethodHelper.isEnabled(testClassAnnotation);
    }

    protected static boolean isEnabled(Method m, IAnnotationFinder finder) {
        ITestAnnotation annotation = AnnotationHelper.findTest(finder, m);
        if (null == annotation) {
            annotation = AnnotationHelper.findTest(finder, m.getDeclaringClass());
        }
        return MethodHelper.isEnabled(annotation);
    }

    protected static boolean isEnabled(ITestOrConfiguration test) {
        return null == test || test.getEnabled();
    }

    static boolean isDisabled(ITestOrConfiguration test) {
        return !MethodHelper.isEnabled(test);
    }

    static boolean isAlwaysRun(IConfigurationAnnotation configurationAnnotation) {
        if (null == configurationAnnotation) {
            return false;
        }
        boolean alwaysRun = false;
        if ((configurationAnnotation.getAfterSuite() || configurationAnnotation.getAfterTest() || configurationAnnotation.getAfterTestClass() || configurationAnnotation.getAfterTestMethod() || configurationAnnotation.getBeforeTestMethod() || configurationAnnotation.getBeforeTestClass() || configurationAnnotation.getBeforeTest() || configurationAnnotation.getBeforeSuite() || configurationAnnotation.getBeforeGroups().length != 0 || configurationAnnotation.getAfterGroups().length != 0) && configurationAnnotation.getAlwaysRun()) {
            alwaysRun = true;
        }
        return alwaysRun;
    }

    public static List<ITestNGMethod> uniqueMethodList(Collection<List<ITestNGMethod>> methods) {
        Set resultSet = Sets.newHashSet();
        for (List<ITestNGMethod> l : methods) {
            resultSet.addAll(l);
        }
        return Lists.newArrayList(resultSet);
    }

    private static Graph<ITestNGMethod> topologicalSort(ITestNGMethod[] methods, List<ITestNGMethod> sequentialList, List<ITestNGMethod> parallelList, Comparator<ITestNGMethod> comparator) {
        Graph<ITestNGMethod> result = new Graph<ITestNGMethod>((o1, o2) -> comparator.compare((ITestNGMethod)o1.getObject(), (ITestNGMethod)o2.getObject()));
        if (methods.length == 0) {
            return result;
        }
        Map<Object, List<ITestNGMethod>> testInstances = MethodHelper.sortMethodsByInstance(methods);
        for (ITestNGMethod m : methods) {
            result.addNode(m);
            List<ITestNGMethod> predecessors = Lists.newArrayList();
            String[] methodsDependedUpon = m.getMethodsDependedUpon();
            String[] groupsDependedUpon = m.getGroupsDependedUpon();
            if (methodsDependedUpon.length > 0) {
                ITestNGMethod[] methodsNamed;
                if (m.getInstance() != null) {
                    List<ITestNGMethod> instanceMethods = testInstances.get(m.getInstance());
                    try {
                        methodsNamed = MethodHelper.findDependedUponMethods(m, instanceMethods);
                    }
                    catch (TestNGException e) {
                        methodsNamed = MethodHelper.findDependedUponMethods(m, methods);
                    }
                } else {
                    methodsNamed = MethodHelper.findDependedUponMethods(m, methods);
                }
                predecessors.addAll(Arrays.asList(methodsNamed));
            }
            if (groupsDependedUpon.length > 0) {
                for (String group : groupsDependedUpon) {
                    ITestNGMethod[] methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m, methods, group);
                    predecessors.addAll(Arrays.asList(methodsThatBelongToGroup));
                }
            }
            for (ITestNGMethod predecessor : predecessors) {
                result.addPredecessor(m, predecessor);
            }
        }
        result.topologicalSort();
        sequentialList.addAll(result.getStrictlySortedNodes());
        parallelList.addAll(result.getIndependentNodes());
        return result;
    }

    private static Map<Object, List<ITestNGMethod>> sortMethodsByInstance(ITestNGMethod[] methods) {
        LinkedHashMap<Object, List<ITestNGMethod>> result = new LinkedHashMap<Object, List<ITestNGMethod>>();
        for (ITestNGMethod method : methods) {
            Object methodInstance = method.getInstance();
            if (methodInstance == null) continue;
            List<ITestNGMethod> methodList = result.get(methodInstance);
            if (methodList == null) {
                methodList = new ArrayList<ITestNGMethod>();
            }
            methodList.add(method);
            result.put(methodInstance, methodList);
        }
        return result;
    }

    protected static String calculateMethodCanonicalName(ITestNGMethod m) {
        return MethodHelper.calculateMethodCanonicalName(m.getConstructorOrMethod().getMethod());
    }

    private static String calculateMethodCanonicalName(Method m) {
        String result = CANONICAL_NAME_CACHE.get(m);
        if (result != null) {
            return result;
        }
        String packageName = m.getDeclaringClass().getName() + "." + m.getName();
        for (Class<?> cls = m.getDeclaringClass(); cls != Object.class; cls = cls.getSuperclass()) {
            try {
                if (cls.getDeclaredMethod(m.getName(), m.getParameterTypes()) == null) continue;
                packageName = cls.getName();
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        result = packageName + "." + m.getName();
        CANONICAL_NAME_CACHE.put(m, result);
        return result;
    }

    private static List<ITestNGMethod> sortMethods(boolean forTests, List<ITestNGMethod> allMethods, Comparator<ITestNGMethod> comparator) {
        List<ITestNGMethod> sl = Lists.newArrayList();
        List<ITestNGMethod> pl = Lists.newArrayList();
        ITestNGMethod[] allMethodsArray = allMethods.toArray(new ITestNGMethod[0]);
        if (!forTests && allMethodsArray.length > 0) {
            ITestNGMethod m = allMethodsArray[0];
            boolean before = m.isBeforeClassConfiguration() || m.isBeforeMethodConfiguration() || m.isBeforeSuiteConfiguration() || m.isBeforeTestConfiguration();
            MethodInheritance.fixMethodInheritance(allMethodsArray, before);
        }
        MethodHelper.topologicalSort(allMethodsArray, sl, pl, comparator);
        List<ITestNGMethod> result = Lists.newArrayList();
        result.addAll(sl);
        result.addAll(pl);
        return result;
    }

    public static List<ITestNGMethod> getMethodsDependedUpon(ITestNGMethod method, ITestNGMethod[] methods, Comparator<ITestNGMethod> comparator) {
        Graph<ITestNGMethod> g = GRAPH_CACHE.get(methods);
        if (g == null) {
            List<ITestNGMethod> parallelList = Lists.newArrayList();
            List<ITestNGMethod> sequentialList = Lists.newArrayList();
            g = MethodHelper.topologicalSort(methods, sequentialList, parallelList, comparator);
            GRAPH_CACHE.put(methods, g);
        }
        return g.findPredecessors(method);
    }

    public static void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        for (ITestNGMethod itm : methods) {
            itm.setTestClass(testCls);
            if (methodList == null) continue;
            methodList.add(itm);
        }
    }

    public static List<ITestNGMethod> invokedMethodsToMethods(Collection<IInvokedMethod> invokedMethods) {
        List<ITestNGMethod> result = Lists.newArrayList();
        for (IInvokedMethod im : invokedMethods) {
            ITestNGMethod tm = im.getTestMethod();
            tm.setDate(im.getDate());
            result.add(tm);
        }
        return result;
    }

    public static List<IMethodInstance> methodsToMethodInstances(List<ITestNGMethod> sl) {
        return sl.stream().map(MethodInstance::new).collect(Collectors.toList());
    }

    public static List<ITestNGMethod> methodInstancesToMethods(List<IMethodInstance> methodInstances) {
        return methodInstances.stream().map(IMethodInstance::getMethod).collect(Collectors.toList());
    }

    public static void dumpInvokedMethodsInfoToConsole(Collection<IInvokedMethod> iInvokedMethods, int currentVerbosity) {
        if (currentVerbosity < 3) {
            return;
        }
        System.out.println("===== Invoked methods");
        for (IInvokedMethod im : iInvokedMethods) {
            if (im.isTestMethod()) {
                System.out.print("    ");
            } else {
                if (!im.isConfigurationMethod()) continue;
                System.out.print("  ");
            }
            System.out.println("" + im);
        }
        System.out.println("=====");
    }

    protected static String calculateMethodCanonicalName(Class<?> methodClass, String methodName) {
        Set<Method> methods = ClassHelper.getAvailableMethods(methodClass);
        return methods.stream().filter(method -> methodName.equals(method.getName())).findFirst().map(MethodHelper::calculateMethodCanonicalName).orElse(null);
    }

    protected static long calculateTimeOut(ITestNGMethod tm) {
        return tm.getTimeOut() > 0L ? tm.getTimeOut() : tm.getInvocationTimeOut();
    }

    private static MatchResults matchMethod(ITestNGMethod[] methods, String regexp) {
        MatchResults results = new MatchResults();
        boolean usePackage = regexp.indexOf(46) != -1;
        Pattern pattern = Pattern.compile(regexp);
        for (ITestNGMethod method : methods) {
            ConstructorOrMethod thisMethod = method.getConstructorOrMethod();
            String thisMethodName = thisMethod.getName();
            String methodName = usePackage ? MethodHelper.calculateMethodCanonicalName(method) : thisMethodName;
            Pair<String, String> cacheKey = Pair.create(regexp, methodName);
            Boolean match = MATCH_CACHE.get(cacheKey);
            if (match == null) {
                match = pattern.matcher(methodName).matches();
                MATCH_CACHE.put(cacheKey, match);
            }
            if (!match.booleanValue()) continue;
            results.matchedMethods.add(method);
            results.foundAtLeastAMethod = true;
        }
        return results;
    }

    private static class MatchResults {
        private List<ITestNGMethod> matchedMethods = Lists.newArrayList();
        private boolean foundAtLeastAMethod = false;

        private MatchResults() {
        }
    }
}

