/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.IReporter;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.PropertyUtils;
import org.testng.internal.Utils;

public class ReporterConfig {
    private String m_className;
    private final List<Property> m_properties = Lists.newArrayList();

    public void addProperty(Property property) {
        this.m_properties.add(property);
    }

    public List<Property> getProperties() {
        return this.m_properties;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    public String serialize() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_className);
        if (!this.m_properties.isEmpty()) {
            sb.append(":");
            for (int i = 0; i < this.m_properties.size(); ++i) {
                Property property = this.m_properties.get(i);
                sb.append(property.name);
                sb.append("=");
                sb.append(property.value);
                if (i >= this.m_properties.size() - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static ReporterConfig deserialize(String inputString) {
        if (Utils.isStringEmpty(inputString)) {
            return null;
        }
        ReporterConfig reporterConfig = new ReporterConfig();
        int clsNameEndIndex = inputString.indexOf(58);
        if (clsNameEndIndex == -1) {
            reporterConfig.setClassName(inputString);
        } else {
            String[] props;
            reporterConfig.setClassName(inputString.substring(0, clsNameEndIndex));
            String propString = inputString.substring(clsNameEndIndex + 1, inputString.length());
            for (String prop : props = propString.split(",")) {
                String[] propNameAndVal = prop.split("=");
                if (propNameAndVal.length != 2) continue;
                reporterConfig.addProperty(new Property(propNameAndVal[0], propNameAndVal[1]));
            }
        }
        return reporterConfig;
    }

    public IReporter newReporterInstance() {
        Class<?> reporterClass = ClassHelper.forName(this.m_className);
        if (reporterClass == null) {
            return null;
        }
        Object tmp = ClassHelper.newInstance(reporterClass);
        if (!(tmp instanceof IReporter)) {
            throw new TestNGException(this.m_className + " is not a IReporter");
        }
        IReporter result = (IReporter)tmp;
        for (Property property : this.m_properties) {
            PropertyUtils.setProperty(result, property.name, property.value);
        }
        return result;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nClass = ").append(this.m_className);
        for (Property prop : this.m_properties) {
            buf.append("\n\t ").append(prop.name).append("=").append(prop.value);
        }
        return buf.toString();
    }

    public static class Property {
        private final String name;
        private final String value;

        public Property(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

