/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.lang.reflect.Constructor;
import java.util.List;
import org.testng.IClass;
import org.testng.IModuleFactory;
import org.testng.ITestContext;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassImpl;
import org.testng.internal.InstanceCreator;
import org.testng.internal.Utils;
import org.testng.internal.annotations.AnnotationHelper;

public class GuiceHelper {
    private final ITestContext context;

    GuiceHelper(ITestContext context) {
        this.context = context;
    }

    Injector getInjector(IClass iClass) {
        Injector injector;
        Guice guice = AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (guice == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Injector parentInjector = ((ClassImpl)iClass).getParentInjector();
        List<Module> moduleInstances = Lists.newArrayList(this.getModules(guice, parentInjector, iClass.getRealClass()));
        List<Module> moduleLookup = Lists.newArrayList(moduleInstances);
        Module parentModule = GuiceHelper.getParentModule(this.context);
        if (parentModule != null) {
            moduleInstances.add(parentModule);
        }
        if ((injector = this.context.getInjector(moduleLookup)) == null) {
            injector = GuiceHelper.createInjector(this.context, moduleInstances);
            this.context.addInjector(moduleInstances, injector);
        }
        return injector;
    }

    private static Module getParentModule(ITestContext context) {
        if (Utils.isStringEmpty(context.getSuite().getParentModule())) {
            return null;
        }
        Class<?> parentModule = ClassHelper.forName(context.getSuite().getParentModule());
        if (parentModule == null) {
            throw new TestNGException("Cannot load parent Guice module class: " + context.getSuite().getParentModule());
        }
        if (!Module.class.isAssignableFrom(parentModule)) {
            throw new TestNGException("Provided class is not a Guice module: " + parentModule.getName());
        }
        try {
            Constructor<?> moduleConstructor = parentModule.getDeclaredConstructor(ITestContext.class);
            return (Module)InstanceCreator.newInstance(moduleConstructor, context);
        }
        catch (NoSuchMethodException e) {
            return (Module)InstanceCreator.newInstance(parentModule);
        }
    }

    public static Injector createInjector(ITestContext context, List<Module> moduleInstances) {
        Module parentModule = GuiceHelper.getParentModule(context);
        List<Module> fullModules = Lists.newArrayList(moduleInstances);
        if (parentModule != null) {
            fullModules.add(parentModule);
        }
        Stage stage = Stage.DEVELOPMENT;
        String stageString = context.getSuite().getGuiceStage();
        if (Utils.isStringNotEmpty(stageString)) {
            stage = Stage.valueOf((String)stageString);
        }
        return com.google.inject.Guice.createInjector((Stage)stage, fullModules);
    }

    private List<Module> getModules(Guice guice, Injector parentInjector, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module moduleClass;
        List<Module> result = Lists.newArrayList();
        for (Class<? extends Module> moduleClass2 : guice.modules()) {
            List<Module> modules = this.context.getGuiceModules(moduleClass2);
            if (modules != null && !modules.isEmpty()) {
                result.addAll(modules);
                continue;
            }
            Module instance = (Module)parentInjector.getInstance(moduleClass2);
            result.add(instance);
            this.context.getGuiceModules(moduleClass2).add(instance);
        }
        Class<? extends IModuleFactory> factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (moduleClass = (factoryInstance = (IModuleFactory)parentInjector.getInstance(factory)).createModule(this.context, testClass)) != null) {
            result.add(moduleClass);
        }
        return result;
    }
}

