/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlScript;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class TestNGContentHandler
extends DefaultHandler {
    private XmlSuite m_currentSuite = null;
    private XmlTest m_currentTest = null;
    private List<String> m_currentDefines = null;
    private List<String> m_currentRuns = null;
    private List<XmlClass> m_currentClasses = null;
    private int m_currentTestIndex = 0;
    private int m_currentClassIndex = 0;
    private int m_currentIncludeIndex = 0;
    private List<XmlPackage> m_currentPackages = null;
    private XmlPackage m_currentPackage = null;
    private List<XmlSuite> m_suites = Lists.newArrayList();
    private XmlGroups m_currentGroups = null;
    private List<String> m_currentIncludedGroups = null;
    private List<String> m_currentExcludedGroups = null;
    private Map<String, String> m_currentTestParameters = null;
    private Map<String, String> m_currentSuiteParameters = null;
    private Map<String, String> m_currentClassParameters = null;
    private Include m_currentInclude;
    private List<String> m_currentMetaGroup = null;
    private String m_currentMetaGroupName;
    private Stack<Location> m_locations = new Stack();
    private XmlClass m_currentClass = null;
    private ArrayList<XmlInclude> m_currentIncludedMethods = null;
    private List<String> m_currentExcludedMethods = null;
    private ArrayList<XmlMethodSelector> m_currentSelectors = null;
    private XmlMethodSelector m_currentSelector = null;
    private String m_currentLanguage = null;
    private String m_currentExpression = null;
    private List<String> m_suiteFiles = Lists.newArrayList();
    private boolean m_enabledTest;
    private List<String> m_listeners;
    private String m_fileName;
    private boolean m_loadClasses;
    private boolean m_validate = false;
    private boolean m_hasWarn = false;

    public TestNGContentHandler(String fileName, boolean loadClasses) {
        this.m_fileName = fileName;
        this.m_loadClasses = loadClasses;
    }

    @Override
    public InputSource resolveEntity(String systemId, String publicId) throws IOException, SAXException {
        InputSource result;
        if ("http://beust.com/testng/testng-1.0.dtd".equals(publicId) || "http://testng.org/testng-1.0.dtd".equals(publicId)) {
            this.m_validate = true;
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("testng-1.0.dtd");
            if (null == is) {
                is = Thread.currentThread().getContextClassLoader().getResourceAsStream("testng-1.0.dtd");
                if (null == is) {
                    System.out.println("WARNING: couldn't find in classpath " + publicId + "\nFetching it from the Web site.");
                    result = super.resolveEntity(systemId, publicId);
                } else {
                    result = new InputSource(is);
                }
            } else {
                result = new InputSource(is);
            }
        } else {
            result = super.resolveEntity(systemId, publicId);
        }
        return result;
    }

    private void xmlSuiteFile(boolean start, Attributes attributes) {
        if (start) {
            String path = attributes.getValue("path");
            this.pushLocation(Location.SUITE);
            this.m_suiteFiles.add(path);
        } else {
            this.m_currentSuite.setSuiteFiles(this.m_suiteFiles);
            this.popLocation();
        }
    }

    private void xmlSuite(boolean start, Attributes attributes) {
        if (start) {
            String allowReturnValues;
            String preserveOrder;
            String objectFactory;
            String timeOut;
            String dataProviderThreadCount;
            String threadCount;
            String skip;
            String groupByInstances;
            XmlSuite.FailurePolicy configFailurePolicy;
            String guiceStage;
            String parentModule;
            String parallel;
            String jUnit;
            this.pushLocation(Location.SUITE);
            String name = attributes.getValue("name");
            if (Utils.isStringBlank(name)) {
                throw new TestNGException("The <suite> tag must define the name attribute");
            }
            this.m_currentSuite = new XmlSuite();
            this.m_currentSuite.setFileName(this.m_fileName);
            this.m_currentSuite.setName(name);
            this.m_currentSuiteParameters = Maps.newHashMap();
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentSuite.setVerbose(Integer.parseInt(verbose));
            }
            if (null != (jUnit = attributes.getValue("junit"))) {
                this.m_currentSuite.setJUnit(Boolean.valueOf(jUnit));
            }
            if ((parallel = attributes.getValue("parallel")) != null) {
                XmlSuite.ParallelMode mode = XmlSuite.ParallelMode.getValidParallel(parallel);
                if (mode != null) {
                    this.m_currentSuite.setParallel(mode);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' at suite level: '" + parallel + "'.");
                }
            }
            if ((parentModule = attributes.getValue("parent-module")) != null) {
                this.m_currentSuite.setParentModule(parentModule);
            }
            if ((guiceStage = attributes.getValue("guice-stage")) != null) {
                this.m_currentSuite.setGuiceStage(guiceStage);
            }
            if (null != (configFailurePolicy = XmlSuite.FailurePolicy.getValidPolicy(attributes.getValue("configfailurepolicy")))) {
                this.m_currentSuite.setConfigFailurePolicy(configFailurePolicy);
            }
            if ((groupByInstances = attributes.getValue("group-by-instances")) != null) {
                this.m_currentSuite.setGroupByInstances(Boolean.valueOf(groupByInstances));
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentSuite.setSkipFailedInvocationCounts(Boolean.valueOf(skip));
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentSuite.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (dataProviderThreadCount = attributes.getValue("data-provider-thread-count"))) {
                this.m_currentSuite.setDataProviderThreadCount(Integer.parseInt(dataProviderThreadCount));
            }
            if (null != (timeOut = attributes.getValue("time-out"))) {
                this.m_currentSuite.setTimeOut(timeOut);
            }
            if (null != (objectFactory = attributes.getValue("object-factory")) && this.m_loadClasses) {
                try {
                    this.m_currentSuite.setObjectFactory((ITestObjectFactory)Class.forName(objectFactory).newInstance());
                }
                catch (Exception e) {
                    Utils.log("Parser", 1, "[ERROR] Unable to create custom object factory '" + objectFactory + "' :" + e);
                }
            }
            if ((preserveOrder = attributes.getValue("preserve-order")) != null) {
                this.m_currentSuite.setPreserveOrder(Boolean.valueOf(preserveOrder));
            }
            if ((allowReturnValues = attributes.getValue("allow-return-values")) != null) {
                this.m_currentSuite.setAllowReturnValues(Boolean.valueOf(allowReturnValues));
            }
        } else {
            this.m_currentSuite.setParameters(this.m_currentSuiteParameters);
            this.m_suites.add(this.m_currentSuite);
            this.m_currentSuiteParameters = null;
            this.popLocation();
        }
    }

    private void xmlDefine(boolean start, Attributes attributes) {
        if (start) {
            String name = attributes.getValue("name");
            this.m_currentDefines = Lists.newArrayList();
            this.m_currentMetaGroup = Lists.newArrayList();
            this.m_currentMetaGroupName = name;
        } else {
            if (this.m_currentTest != null) {
                this.m_currentTest.addMetaGroup(this.m_currentMetaGroupName, this.m_currentMetaGroup);
            } else {
                XmlDefine define = new XmlDefine();
                define.setName(this.m_currentMetaGroupName);
                define.getIncludes().addAll(this.m_currentMetaGroup);
                this.m_currentGroups.addDefine(define);
            }
            this.m_currentDefines = null;
        }
    }

    private void xmlScript(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentLanguage = attributes.getValue("language");
            this.m_currentExpression = "";
        } else {
            XmlScript script = new XmlScript();
            script.setExpression(this.m_currentExpression);
            script.setLanguage(this.m_currentLanguage);
            this.m_currentSelector.setScript(script);
            if (this.m_locations.peek() == Location.TEST) {
                this.m_currentTest.setScript(script);
            }
            this.m_currentLanguage = null;
            this.m_currentExpression = null;
        }
    }

    private void xmlTest(boolean start, Attributes attributes) {
        if (start) {
            String timeOut;
            String threadCount;
            String parallel;
            String preserveOrder;
            String groupByInstances;
            String skip;
            String jUnit;
            this.m_currentTest = new XmlTest(this.m_currentSuite, this.m_currentTestIndex++);
            this.pushLocation(Location.TEST);
            this.m_currentTestParameters = Maps.newHashMap();
            String testName = attributes.getValue("name");
            if (Utils.isStringBlank(testName)) {
                throw new TestNGException("The <test> tag must define the name attribute");
            }
            this.m_currentTest.setName(attributes.getValue("name"));
            String verbose = attributes.getValue("verbose");
            if (null != verbose) {
                this.m_currentTest.setVerbose(Integer.parseInt(verbose));
            }
            if (null != (jUnit = attributes.getValue("junit"))) {
                this.m_currentTest.setJUnit(Boolean.valueOf(jUnit));
            }
            if ((skip = attributes.getValue("skipfailedinvocationcounts")) != null) {
                this.m_currentTest.setSkipFailedInvocationCounts(Boolean.valueOf(skip));
            }
            if ((groupByInstances = attributes.getValue("group-by-instances")) != null) {
                this.m_currentTest.setGroupByInstances(Boolean.valueOf(groupByInstances));
            }
            if ((preserveOrder = attributes.getValue("preserve-order")) != null) {
                this.m_currentTest.setPreserveOrder(Boolean.valueOf(preserveOrder));
            }
            if ((parallel = attributes.getValue("parallel")) != null) {
                XmlSuite.ParallelMode mode = XmlSuite.ParallelMode.getValidParallel(parallel);
                if (mode != null) {
                    this.m_currentTest.setParallel(mode);
                } else {
                    Utils.log("Parser", 1, "[WARN] Unknown value of attribute 'parallel' for test '" + this.m_currentTest.getName() + "': '" + parallel + "'");
                }
            }
            if (null != (threadCount = attributes.getValue("thread-count"))) {
                this.m_currentTest.setThreadCount(Integer.parseInt(threadCount));
            }
            if (null != (timeOut = attributes.getValue("time-out"))) {
                this.m_currentTest.setTimeOut(Long.parseLong(timeOut));
            }
            this.m_enabledTest = true;
            String enabledTestString = attributes.getValue("enabled");
            if (null != enabledTestString) {
                this.m_enabledTest = Boolean.valueOf(enabledTestString);
            }
        } else {
            if (null != this.m_currentTestParameters && this.m_currentTestParameters.size() > 0) {
                this.m_currentTest.setParameters(this.m_currentTestParameters);
            }
            if (null != this.m_currentClasses) {
                this.m_currentTest.setXmlClasses(this.m_currentClasses);
            }
            this.m_currentClasses = null;
            this.m_currentTest = null;
            this.m_currentTestParameters = null;
            this.popLocation();
            if (!this.m_enabledTest) {
                List<XmlTest> tests = this.m_currentSuite.getTests();
                tests.remove(tests.size() - 1);
            }
        }
    }

    public void xmlClasses(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentClasses = Lists.newArrayList();
            this.m_currentClassIndex = 0;
        } else {
            this.m_currentTest.setXmlClasses(this.m_currentClasses);
            this.m_currentClasses = null;
        }
    }

    public void xmlListeners(boolean start, Attributes attributes) {
        if (start) {
            this.m_listeners = Lists.newArrayList();
        } else if (null != this.m_listeners) {
            this.m_currentSuite.setListeners(this.m_listeners);
            this.m_listeners = null;
        }
    }

    public void xmlListener(boolean start, Attributes attributes) {
        if (start) {
            String listener = attributes.getValue("class-name");
            this.m_listeners.add(listener);
        }
    }

    public void xmlPackages(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentPackages = Lists.newArrayList();
        } else {
            if (null != this.m_currentPackages) {
                Location location = this.m_locations.peek();
                switch (location) {
                    case TEST: {
                        this.m_currentTest.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case SUITE: {
                        this.m_currentSuite.setXmlPackages(this.m_currentPackages);
                        break;
                    }
                    case CLASS: {
                        throw new UnsupportedOperationException("CLASS");
                    }
                    default: {
                        throw new AssertionError((Object)("Unexpected value: " + (Object)((Object)location)));
                    }
                }
            }
            this.m_currentPackages = null;
            this.m_currentPackage = null;
        }
    }

    public void xmlMethodSelectors(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelectors = new ArrayList();
        } else {
            switch (this.m_locations.peek()) {
                case TEST: {
                    this.m_currentTest.setMethodSelectors(this.m_currentSelectors);
                    break;
                }
                default: {
                    this.m_currentSuite.setMethodSelectors(this.m_currentSelectors);
                }
            }
            this.m_currentSelectors = null;
        }
    }

    public void xmlSelectorClass(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelector.setName(attributes.getValue("name"));
            String priority = attributes.getValue("priority");
            if (priority == null) {
                priority = "0";
            }
            this.m_currentSelector.setPriority(Integer.parseInt(priority));
        }
    }

    public void xmlMethodSelector(boolean start, Attributes attributes) {
        if (start) {
            this.m_currentSelector = new XmlMethodSelector();
        } else {
            this.m_currentSelectors.add(this.m_currentSelector);
            this.m_currentSelector = null;
        }
    }

    private void xmlMethod(boolean start) {
        if (start) {
            this.m_currentIncludedMethods = new ArrayList();
            this.m_currentExcludedMethods = Lists.newArrayList();
            this.m_currentIncludeIndex = 0;
        } else {
            this.m_currentClass.setIncludedMethods(this.m_currentIncludedMethods);
            this.m_currentClass.setExcludedMethods(this.m_currentExcludedMethods);
            this.m_currentIncludedMethods = null;
            this.m_currentExcludedMethods = null;
        }
    }

    public void xmlRun(boolean start, Attributes attributes) throws SAXException {
        if (start) {
            this.m_currentRuns = Lists.newArrayList();
        } else {
            if (this.m_currentTest != null) {
                this.m_currentTest.setIncludedGroups(this.m_currentIncludedGroups);
                this.m_currentTest.setExcludedGroups(this.m_currentExcludedGroups);
            } else {
                this.m_currentSuite.setIncludedGroups(this.m_currentIncludedGroups);
                this.m_currentSuite.setExcludedGroups(this.m_currentExcludedGroups);
            }
            this.m_currentRuns = null;
        }
    }

    public void xmlGroup(boolean start, Attributes attributes) throws SAXException {
        if (start) {
            this.m_currentTest.addXmlDependencyGroup(attributes.getValue("name"), attributes.getValue("depends-on"));
        }
    }

    public void xmlGroups(boolean start, Attributes attributes) throws SAXException {
        if (start) {
            this.m_currentGroups = new XmlGroups();
            this.m_currentIncludedGroups = Lists.newArrayList();
            this.m_currentExcludedGroups = Lists.newArrayList();
        } else {
            if (this.m_currentTest == null) {
                this.m_currentSuite.setGroups(this.m_currentGroups);
            }
            this.m_currentGroups = null;
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (!this.m_validate && !this.m_hasWarn) {
            Logger.getLogger(TestNGContentHandler.class).warn("It is strongly recommended to add \"<!DOCTYPE suite SYSTEM \"http://testng.org/testng-1.0.dtd\" >\" at the top of your file, otherwise TestNG may fail or not work as expected.");
            this.m_hasWarn = true;
        }
        String name = attributes.getValue("name");
        if ("suite".equals(qName)) {
            this.xmlSuite(true, attributes);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(true, attributes);
        } else if ("test".equals(qName)) {
            this.xmlTest(true, attributes);
        } else if ("script".equals(qName)) {
            this.xmlScript(true, attributes);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(true, attributes);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(true, attributes);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(true, attributes);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(true, attributes);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(true, attributes);
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(true, attributes);
        } else if ("listener".equals(qName)) {
            this.xmlListener(true, attributes);
        } else if ("class".equals(qName)) {
            if (null != this.m_currentClasses) {
                this.m_currentClass = new XmlClass(name, this.m_currentClassIndex++, this.m_loadClasses);
                this.m_currentClass.setXmlTest(this.m_currentTest);
                this.m_currentClassParameters = Maps.newHashMap();
                this.m_currentClasses.add(this.m_currentClass);
                this.pushLocation(Location.CLASS);
            }
        } else if ("package".equals(qName)) {
            if (null != this.m_currentPackages) {
                this.m_currentPackage = new XmlPackage();
                this.m_currentPackage.setName(name);
                this.m_currentPackages.add(this.m_currentPackage);
            }
        } else if ("define".equals(qName)) {
            this.xmlDefine(true, attributes);
        } else if ("run".equals(qName)) {
            this.xmlRun(true, attributes);
        } else if ("group".equals(qName)) {
            this.xmlGroup(true, attributes);
        } else if ("groups".equals(qName)) {
            this.xmlGroups(true, attributes);
        } else if ("methods".equals(qName)) {
            this.xmlMethod(true);
        } else if ("include".equals(qName)) {
            this.xmlInclude(true, attributes);
        } else if ("exclude".equals(qName)) {
            this.xmlExclude(true, attributes);
        } else if ("parameter".equals(qName)) {
            String value = TestNGContentHandler.expandValue(attributes.getValue("value"));
            Location location = this.m_locations.peek();
            switch (location) {
                case TEST: {
                    this.m_currentTestParameters.put(name, value);
                    break;
                }
                case SUITE: {
                    this.m_currentSuiteParameters.put(name, value);
                    break;
                }
                case CLASS: {
                    this.m_currentClassParameters.put(name, value);
                    break;
                }
                case INCLUDE: {
                    this.m_currentInclude.parameters.put(name, value);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected value: " + (Object)((Object)location)));
                }
            }
        }
    }

    private void xmlInclude(boolean start, Attributes attributes) {
        if (start) {
            this.m_locations.push(Location.INCLUDE);
            this.m_currentInclude = new Include(attributes.getValue("name"), attributes.getValue("invocation-numbers"));
            this.m_currentInclude.description = attributes.getValue("description");
        } else {
            String name = this.m_currentInclude.name;
            if (null != this.m_currentIncludedMethods) {
                String in = this.m_currentInclude.invocationNumbers;
                XmlInclude include = !Utils.isStringEmpty(in) ? new XmlInclude(name, this.stringToList(in), this.m_currentIncludeIndex++) : new XmlInclude(name, this.m_currentIncludeIndex++);
                for (Map.Entry<String, String> entry : this.m_currentInclude.parameters.entrySet()) {
                    include.addParameter(entry.getKey(), entry.getValue());
                }
                include.setDescription(this.m_currentInclude.description);
                this.m_currentIncludedMethods.add(include);
            } else if (null != this.m_currentDefines) {
                this.m_currentMetaGroup.add(name);
            } else if (null != this.m_currentRuns) {
                this.m_currentIncludedGroups.add(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getInclude().add(name);
            }
            this.popLocation();
            this.m_currentInclude = null;
        }
    }

    private void xmlExclude(boolean start, Attributes attributes) {
        if (start) {
            this.m_locations.push(Location.EXCLUDE);
            String name = attributes.getValue("name");
            if (null != this.m_currentExcludedMethods) {
                this.m_currentExcludedMethods.add(name);
            } else if (null != this.m_currentRuns) {
                this.m_currentExcludedGroups.add(name);
            } else if (null != this.m_currentPackage) {
                this.m_currentPackage.getExclude().add(name);
            }
        } else {
            this.popLocation();
        }
    }

    private void pushLocation(Location l) {
        this.m_locations.push(l);
    }

    private Location popLocation() {
        return this.m_locations.pop();
    }

    private List<Integer> stringToList(String in) {
        String[] numbers = in.split(" ");
        List<Integer> result = Lists.newArrayList();
        for (String n : numbers) {
            result.add(Integer.parseInt(n));
        }
        return result;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("suite".equals(qName)) {
            this.xmlSuite(false, null);
        } else if ("suite-file".equals(qName)) {
            this.xmlSuiteFile(false, null);
        } else if ("test".equals(qName)) {
            this.xmlTest(false, null);
        } else if ("define".equals(qName)) {
            this.xmlDefine(false, null);
        } else if ("run".equals(qName)) {
            this.xmlRun(false, null);
        } else if ("groups".equals(qName)) {
            this.xmlGroups(false, null);
        } else if ("methods".equals(qName)) {
            this.xmlMethod(false);
        } else if ("classes".equals(qName)) {
            this.xmlClasses(false, null);
        } else if ("packages".equals(qName)) {
            this.xmlPackages(false, null);
        } else if ("class".equals(qName)) {
            this.m_currentClass.setParameters(this.m_currentClassParameters);
            this.m_currentClassParameters = null;
            this.popLocation();
        } else if ("listeners".equals(qName)) {
            this.xmlListeners(false, null);
        } else if ("method-selector".equals(qName)) {
            this.xmlMethodSelector(false, null);
        } else if ("method-selectors".equals(qName)) {
            this.xmlMethodSelectors(false, null);
        } else if ("selector-class".equals(qName)) {
            this.xmlSelectorClass(false, null);
        } else if ("script".equals(qName)) {
            this.xmlScript(false, null);
        } else if ("include".equals(qName)) {
            this.xmlInclude(false, null);
        } else if ("exclude".equals(qName)) {
            this.xmlExclude(false, null);
        }
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        if (this.m_validate) {
            throw e;
        }
    }

    private boolean areWhiteSpaces(char[] ch, int start, int length) {
        for (int i = start; i < start + length; ++i) {
            char c = ch[i];
            if (c == '\n' || c == '\t' || c == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (null != this.m_currentLanguage && !this.areWhiteSpaces(ch, start, length)) {
            this.m_currentExpression = this.m_currentExpression + new String(ch, start, length);
        }
    }

    public XmlSuite getSuite() {
        return this.m_currentSuite;
    }

    private static String expandValue(String value) {
        int endIndex;
        int startIndex;
        StringBuilder result = null;
        int startPosition = 0;
        while ((startIndex = value.indexOf("${", startPosition)) > -1 && (endIndex = value.indexOf("}", startIndex + 3)) > -1) {
            String property = value.substring(startIndex + 2, endIndex);
            if (result == null) {
                result = new StringBuilder(value.substring(startPosition, startIndex));
            } else {
                result.append(value.substring(startPosition, startIndex));
            }
            String propertyValue = System.getProperty(property);
            if (propertyValue == null) {
                propertyValue = System.getenv(property);
            }
            if (propertyValue != null) {
                result.append(propertyValue);
            } else {
                result.append("${");
                result.append(property);
                result.append("}");
            }
            startPosition = startIndex + 3 + property.length();
        }
        if (result != null) {
            result.append(value.substring(startPosition));
            return result.toString();
        }
        return value;
    }

    private static class Include {
        String name;
        String invocationNumbers;
        String description;
        Map<String, String> parameters = Maps.newHashMap();

        Include(String name, String numbers) {
            this.name = name;
            this.invocationNumbers = numbers;
        }
    }

    static enum Location {
        SUITE,
        TEST,
        CLASS,
        INCLUDE,
        EXCLUDE;

    }
}

