/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.testng.collections.Lists;
import org.testng.internal.Utils;
import org.testng.internal.thread.ExecutorAdapter;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThreadFactory;
import org.testng.log4testng.Logger;

public class ThreadUtil {
    public static final String THREAD_NAME = "TestNG";

    public static boolean isTestNGThread() {
        return Thread.currentThread().getName().contains(THREAD_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String name, List<? extends Runnable> tasks, int threadPoolSize, long timeout, boolean triggerAtOnce) {
        Utils.log("ThreadUtil", 2, "Starting executor timeOut:" + timeout + "ms workers:" + tasks.size() + " threadPoolSize:" + threadPoolSize);
        ThreadPoolExecutor pooledExecutor = new ThreadPoolExecutor(threadPoolSize, threadPoolSize, timeout, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new TestNGThreadFactory(name));
        List callables = Lists.newArrayList();
        for (Runnable runnable : tasks) {
            callables.add(() -> {
                task.run();
                return null;
            });
        }
        try {
            if (timeout != 0L) {
                pooledExecutor.invokeAll(callables, timeout, TimeUnit.MILLISECONDS);
            } else {
                pooledExecutor.invokeAll(callables);
            }
        }
        catch (InterruptedException handled) {
            Logger.getLogger(ThreadUtil.class).error(handled.getMessage(), handled);
            Thread.currentThread().interrupt();
        }
        finally {
            pooledExecutor.shutdown();
        }
    }

    public static String currentThreadInfo() {
        Thread thread = Thread.currentThread();
        return thread.getName() + "@" + thread.hashCode();
    }

    public static IExecutor createExecutor(int threadCount, String threadFactoryName) {
        return new ExecutorAdapter(threadCount, ThreadUtil.createFactory(threadFactoryName));
    }

    private static IThreadFactory createFactory(String name) {
        return new ThreadFactoryImpl(name);
    }

    public static class ThreadFactoryImpl
    extends TestNGThreadFactory
    implements IThreadFactory {
        private final List<Thread> threads = Lists.newArrayList();

        public ThreadFactoryImpl(String name) {
            super("method=" + name);
        }

        @Override
        public Object getThreadFactory() {
            return this;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = super.newThread(r);
            this.threads.add(t);
            return t;
        }

        @Override
        public List<Thread> getThreads() {
            return this.threads;
        }
    }
}

