/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.ITestContext;
import org.testng.ITestResult;
import org.testng.TestNGException;
import org.testng.annotations.NoInjection;
import org.testng.internal.RuntimeBehavior;
import org.testng.internal.reflect.InjectableParameter;
import org.testng.internal.reflect.MethodMatcherException;
import org.testng.internal.reflect.Parameter;
import org.testng.xml.XmlTest;

public final class ReflectionRecipes {
    private static final Map<Class, Class> PRIMITIVE_MAPPING = new HashMap<Class, Class>();
    private static final Map<Class, List<Class>> ASSIGNABLE_MAPPING = new HashMap<Class, List<Class>>();

    private static void initPrimitiveMapping() {
        PRIMITIVE_MAPPING.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_MAPPING.put(Byte.TYPE, Byte.class);
        PRIMITIVE_MAPPING.put(Short.TYPE, Short.class);
        PRIMITIVE_MAPPING.put(Integer.TYPE, Integer.class);
        PRIMITIVE_MAPPING.put(Long.TYPE, Long.class);
        PRIMITIVE_MAPPING.put(Float.TYPE, Float.class);
        PRIMITIVE_MAPPING.put(Double.TYPE, Double.class);
        PRIMITIVE_MAPPING.put(Character.TYPE, Character.class);
        PRIMITIVE_MAPPING.put(Void.TYPE, Void.class);
    }

    private static void initAssignableMapping() {
        ASSIGNABLE_MAPPING.put(Double.TYPE, Arrays.asList(Float.class, Long.class, Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Float.TYPE, Arrays.asList(Long.class, Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Long.TYPE, Arrays.asList(Integer.class, Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Integer.TYPE, Arrays.asList(Short.class, Character.class, Byte.class));
        ASSIGNABLE_MAPPING.put(Short.TYPE, Arrays.asList(Character.class, Byte.class));
    }

    private ReflectionRecipes() {
        throw new TestNGException("Service is not meant to have instances");
    }

    public static boolean isInstanceOf(Class reference, Object object) {
        boolean isInstanceOf;
        if (object == null) {
            return !reference.isPrimitive();
        }
        boolean directInstance = reference.isInstance(object);
        if (!directInstance && reference.isPrimitive()) {
            isInstanceOf = PRIMITIVE_MAPPING.get(reference).isInstance(object);
            if (!isInstanceOf) {
                isInstanceOf = ASSIGNABLE_MAPPING.get(reference).contains(object.getClass());
            }
        } else {
            isInstanceOf = directInstance;
        }
        return isInstanceOf;
    }

    public static boolean isOrImplementsInterface(Class<?> reference, Class<?> clazz) {
        boolean implementsInterface = false;
        if (reference.isInterface()) {
            if (reference.equals(clazz)) {
                implementsInterface = true;
            } else {
                Class<?> interfaceClazz;
                Class<?>[] interfaces;
                Class<?>[] classArray = interfaces = clazz.getInterfaces();
                int n = classArray.length;
                for (int i = 0; i < n && !(implementsInterface = (interfaceClazz = classArray[i]).equals(reference)); ++i) {
                }
            }
        }
        return implementsInterface;
    }

    public static boolean isOrExtends(Class<?> reference, Class<?> clazz) {
        boolean extendsGiven = false;
        if (clazz != null && !reference.isInterface()) {
            extendsGiven = reference.equals(clazz) ? true : ReflectionRecipes.isOrExtends(reference, clazz.getSuperclass());
        }
        return extendsGiven;
    }

    public static Class<?>[] classesFromParameters(Parameter[] parameters) {
        Class[] classes = new Class[parameters.length];
        int i = 0;
        for (Parameter parameter : parameters) {
            classes[i] = parameter.getType();
            ++i;
        }
        return classes;
    }

    public static Parameter[] getMethodParameters(Method method) {
        if (method == null) {
            return new Parameter[0];
        }
        return ReflectionRecipes.getParameters(method.getParameterTypes(), method.getParameterAnnotations());
    }

    public static Parameter[] getConstructorParameters(Constructor constructor) {
        if (constructor == null) {
            return new Parameter[0];
        }
        return ReflectionRecipes.getParameters(constructor.getParameterTypes(), constructor.getParameterAnnotations());
    }

    private static Parameter[] getParameters(Class<?>[] parametersTypes, Annotation[][] parametersAnnotations) {
        Parameter[] parameters = new Parameter[parametersTypes.length];
        for (int i = 0; i < parametersTypes.length; ++i) {
            parameters[i] = new Parameter(i, parametersTypes[i], parametersAnnotations[i]);
        }
        return parameters;
    }

    public static boolean matchArrayEnding(Parameter[] parameters, Object[] param) {
        return ReflectionRecipes.matchArrayEnding(ReflectionRecipes.classesFromParameters(parameters), param);
    }

    public static boolean matchArrayEnding(Class<?>[] classes, Object[] args) {
        if (classes.length < 1) {
            return false;
        }
        if (!classes[classes.length - 1].isArray()) {
            return false;
        }
        boolean matching = true;
        int i = 0;
        if (classes.length <= args.length) {
            for (Class<?> clazz : classes) {
                if (i >= classes.length - 1) break;
                matching = ReflectionRecipes.isInstanceOf(clazz, args[i]);
                ++i;
                if (matching) {
                    continue;
                }
                break;
            }
        } else {
            matching = false;
        }
        if (matching) {
            Class<?> componentType = classes[classes.length - 1].getComponentType();
            while (i < args.length && (matching = ReflectionRecipes.isInstanceOf(componentType, args[i]))) {
                ++i;
            }
        }
        return matching;
    }

    public static boolean exactMatch(Parameter[] parameters, Object[] args) {
        return ReflectionRecipes.exactMatch(ReflectionRecipes.classesFromParameters(parameters), args);
    }

    public static boolean exactMatch(Class<?>[] classes, Object[] args) {
        boolean matching = true;
        if (classes.length == args.length) {
            int i = 0;
            for (Class<?> clazz : classes) {
                matching = ReflectionRecipes.isInstanceOf(clazz, args[i]);
                ++i;
                if (matching) {
                    continue;
                }
                break;
            }
        } else {
            matching = false;
        }
        return matching;
    }

    public static boolean lenientMatch(Parameter[] parameters, Object[] args) {
        return ReflectionRecipes.lenientMatch(ReflectionRecipes.classesFromParameters(parameters), args);
    }

    public static boolean lenientMatch(Class<?>[] classes, Object[] args) {
        boolean matching = true;
        int i = 0;
        for (Class<?> clazz : classes) {
            matching = ReflectionRecipes.isInstanceOf(clazz, args[i]);
            ++i;
            if (!matching) break;
        }
        return matching;
    }

    public static Parameter[] filter(Parameter[] parameters, Set<InjectableParameter> filters) {
        boolean proceed;
        boolean bl = proceed = filters != null && !filters.isEmpty();
        if (!proceed) {
            return parameters;
        }
        boolean firstMethodFiltered = false;
        ArrayList<Parameter> filterList = new ArrayList<Parameter>(parameters.length);
        for (Parameter parameter : parameters) {
            boolean omit = false;
            for (InjectableParameter injectableParameter : filters) {
                omit = ReflectionRecipes.canInject(parameter, injectableParameter);
                switch (injectableParameter) {
                    case CURRENT_TEST_METHOD: {
                        if (omit && !firstMethodFiltered) {
                            firstMethodFiltered = true;
                            break;
                        }
                        omit = false;
                        break;
                    }
                }
                if (!omit) continue;
                break;
            }
            if (omit) continue;
            filterList.add(parameter);
        }
        Parameter[] filteredArray = new Parameter[filterList.size()];
        return filterList.toArray(filteredArray);
    }

    public static Object[] inject(Parameter[] parameters, Set<InjectableParameter> filters, Object[] args, Method injectionMethod, ITestContext context, ITestResult testResult) {
        return ReflectionRecipes.nativelyInject(parameters, filters, args, injectionMethod, context, testResult);
    }

    private static Object[] nativelyInject(Parameter[] parameters, Set<InjectableParameter> filters, Object[] args, Object injectionMethod, ITestContext context, ITestResult testResult) {
        if (filters == null || filters.isEmpty()) {
            return args;
        }
        ArrayList<Object> arguments = new ArrayList<Object>(args.length);
        ListBackedImmutableQueue<Object> queue = new ListBackedImmutableQueue<Object>(args);
        boolean firstMethodInjected = false;
        for (Parameter parameter : parameters) {
            boolean inject = false;
            Object injectObject = null;
            for (InjectableParameter injectableParameter : filters) {
                inject = ReflectionRecipes.canInject(parameter, injectableParameter);
                if (!inject) continue;
                switch (injectableParameter) {
                    case CURRENT_TEST_METHOD: {
                        if (!firstMethodInjected) {
                            firstMethodInjected = true;
                            injectObject = injectionMethod;
                            break;
                        }
                        inject = false;
                        break;
                    }
                    case ITEST_CONTEXT: {
                        injectObject = context;
                        break;
                    }
                    case ITEST_RESULT: {
                        injectObject = testResult;
                        break;
                    }
                    case XML_TEST: {
                        injectObject = context != null ? context.getCurrentXmlTest() : null;
                        break;
                    }
                }
                if (!inject) continue;
                arguments.add(injectObject);
                break;
            }
            if (inject || ((ListBackedImmutableQueue)queue).backingList.isEmpty()) continue;
            arguments.add(queue.poll());
        }
        if (!((ListBackedImmutableQueue)queue).backingList.isEmpty()) {
            String prefix = "Missing one or more parameters that are being injected by the data provider. Please add the below arguments to the ";
            String msg = null;
            if (injectionMethod instanceof Method) {
                msg = MethodMatcherException.generateMessage(prefix + "method.", (Method)injectionMethod, ((ListBackedImmutableQueue)queue).backingList.toArray());
            } else if (injectionMethod instanceof Constructor) {
                msg = MethodMatcherException.generateMessage(prefix + "constructor.", (Constructor)injectionMethod, ((ListBackedImmutableQueue)queue).backingList.toArray());
            }
            boolean block = RuntimeBehavior.useStrictParameterMatching();
            if (block) {
                throw new MethodMatcherException(msg);
            }
            System.err.println(":::WARNING:::\n" + msg);
        }
        Object[] injectedArray = new Object[arguments.size()];
        return arguments.toArray(injectedArray);
    }

    public static Object[] inject(Parameter[] parameters, Set<InjectableParameter> filters, Object[] args, Constructor constructor, ITestContext context, ITestResult testResult) {
        return ReflectionRecipes.nativelyInject(parameters, filters, args, constructor, context, testResult);
    }

    private static boolean canInject(Parameter parameter, InjectableParameter injectableParameter) {
        boolean canInject = false;
        if (parameter != null) {
            boolean inject = !parameter.isAnnotationPresent(NoInjection.class);
            switch (injectableParameter) {
                case CURRENT_TEST_METHOD: {
                    boolean isMethod = ReflectionRecipes.isOrExtends(Method.class, parameter.getType());
                    canInject = inject && isMethod;
                    break;
                }
                case ITEST_CONTEXT: {
                    canInject = inject && ReflectionRecipes.isOrImplementsInterface(ITestContext.class, parameter.getType());
                    break;
                }
                case ITEST_RESULT: {
                    canInject = inject && ReflectionRecipes.isOrImplementsInterface(ITestResult.class, parameter.getType());
                    break;
                }
                case XML_TEST: {
                    canInject = inject && ReflectionRecipes.isOrExtends(XmlTest.class, parameter.getType());
                    break;
                }
                default: {
                    canInject = false;
                }
            }
        }
        return canInject;
    }

    static {
        ReflectionRecipes.initPrimitiveMapping();
        ReflectionRecipes.initAssignableMapping();
    }

    private static class ListBackedImmutableQueue<T> {
        private final List<T> backingList;

        ListBackedImmutableQueue(T[] elements) {
            this.backingList = new ArrayList<T>(elements.length);
            Collections.addAll(this.backingList, elements);
        }

        T poll() {
            if (!this.backingList.isEmpty()) {
                return this.backingList.remove(0);
            }
            throw new TestNGException("Queue exhausted");
        }
    }
}

