/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.testng.IClass;
import org.testng.IClassListener;
import org.testng.IDataProviderListener;
import org.testng.IInvokedMethodListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.SuiteRunState;
import org.testng.internal.ConfigInvoker;
import org.testng.internal.ConfigMethodArguments;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IConfiguration;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.TestInvoker;
import org.testng.internal.Utils;
import org.testng.xml.XmlSuite;

public class Invoker
implements IInvoker {
    static final BiPredicate<ITestNGMethod, IClass> CAN_RUN_FROM_CLASS = ITestNGMethod::canRunFromClass;
    static final BiPredicate<ITestNGMethod, IClass> SAME_CLASS = (m, c) -> c == null || m.getTestClass().getName().equals(c.getName());
    private final TestInvoker m_testInvoker;
    private final ConfigInvoker m_configInvoker;

    public Invoker(IConfiguration configuration, ITestContext testContext, ITestResultNotifier notifier, SuiteRunState state, boolean skipFailedInvocationCounts, Collection<IInvokedMethodListener> invokedMethodListeners, List<IClassListener> classListeners, Collection<IDataProviderListener> dataProviderListeners) {
        this.m_configInvoker = new ConfigInvoker(notifier, invokedMethodListeners, testContext, state, configuration);
        this.m_testInvoker = new TestInvoker(notifier, testContext, state, configuration, invokedMethodListeners, dataProviderListeners, classListeners, skipFailedInvocationCounts, this.m_configInvoker);
    }

    @Override
    public ConfigInvoker getConfigInvoker() {
        return this.m_configInvoker;
    }

    @Override
    public TestInvoker getTestInvoker() {
        return this.m_testInvoker;
    }

    @Override
    public void invokeConfigurations(IClass testClass, ITestNGMethod[] allMethods, XmlSuite suite, Map<String, String> params, Object[] parameterValues, Object instance) {
        ConfigMethodArguments attributes = new ConfigMethodArguments.Builder().forTestClass(testClass).usingConfigMethodsAs(allMethods).forSuite(suite).usingParameters(params).usingParameterValues(parameterValues).usingInstance(instance).build();
        this.m_configInvoker.invokeConfigurations(attributes);
    }

    @Override
    public List<ITestResult> invokeTestMethods(ITestNGMethod testMethod, Map<String, String> testParameters, ConfigurationGroupMethods groupMethods, Object instance, ITestContext testContext) {
        return this.m_testInvoker.invokeTestMethods(testMethod, groupMethods, instance, testContext);
    }

    static void log(int level, String s) {
        Utils.log("Invoker " + Thread.currentThread().hashCode(), level, s);
    }
}

