/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Map;
import org.testng.IClass;
import org.testng.ITestClassFinder;
import org.testng.ITestContext;
import org.testng.ITestObjectFactory;
import org.testng.collections.Maps;
import org.testng.internal.ClassImpl;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlClass;

public abstract class BaseClassFinder
implements ITestClassFinder {
    private final Map<Class<?>, IClass> m_classes = Maps.newLinkedHashMap();

    @Override
    public IClass getIClass(Class<?> cls) {
        return this.m_classes.get(cls);
    }

    protected void putIClass(Class<?> cls, IClass iClass) {
        if (!this.m_classes.containsKey(cls)) {
            this.m_classes.put(cls, iClass);
        }
    }

    protected IClass findOrCreateIClass(ITestContext context, Class<?> cls, XmlClass xmlClass, Object instance, IAnnotationFinder annotationFinder, ITestObjectFactory objectFactory) {
        return this.m_classes.computeIfAbsent(cls, key -> new ClassImpl(context, (Class<?>)key, xmlClass, instance, this.m_classes, annotationFinder, objectFactory));
    }

    @Deprecated
    protected Map getExistingClasses() {
        return this.m_classes;
    }

    protected boolean classExists(Class<?> cls) {
        return this.m_classes.containsKey(cls);
    }

    @Override
    public IClass[] findTestClasses() {
        return this.m_classes.values().toArray(new IClass[0]);
    }
}

