/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import javax.annotation.Nonnull;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.collections.Objects;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlSuite;

class SuiteResult
implements ISuiteResult,
Comparable {
    private String m_propertyFileName = null;
    private final XmlSuite m_suite;
    private final ITestContext m_testContext;

    protected SuiteResult(XmlSuite suite, ITestContext tr) {
        this.m_suite = suite;
        this.m_testContext = tr;
    }

    @Override
    public String getPropertyFileName() {
        return this.m_propertyFileName;
    }

    @Override
    public ITestContext getTestContext() {
        return this.m_testContext;
    }

    public XmlSuite getSuite() {
        return this.m_suite;
    }

    public int compareTo(@Nonnull Object o) {
        int result = 0;
        try {
            SuiteResult other = (SuiteResult)o;
            String n1 = this.getTestContext().getName();
            String n2 = other.getTestContext().getName();
            result = n1.compareTo(n2);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Logger.getLogger(SuiteResult.class).error(ex.getMessage(), ex);
        }
        return result;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("context", this.getTestContext().getName()).toString();
    }
}

