/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.List;
import org.testng.IClass;
import org.testng.IModuleFactory;
import org.testng.ITestContext;
import org.testng.TestClass;
import org.testng.annotations.Guice;
import org.testng.collections.Lists;
import org.testng.internal.ClassImpl;
import org.testng.internal.annotations.AnnotationHelper;

class GuiceHelper {
    private final ITestContext context;

    GuiceHelper(ITestContext context) {
        this.context = context;
    }

    Injector getInjector(IClass iClass) {
        Guice guice = AnnotationHelper.findAnnotationSuperClasses(Guice.class, iClass.getRealClass());
        if (guice == null) {
            return null;
        }
        if (iClass instanceof TestClass) {
            iClass = ((TestClass)iClass).getIClass();
        }
        if (!(iClass instanceof ClassImpl)) {
            return null;
        }
        Injector parentInjector = ((ClassImpl)iClass).getParentInjector();
        List<Module> moduleInstances = Lists.newArrayList(this.getModules(guice, parentInjector, iClass.getRealClass()));
        Injector injector = this.context.getInjector(moduleInstances);
        if (injector == null) {
            injector = parentInjector.createChildInjector(moduleInstances);
            this.context.addInjector(moduleInstances, injector);
        }
        return injector;
    }

    private List<Module> getModules(Guice guice, Injector parentInjector, Class<?> testClass) {
        IModuleFactory factoryInstance;
        Module moduleClass;
        List<Module> result = Lists.newArrayList();
        for (Class<? extends Module> moduleClass2 : guice.modules()) {
            List<Module> modules = this.context.getGuiceModules(moduleClass2);
            if (modules != null && !modules.isEmpty()) {
                result.addAll(modules);
                continue;
            }
            Module instance = (Module)parentInjector.getInstance(moduleClass2);
            result.add(instance);
            this.context.getGuiceModules(moduleClass2).add(instance);
        }
        Class<? extends IModuleFactory> factory = guice.moduleFactory();
        if (factory != IModuleFactory.class && (moduleClass = (factoryInstance = (IModuleFactory)parentInjector.getInstance(factory)).createModule(this.context, testClass)) != null) {
            result.add(moduleClass);
        }
        return result;
    }
}

