/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.testng.TestNGException;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlDependencies;
import org.testng.xml.XmlGroups;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlMethodSelector;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlUtils;
import org.testng.xml.dom.ParentSetter;

public class XmlTest
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 6533504325942417606L;
    public static final int DEFAULT_TIMEOUT_MS = Integer.MAX_VALUE;
    private XmlSuite m_suite;
    private String m_name;
    private Integer m_verbose = XmlSuite.DEFAULT_VERBOSE;
    private Boolean m_isJUnit = XmlSuite.DEFAULT_JUNIT;
    private int m_threadCount = -1;
    private List<XmlClass> m_xmlClasses = Lists.newArrayList();
    private List<String> m_includedGroups = Lists.newArrayList();
    private List<String> m_excludedGroups = Lists.newArrayList();
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private Map<String, String> m_parameters = Maps.newHashMap();
    private XmlSuite.ParallelMode m_parallel;
    private List<XmlMethodSelector> m_methodSelectors = Lists.newArrayList();
    private List<XmlPackage> m_xmlPackages = Lists.newArrayList();
    private String m_timeOut;
    private Boolean m_skipFailedInvocationCounts = XmlSuite.DEFAULT_SKIP_FAILED_INVOCATION_COUNTS;
    private Map<String, List<Integer>> m_failedInvocationNumbers = null;
    private Boolean m_preserveOrder = XmlSuite.DEFAULT_PRESERVE_ORDER;
    private int m_index;
    private Boolean m_groupByInstances;
    private Boolean m_allowReturnValues = null;
    private Map<String, String> m_xmlDependencyGroups = Maps.newHashMap();
    private XmlGroups m_xmlGroups;

    public XmlTest(XmlSuite xmlSuite, int n) {
        this.init(xmlSuite, n);
    }

    public XmlTest(XmlSuite xmlSuite) {
        this.init(xmlSuite, 0);
    }

    private void init(XmlSuite xmlSuite, int n) {
        this.m_suite = xmlSuite;
        this.m_suite.getTests().add(this);
        this.m_index = n;
        this.m_name = "Command line test " + UUID.randomUUID().toString();
    }

    public XmlTest() {
    }

    public void setXmlPackages(List<XmlPackage> list) {
        this.m_xmlPackages = Lists.newArrayList(list);
    }

    public List<XmlPackage> getXmlPackages() {
        return this.m_xmlPackages;
    }

    public List<XmlPackage> getPackages() {
        return this.getXmlPackages();
    }

    public void setPackages(List<XmlPackage> list) {
        this.setXmlPackages(list);
    }

    public List<XmlMethodSelector> getMethodSelectors() {
        return this.m_methodSelectors;
    }

    public void setMethodSelectors(List<XmlMethodSelector> list) {
        this.m_methodSelectors = Lists.newArrayList(list);
    }

    public XmlSuite getSuite() {
        return this.m_suite;
    }

    public List<String> getIncludedGroups() {
        List<String> list;
        if (this.m_xmlGroups != null) {
            list = this.m_xmlGroups.getRun().getIncludes();
            list.addAll(this.m_suite.getIncludedGroups());
        } else {
            list = Lists.newArrayList(this.m_includedGroups);
            list.addAll(this.m_suite.getIncludedGroups());
        }
        return list;
    }

    @Deprecated
    public void setClassNames(List<XmlClass> list) {
        this.m_xmlClasses = list;
    }

    public List<XmlClass> getXmlClasses() {
        return this.m_xmlClasses;
    }

    public List<XmlClass> getClasses() {
        return this.getXmlClasses();
    }

    public void setClasses(List<XmlClass> list) {
        this.setXmlClasses(list);
    }

    public void setXmlClasses(List<XmlClass> list) {
        this.m_xmlClasses = list;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public void setVerbose(int n) {
        this.m_verbose = n;
    }

    public int getThreadCount() {
        return this.m_threadCount > 0 ? this.m_threadCount : this.getSuite().getThreadCount();
    }

    public void setThreadCount(int n) {
        this.m_threadCount = n;
    }

    public void setIncludedGroups(List<String> list) {
        this.m_includedGroups = list;
    }

    public void setExcludedGroups(List<String> list) {
        this.m_excludedGroups = list;
    }

    public List<String> getExcludedGroups() {
        ArrayList<String> arrayList = new ArrayList<String>(this.m_excludedGroups);
        arrayList.addAll(this.m_suite.getExcludedGroups());
        return arrayList;
    }

    public void addIncludedGroup(String string) {
        this.m_includedGroups.add(string);
    }

    public void addExcludedGroup(String string) {
        this.m_excludedGroups.add(string);
    }

    public int getVerbose() {
        Integer n = this.m_verbose;
        if (null == n || XmlSuite.DEFAULT_VERBOSE.equals(this.m_verbose)) {
            n = this.m_suite.getVerbose();
        }
        if (null != n) {
            return n;
        }
        return 1;
    }

    public boolean getGroupByInstances() {
        Boolean bl = this.m_groupByInstances;
        if (bl == null || XmlSuite.DEFAULT_GROUP_BY_INSTANCES.equals(this.m_groupByInstances)) {
            bl = this.m_suite.getGroupByInstances();
        }
        if (bl != null) {
            return bl;
        }
        return XmlSuite.DEFAULT_GROUP_BY_INSTANCES;
    }

    public void setGroupByInstances(boolean bl) {
        this.m_groupByInstances = bl;
    }

    public boolean isJUnit() {
        Boolean bl = this.m_isJUnit;
        if (null == bl || XmlSuite.DEFAULT_JUNIT.equals(bl)) {
            bl = this.m_suite.isJUnit();
        }
        return bl;
    }

    public void setJUnit(boolean bl) {
        this.m_isJUnit = bl;
    }

    public void setJunit(boolean bl) {
        this.setJUnit(bl);
    }

    public void setSkipFailedInvocationCounts(boolean bl) {
        this.m_skipFailedInvocationCounts = bl;
    }

    public boolean skipFailedInvocationCounts() {
        Boolean bl = this.m_skipFailedInvocationCounts;
        if (null == bl) {
            bl = this.m_suite.skipFailedInvocationCounts();
        }
        return bl;
    }

    public void addMetaGroup(String string, List<String> list) {
        this.m_metaGroups.put(string, list);
    }

    public void setMetaGroups(Map<String, List<String>> map) {
        this.m_metaGroups = map;
    }

    public Map<String, List<String>> getMetaGroups() {
        if (this.m_xmlGroups != null) {
            Map<String, List<String>> map = Maps.newHashMap();
            List<XmlDefine> list = this.m_xmlGroups.getDefines();
            for (XmlDefine xmlDefine : list) {
                map.put(xmlDefine.getName(), xmlDefine.getIncludes());
            }
            return map;
        }
        return this.m_metaGroups;
    }

    public void setParameters(Map<String, String> map) {
        this.m_parameters = map;
    }

    public void addParameter(String string, String string2) {
        this.m_parameters.put(string, string2);
    }

    public String getParameter(String string) {
        String string2 = this.m_parameters.get(string);
        if (null == string2) {
            string2 = this.m_suite.getParameter(string);
        }
        return string2;
    }

    public Map<String, String> getAllParameters() {
        Map<String, String> map = Maps.newHashMap();
        map.putAll(this.getSuite().getParameters());
        map.putAll(this.m_parameters);
        return map;
    }

    public Map<String, String> getLocalParameters() {
        return this.m_parameters;
    }

    @Deprecated
    public Map<String, String> getParameters() {
        return this.getAllParameters();
    }

    @Deprecated
    public Map<String, String> getTestParameters() {
        return this.getLocalParameters();
    }

    public void setParallel(XmlSuite.ParallelMode parallelMode) {
        this.m_parallel = XmlSuite.ParallelMode.skipDeprecatedValues(parallelMode);
    }

    public XmlSuite.ParallelMode getParallel() {
        XmlSuite.ParallelMode parallelMode = null != this.m_parallel || XmlSuite.DEFAULT_PARALLEL.equals((Object)this.m_parallel) ? this.m_parallel : this.m_suite.getParallel();
        return parallelMode;
    }

    public String getTimeOut() {
        String string = null;
        string = null != this.m_timeOut ? this.m_timeOut : this.m_suite.getTimeOut();
        return string;
    }

    public long getTimeOut(long l) {
        long l2 = l;
        if (this.getTimeOut() != null) {
            l2 = Long.parseLong(this.getTimeOut());
        }
        return l2;
    }

    public void setTimeOut(long l) {
        this.m_timeOut = Long.toString(l);
    }

    private void setTimeOut(String string) {
        this.m_timeOut = string;
    }

    public void setExpression(String string) {
        this.setBeanShellExpression(string);
    }

    public void setBeanShellExpression(String string) {
        List<XmlMethodSelector> list = this.getMethodSelectors();
        if (list.size() > 0) {
            list.get(0).setExpression(string);
        } else if (string != null) {
            XmlMethodSelector xmlMethodSelector = new XmlMethodSelector();
            xmlMethodSelector.setExpression(string);
            xmlMethodSelector.setLanguage("BeanShell");
            this.getMethodSelectors().add(xmlMethodSelector);
        }
    }

    public String getExpression() {
        List<XmlMethodSelector> list = this.getMethodSelectors();
        if (list.size() > 0) {
            return list.get(0).getExpression();
        }
        return null;
    }

    public String toXml(String string) {
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        Properties properties = new Properties();
        properties.setProperty("name", this.getName());
        if (this.m_isJUnit != null) {
            XmlUtils.setProperty(properties, "junit", this.m_isJUnit.toString(), XmlSuite.DEFAULT_JUNIT.toString());
        }
        if (this.m_parallel != null) {
            XmlUtils.setProperty(properties, "parallel", this.m_parallel.toString(), XmlSuite.DEFAULT_PARALLEL.toString());
        }
        if (this.m_verbose != null) {
            XmlUtils.setProperty(properties, "verbose", this.m_verbose.toString(), XmlSuite.DEFAULT_VERBOSE.toString());
        }
        if (null != this.m_timeOut) {
            properties.setProperty("time-out", this.m_timeOut.toString());
        }
        if (this.m_preserveOrder != null && !XmlSuite.DEFAULT_PRESERVE_ORDER.equals(this.m_preserveOrder)) {
            properties.setProperty("preserve-order", this.m_preserveOrder.toString());
        }
        if (this.m_threadCount != -1) {
            properties.setProperty("thread-count", Integer.toString(this.m_threadCount));
        }
        if (this.m_groupByInstances != null) {
            XmlUtils.setProperty(properties, "group-by-instances", String.valueOf(this.getGroupByInstances()), XmlSuite.DEFAULT_GROUP_BY_INSTANCES.toString());
        }
        xMLStringBuffer.push("test", properties);
        if (null != this.getMethodSelectors() && !this.getMethodSelectors().isEmpty()) {
            xMLStringBuffer.push("method-selectors");
            for (XmlMethodSelector object2 : this.getMethodSelectors()) {
                xMLStringBuffer.getStringBuffer().append(object2.toXml(string + "    "));
            }
            xMLStringBuffer.pop("method-selectors");
        }
        XmlUtils.dumpParameters(xMLStringBuffer, this.m_parameters);
        if (!(this.m_metaGroups.isEmpty() && this.m_includedGroups.isEmpty() && this.m_excludedGroups.isEmpty() && this.m_xmlDependencyGroups.isEmpty())) {
            Object object;
            xMLStringBuffer.push("groups");
            for (Map.Entry entry : this.m_metaGroups.entrySet()) {
                object = (String)entry.getKey();
                List list = (List)entry.getValue();
                Properties properties2 = new Properties();
                properties2.setProperty("name", (String)object);
                xMLStringBuffer.push("define", properties2);
                for (String string2 : list) {
                    Properties properties3 = new Properties();
                    properties3.setProperty("name", string2);
                    xMLStringBuffer.addEmptyElement("include", properties3);
                }
                xMLStringBuffer.pop("define");
            }
            if (!this.m_includedGroups.isEmpty() || !this.m_excludedGroups.isEmpty()) {
                xMLStringBuffer.push("run");
                for (String string3 : this.m_includedGroups) {
                    object = new Properties();
                    ((Properties)object).setProperty("name", string3);
                    xMLStringBuffer.addEmptyElement("include", (Properties)object);
                }
                for (String string4 : this.m_excludedGroups) {
                    object = new Properties();
                    ((Properties)object).setProperty("name", string4);
                    xMLStringBuffer.addEmptyElement("exclude", (Properties)object);
                }
                xMLStringBuffer.pop("run");
            }
            if (this.m_xmlDependencyGroups != null && !this.m_xmlDependencyGroups.isEmpty()) {
                xMLStringBuffer.push("dependencies");
                for (Map.Entry entry : this.m_xmlDependencyGroups.entrySet()) {
                    xMLStringBuffer.addEmptyElement("group", "name", (String)entry.getKey(), "depends-on", (String)entry.getValue());
                }
                xMLStringBuffer.pop("dependencies");
            }
            xMLStringBuffer.pop("groups");
        }
        if (null != this.m_xmlPackages && !this.m_xmlPackages.isEmpty()) {
            xMLStringBuffer.push("packages");
            for (XmlPackage xmlPackage : this.m_xmlPackages) {
                xMLStringBuffer.getStringBuffer().append(xmlPackage.toXml("      "));
            }
            xMLStringBuffer.pop("packages");
        }
        if (null != this.getXmlClasses() && !this.getXmlClasses().isEmpty()) {
            xMLStringBuffer.push("classes");
            for (XmlClass xmlClass : this.getXmlClasses()) {
                xMLStringBuffer.getStringBuffer().append(xmlClass.toXml(string + "    "));
            }
            xMLStringBuffer.pop("classes");
        }
        xMLStringBuffer.pop("test");
        return xMLStringBuffer.toXML();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("[Test: \"").append(this.m_name).append("\"").append(" verbose:").append(this.m_verbose);
        stringBuilder.append("[parameters:");
        for (Map.Entry<String, String> object : this.m_parameters.entrySet()) {
            stringBuilder.append(object.getKey()).append("=>").append(object.getValue());
        }
        stringBuilder.append("]");
        stringBuilder.append("[metagroups:");
        for (Map.Entry<String, Object> entry : this.m_metaGroups.entrySet()) {
            stringBuilder.append(entry.getKey()).append("=");
            for (String string : (List)entry.getValue()) {
                stringBuilder.append(string).append(",");
            }
        }
        stringBuilder.append("] ");
        stringBuilder.append("[included: ");
        for (String string : this.m_includedGroups) {
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.append("]");
        stringBuilder.append("[excluded: ");
        for (String string : this.m_excludedGroups) {
            stringBuilder.append(string).append(" ");
        }
        stringBuilder.append("] ");
        stringBuilder.append(" classes:");
        for (XmlClass xmlClass : this.m_xmlClasses) {
            stringBuilder.append(xmlClass).append(" ");
        }
        stringBuilder.append(" packages:");
        for (XmlPackage xmlPackage : this.m_xmlPackages) {
            stringBuilder.append(xmlPackage).append(" ");
        }
        stringBuilder.append("] ");
        return stringBuilder.toString();
    }

    static void ppp(String string) {
        System.out.println("[XmlTest] " + string);
    }

    public Object clone() {
        XmlTest xmlTest = new XmlTest(this.getSuite());
        xmlTest.setName(this.getName());
        xmlTest.setIncludedGroups(this.getIncludedGroups());
        xmlTest.setExcludedGroups(this.getExcludedGroups());
        xmlTest.setJUnit(this.isJUnit());
        xmlTest.setParallel(this.getParallel());
        xmlTest.setVerbose(this.getVerbose());
        xmlTest.setParameters(this.getLocalParameters());
        xmlTest.setXmlPackages(this.getXmlPackages());
        xmlTest.setTimeOut(this.getTimeOut());
        Map<String, List<String>> map = this.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            xmlTest.addMetaGroup(entry.getKey(), entry.getValue());
        }
        return xmlTest;
    }

    public List<Integer> getInvocationNumbers(String string) {
        Object object;
        if (this.m_failedInvocationNumbers == null) {
            this.m_failedInvocationNumbers = Maps.newHashMap();
            object = this.getXmlClasses().iterator();
            while (object.hasNext()) {
                XmlClass xmlClass = (XmlClass)object.next();
                for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                    List<Integer> list = xmlInclude.getInvocationNumbers();
                    if (list.size() <= 0) continue;
                    String string2 = xmlClass.getName() + "." + xmlInclude.getName();
                    this.m_failedInvocationNumbers.put(string2, list);
                }
            }
        }
        if ((object = this.m_failedInvocationNumbers.get(string)) == null) {
            return Lists.newArrayList();
        }
        return object;
    }

    @Deprecated
    public void setPreserveOrder(String string) {
        this.setPreserveOrder(Boolean.valueOf(string));
    }

    public void setPreserveOrder(Boolean bl) {
        this.m_preserveOrder = bl;
    }

    public Boolean getPreserveOrder() {
        if (this.m_preserveOrder == null) {
            return this.m_suite.getPreserveOrder();
        }
        return this.m_preserveOrder;
    }

    public void setSuite(XmlSuite xmlSuite) {
        this.m_suite = xmlSuite;
    }

    public Boolean getAllowReturnValues() {
        if (this.m_allowReturnValues != null) {
            return this.m_allowReturnValues;
        }
        return this.getSuite().getAllowReturnValues();
    }

    public void setAllowReturnValues(Boolean bl) {
        this.m_allowReturnValues = bl;
    }

    public int getIndex() {
        return this.m_index;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_excludedGroups == null ? 0 : this.m_excludedGroups.hashCode());
        n = 31 * n + (this.m_failedInvocationNumbers == null ? 0 : this.m_failedInvocationNumbers.hashCode());
        n = 31 * n + (this.m_includedGroups == null ? 0 : this.m_includedGroups.hashCode());
        n = 31 * n + (this.m_isJUnit == null ? 0 : this.m_isJUnit.hashCode());
        n = 31 * n + (this.m_metaGroups == null ? 0 : this.m_metaGroups.hashCode());
        n = 31 * n + (this.m_methodSelectors == null ? 0 : this.m_methodSelectors.hashCode());
        n = 31 * n + (this.m_name == null ? 0 : this.m_name.hashCode());
        n = 31 * n + (this.m_parallel == null ? 0 : this.m_parallel.hashCode());
        n = 31 * n + (this.m_parameters == null ? 0 : this.m_parameters.hashCode());
        n = 31 * n + (this.m_preserveOrder == null ? 0 : this.m_preserveOrder.hashCode());
        n = 31 * n + (this.m_skipFailedInvocationCounts == null ? 0 : this.m_skipFailedInvocationCounts.hashCode());
        n = 31 * n + this.m_threadCount;
        n = 31 * n + (this.m_timeOut == null ? 0 : this.m_timeOut.hashCode());
        n = 31 * n + (this.m_verbose == null ? 0 : this.m_verbose.hashCode());
        n = 31 * n + (this.m_xmlClasses == null ? 0 : this.m_xmlClasses.hashCode());
        n = 31 * n + (this.m_xmlPackages == null ? 0 : this.m_xmlPackages.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return XmlSuite.f();
        }
        if (this.getClass() != object.getClass()) {
            return XmlSuite.f();
        }
        XmlTest xmlTest = (XmlTest)object;
        if (this.m_excludedGroups == null ? xmlTest.m_excludedGroups != null : !this.m_excludedGroups.equals(xmlTest.m_excludedGroups)) {
            return XmlSuite.f();
        }
        if (this.m_failedInvocationNumbers == null ? xmlTest.m_failedInvocationNumbers != null : !this.m_failedInvocationNumbers.equals(xmlTest.m_failedInvocationNumbers)) {
            return XmlSuite.f();
        }
        if (this.m_includedGroups == null ? xmlTest.m_includedGroups != null : !this.m_includedGroups.equals(xmlTest.m_includedGroups)) {
            return XmlSuite.f();
        }
        if (this.m_isJUnit == null ? xmlTest.m_isJUnit != null && !xmlTest.m_isJUnit.equals(XmlSuite.DEFAULT_JUNIT) : !this.m_isJUnit.equals(xmlTest.m_isJUnit)) {
            return XmlSuite.f();
        }
        if (this.m_metaGroups == null ? xmlTest.m_metaGroups != null : !this.m_metaGroups.equals(xmlTest.m_metaGroups)) {
            return XmlSuite.f();
        }
        if (this.m_methodSelectors == null ? xmlTest.m_methodSelectors != null : !this.m_methodSelectors.equals(xmlTest.m_methodSelectors)) {
            return XmlSuite.f();
        }
        if (this.m_name == null ? xmlTest.m_name != null : !this.m_name.equals(xmlTest.m_name)) {
            return XmlSuite.f();
        }
        if (this.m_parallel == null ? xmlTest.m_parallel != null : !this.m_parallel.equals((Object)xmlTest.m_parallel)) {
            return XmlSuite.f();
        }
        if (this.m_parameters == null ? xmlTest.m_parameters != null : !this.m_parameters.equals(xmlTest.m_parameters)) {
            return XmlSuite.f();
        }
        if (this.m_preserveOrder == null ? xmlTest.m_preserveOrder != null : !this.m_preserveOrder.equals(xmlTest.m_preserveOrder)) {
            return XmlSuite.f();
        }
        if (this.m_skipFailedInvocationCounts == null ? xmlTest.m_skipFailedInvocationCounts != null : !this.m_skipFailedInvocationCounts.equals(xmlTest.m_skipFailedInvocationCounts)) {
            return XmlSuite.f();
        }
        if (this.m_threadCount != xmlTest.m_threadCount) {
            return XmlSuite.f();
        }
        if (this.m_timeOut == null ? xmlTest.m_timeOut != null : !this.m_timeOut.equals(xmlTest.m_timeOut)) {
            return XmlSuite.f();
        }
        if (this.m_verbose == null ? xmlTest.m_verbose != null : !this.m_verbose.equals(xmlTest.m_verbose)) {
            return XmlSuite.f();
        }
        if (this.m_xmlClasses == null ? xmlTest.m_xmlClasses != null : !this.m_xmlClasses.equals(xmlTest.m_xmlClasses)) {
            return XmlSuite.f();
        }
        if (this.m_xmlPackages == null ? xmlTest.m_xmlPackages != null : !this.m_xmlPackages.equals(xmlTest.m_xmlPackages)) {
            return XmlSuite.f();
        }
        return true;
    }

    public void addXmlDependencyGroup(String string, String string2) {
        if (this.m_xmlDependencyGroups.containsKey(string)) {
            throw new TestNGException("Duplicate group dependency found for group \"" + string + "\"" + ", use a space-separated list of groups in the \"depends-on\" attribute");
        }
        this.m_xmlDependencyGroups.put(string, string2);
    }

    public Map<String, String> getXmlDependencyGroups() {
        if (this.m_xmlGroups != null) {
            Map<String, String> map = Maps.newHashMap();
            List<XmlDependencies> list = this.m_xmlGroups.getDependencies();
            for (XmlDependencies xmlDependencies : list) {
                map.putAll(xmlDependencies.getDependencies());
            }
            return map;
        }
        return this.m_xmlDependencyGroups;
    }

    @ParentSetter
    public void setXmlSuite(XmlSuite xmlSuite) {
        this.m_suite = xmlSuite;
    }

    public void setGroups(XmlGroups xmlGroups) {
        this.m_xmlGroups = xmlGroups;
    }
}

