/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import java.util.List;
import org.testng.collections.CollectionUtils;
import org.testng.collections.Lists;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlDefine;
import org.testng.xml.XmlDependencies;
import org.testng.xml.XmlRun;
import org.testng.xml.dom.Tag;

public class XmlGroups {
    private List<XmlDefine> m_defines = Lists.newArrayList();
    private XmlRun m_run;
    private List<XmlDependencies> m_dependencies = Lists.newArrayList();

    public List<XmlDefine> getDefines() {
        return this.m_defines;
    }

    @Tag(name="define")
    public void addDefine(XmlDefine xmlDefine) {
        this.getDefines().add(xmlDefine);
    }

    public void setDefines(List<XmlDefine> list) {
        this.m_defines = list;
    }

    public XmlRun getRun() {
        return this.m_run;
    }

    public void setRun(XmlRun xmlRun) {
        this.m_run = xmlRun;
    }

    public List<XmlDependencies> getDependencies() {
        return this.m_dependencies;
    }

    @Tag(name="dependencies")
    public void setXmlDependencies(XmlDependencies xmlDependencies) {
        this.m_dependencies.add(xmlDependencies);
    }

    public String toXml(String string) {
        boolean bl;
        XMLStringBuffer xMLStringBuffer = new XMLStringBuffer(string);
        String string2 = string + "  ";
        boolean bl2 = bl = CollectionUtils.hasElements(this.m_defines) || this.m_run != null || CollectionUtils.hasElements(this.m_dependencies);
        if (bl) {
            xMLStringBuffer.push("groups");
        }
        for (XmlDefine object : this.m_defines) {
            xMLStringBuffer.getStringBuffer().append(object.toXml(string2));
        }
        xMLStringBuffer.getStringBuffer().append(this.m_run.toXml(string2));
        for (XmlDependencies xmlDependencies : this.m_dependencies) {
            xMLStringBuffer.getStringBuffer().append(xmlDependencies.toXml(string2));
        }
        if (bl) {
            xMLStringBuffer.pop("groups");
        }
        return xMLStringBuffer.toXML();
    }
}

