/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters.jq;

import java.util.Set;
import org.testng.ISuite;
import org.testng.ITestNGMethod;
import org.testng.collections.Maps;
import org.testng.collections.SetMultiMap;
import org.testng.reporters.XMLStringBuffer;
import org.testng.reporters.jq.BaseMultiSuitePanel;
import org.testng.reporters.jq.Model;

public class IgnoredMethodsPanel
extends BaseMultiSuitePanel {
    public IgnoredMethodsPanel(Model model) {
        super(model);
    }

    @Override
    public String getPrefix() {
        return "ignored-methods-";
    }

    @Override
    public String getHeader(ISuite iSuite) {
        return IgnoredMethodsPanel.pluralize(iSuite.getExcludedMethods().size(), "ignored method");
    }

    @Override
    public String getContent(ISuite iSuite, XMLStringBuffer xMLStringBuffer) {
        XMLStringBuffer xMLStringBuffer2 = new XMLStringBuffer(xMLStringBuffer.getCurrentIndent());
        SetMultiMap<Class, ITestNGMethod> setMultiMap = Maps.newSetMultiMap();
        for (ITestNGMethod serializable : iSuite.getExcludedMethods()) {
            setMultiMap.put(serializable.getTestClass().getRealClass(), serializable);
        }
        for (Class clazz : setMultiMap.keySet()) {
            xMLStringBuffer2.push("div", "class", "ignored-class-div");
            xMLStringBuffer2.addRequired("span", clazz.getName(), "class", "ignored-class-name");
            xMLStringBuffer2.push("div", "class", "ignored-methods-div");
            for (ITestNGMethod iTestNGMethod : (Set)setMultiMap.get(clazz)) {
                xMLStringBuffer2.addRequired("span", iTestNGMethod.getMethodName(), "class", "ignored-method-name");
                xMLStringBuffer2.addEmptyElement("br");
            }
            xMLStringBuffer2.pop("div");
            xMLStringBuffer2.pop("div");
        }
        return xMLStringBuffer2.toXML();
    }

    @Override
    public String getNavigatorLink(ISuite iSuite) {
        return "Ignored methods";
    }
}

