/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.Utils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public class JUnitReportReporter
implements IReporter {
    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        Object object;
        Object object2;
        Map<Class<?>, Set<ITestResult>> map = Maps.newHashMap();
        ListMultiMap<Object, ITestResult> listMultiMap = Maps.newListMultiMap();
        ListMultiMap<Object, ITestResult> listMultiMap2 = Maps.newListMultiMap();
        for (ISuite object3 : list2) {
            object2 = object3.getResults();
            for (ISuiteResult iSuiteResult : object2.values()) {
                object = iSuiteResult.getTestContext();
                this.addResults(object.getPassedTests().getAllResults(), map);
                this.addResults(object.getFailedTests().getAllResults(), map);
                this.addResults(object.getSkippedTests().getAllResults(), map);
                this.addResults(object.getFailedConfigurations().getAllResults(), map);
                for (ITestResult iTestResult : object.getPassedConfigurations().getAllResults()) {
                    if (iTestResult.getMethod().isBeforeMethodConfiguration()) {
                        listMultiMap.put(iTestResult.getInstance(), iTestResult);
                    }
                    if (!iTestResult.getMethod().isAfterMethodConfiguration()) continue;
                    listMultiMap2.put(iTestResult.getInstance(), iTestResult);
                }
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            Properties properties;
            TestTag testTag;
            Object object32;
            object2 = (Class)entry.getKey();
            Properties properties2 = new Properties();
            properties2.setProperty("name", ((Class)object2).getName());
            Date date = Calendar.getInstance().getTime();
            properties2.setProperty("timestamp", date.toGMTString());
            object = Lists.newArrayList();
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            float f = 0.0f;
            for (Object object32 : (Set)entry.getValue()) {
                testTag = new TestTag();
                properties = new Properties();
                properties.setProperty("classname", ((Class)object2).getName());
                properties.setProperty("name", this.getTestName((ITestResult)object32));
                long l = object32.getEndMillis() - object32.getStartMillis();
                l += this.getNextConfiguration(listMultiMap, (ITestResult)object32);
                properties.setProperty("time", "" + this.formatTime(l += this.getNextConfiguration(listMultiMap2, (ITestResult)object32)));
                Throwable throwable = object32.getThrowable();
                switch (object32.getStatus()) {
                    case 1: {
                        break;
                    }
                    case 3: 
                    case 4: {
                        ++n3;
                        testTag.childTag = "skipped";
                        break;
                    }
                    case 2: {
                        if (throwable instanceof AssertionError) {
                            ++n;
                            testTag.childTag = "failure";
                        } else {
                            ++n2;
                            testTag.childTag = "error";
                        }
                        if (throwable == null) break;
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        throwable.printStackTrace(printWriter);
                        testTag.message = throwable.getMessage();
                        testTag.type = throwable.getClass().getName();
                        testTag.stackTrace = stringWriter.toString();
                    }
                }
                f += (float)l;
                ++n4;
                testTag.properties = properties;
                object.add(testTag);
            }
            properties2.setProperty("failures", "" + n);
            properties2.setProperty("errors", "" + n2);
            properties2.setProperty("skipped", "" + n3);
            properties2.setProperty("name", ((Class)object2).getName());
            properties2.setProperty("tests", "" + n4);
            properties2.setProperty("time", "" + this.formatTime(f));
            try {
                properties2.setProperty("hostname", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
            xMLStringBuffer.addComment("Generated by " + this.getClass().getName());
            xMLStringBuffer.push("testsuite", properties2);
            object32 = object.iterator();
            while (object32.hasNext()) {
                testTag = (TestTag)object32.next();
                if (!this.putElement(xMLStringBuffer, "testcase", testTag.properties, testTag.childTag != null)) continue;
                properties = new Properties();
                this.safeSetProperty(properties, "message", testTag.message);
                this.safeSetProperty(properties, "type", testTag.type);
                if (this.putElement(xMLStringBuffer, testTag.childTag, properties, testTag.stackTrace != null)) {
                    xMLStringBuffer.addCDATA(testTag.stackTrace);
                    xMLStringBuffer.pop(testTag.childTag);
                }
                xMLStringBuffer.pop("testcase");
            }
            xMLStringBuffer.pop("testsuite");
            object32 = string + File.separator + "junitreports";
            Utils.writeUtf8File((String)object32, this.getFileName((Class)object2), xMLStringBuffer.toXML());
        }
    }

    private boolean putElement(XMLStringBuffer xMLStringBuffer, String string, Properties properties, boolean bl) {
        if (bl) {
            xMLStringBuffer.push(string, properties);
        } else {
            xMLStringBuffer.addEmptyElement(string, properties);
        }
        return bl;
    }

    private void safeSetProperty(Properties properties, String string, String string2) {
        if (string2 != null) {
            properties.setProperty(string, string2);
        }
    }

    private long getNextConfiguration(ListMultiMap<Object, ITestResult> listMultiMap, ITestResult iTestResult) {
        long l = 0L;
        List list = (List)listMultiMap.get(iTestResult.getInstance());
        Map<ITestNGMethod, ITestResult> map = Maps.newHashMap();
        for (ITestResult iTestResult2 : list) {
            if (!map.containsKey(iTestResult2.getMethod())) {
                l += iTestResult2.getEndMillis() - iTestResult2.getStartMillis();
                map.put(iTestResult2.getMethod(), iTestResult2);
            }
            list.removeAll(map.values());
        }
        return l;
    }

    protected String getFileName(Class clazz) {
        return "TEST-" + clazz.getName() + ".xml";
    }

    protected String getTestName(ITestResult iTestResult) {
        return iTestResult.getMethod().getMethodName();
    }

    private String formatTime(float f) {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat("#.###", decimalFormatSymbols);
        decimalFormat.setMinimumFractionDigits(3);
        return decimalFormat.format(f / 1000.0f);
    }

    private void addResults(Set<ITestResult> set, Map<Class<?>, Set<ITestResult>> map) {
        for (ITestResult iTestResult : set) {
            Class<?> clazz = iTestResult.getMethod().getTestClass().getRealClass();
            Set<ITestResult> set2 = map.get(clazz);
            if (set2 == null) {
                set2 = Sets.newHashSet();
                map.put(clazz, set2);
            }
            set2.add(iTestResult);
        }
    }

    static class TestTag {
        public Properties properties;
        public String message;
        public String type;
        public String stackTrace;
        public String childTag;

        TestTag() {
        }
    }
}

