/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.Sets;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FailedReporter
extends TestListenerAdapter
implements IReporter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter() {
    }

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void generateReport(List<XmlSuite> list, List<ISuite> list2, String string) {
        for (ISuite iSuite : list2) {
            this.generateFailureSuite(iSuite.getXmlSuite(), iSuite, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void generateFailureSuite(XmlSuite xmlSuite, ISuite iSuite, String string) {
        Object object;
        XmlSuite xmlSuite2 = xmlSuite.shallowCopy();
        xmlSuite2.setName("Failed suite [" + xmlSuite.getName() + "]");
        this.m_xmlSuite = xmlSuite2;
        Map<String, Object> map = Maps.newHashMap();
        Object object2 = xmlSuite.getTests().iterator();
        while (object2.hasNext()) {
            object = object2.next();
            map.put(((XmlTest)object).getName(), object);
        }
        object = object2 = iSuite.getResults();
        synchronized (object) {
            for (Map.Entry entry : object2.entrySet()) {
                ISuiteResult iSuiteResult = (ISuiteResult)entry.getValue();
                ITestContext iTestContext = iSuiteResult.getTestContext();
                this.generateXmlTest(iSuite, (XmlTest)map.get(iTestContext.getName()), iTestContext, iTestContext.getFailedTests().getAllResults(), iTestContext.getSkippedTests().getAllResults());
            }
        }
        if (null != xmlSuite2.getTests() && xmlSuite2.getTests().size() > 0) {
            Utils.writeUtf8File(string, TESTNG_FAILED_XML, xmlSuite2.toXml());
            Utils.writeUtf8File(iSuite.getOutputDirectory(), TESTNG_FAILED_XML, xmlSuite2.toXml());
        }
    }

    @Override
    @Deprecated
    public void onFinish(ITestContext iTestContext) {
    }

    private void generateXmlTest(ISuite iSuite, XmlTest xmlTest, ITestContext iTestContext, Collection<ITestResult> collection, Collection<ITestResult> collection2) {
        if (collection2.size() > 0 || collection.size() > 0) {
            Set set = Sets.newHashSet();
            Collection[] collectionArray = new Collection[]{collection, collection2};
            for (Collection collection3 : collectionArray) {
                for (ITestResult iTestResult : collection3) {
                    ITestNGMethod iTestNGMethod = iTestResult.getMethod();
                    if (!iTestNGMethod.isTest()) continue;
                    set.add(iTestNGMethod);
                    ITestNGMethod iTestNGMethod2 = iTestResult.getMethod();
                    if (!iTestNGMethod2.isTest()) continue;
                    List<ITestNGMethod> list = MethodHelper.getMethodsDependedUpon(iTestNGMethod2, iTestContext.getAllTestMethods());
                    for (ITestNGMethod iTestNGMethod3 : list) {
                        if (!iTestNGMethod3.isTest()) continue;
                        set.add(iTestNGMethod3);
                    }
                }
            }
            List list = Lists.newArrayList();
            for (ITestNGMethod iTestNGMethod : iTestContext.getAllTestMethods()) {
                if (!set.contains(iTestNGMethod)) continue;
                list.add(iTestNGMethod);
            }
            set.clear();
            Collection<ITestNGMethod> collection4 = iSuite.getInvokedMethods();
            Iterator iterator = collection4.iterator();
            while (iterator.hasNext()) {
                ITestNGMethod iTestNGMethod = (ITestNGMethod)iterator.next();
                if (iTestNGMethod.isTest()) continue;
                set.add(iTestNGMethod);
            }
            list.addAll(set);
            this.createXmlTest(iTestContext, list, xmlTest);
        }
    }

    private void createXmlTest(ITestContext iTestContext, List<ITestNGMethod> list, XmlTest xmlTest) {
        XmlTest xmlTest2 = new XmlTest(this.m_xmlSuite);
        xmlTest2.setName(iTestContext.getName() + "(failed)");
        xmlTest2.setBeanShellExpression(xmlTest.getExpression());
        xmlTest2.setIncludedGroups(xmlTest.getIncludedGroups());
        xmlTest2.setExcludedGroups(xmlTest.getExcludedGroups());
        xmlTest2.setParallel(xmlTest.getParallel());
        xmlTest2.setParameters(xmlTest.getLocalParameters());
        xmlTest2.setJUnit(xmlTest.isJUnit());
        List<XmlClass> list2 = this.createXmlClasses(list, xmlTest);
        xmlTest2.setXmlClasses(list2);
    }

    /*
     * WARNING - void declaration
     */
    private List<XmlClass> createXmlClasses(List<ITestNGMethod> list, XmlTest xmlTest) {
        Serializable serializable;
        List<XmlClass> list2 = Lists.newArrayList();
        Map<Class<?>, Serializable> map = Maps.newHashMap();
        for (ITestNGMethod object : list) {
            Object[] objectArray = object.getInstances();
            Class<?> clazz = objectArray == null || objectArray.length == 0 || objectArray[0] == null ? object.getRealClass() : objectArray[0].getClass();
            serializable = (HashSet<ITestNGMethod>)map.get(clazz);
            if (null == serializable) {
                serializable = new HashSet<ITestNGMethod>();
                map.put(clazz, serializable);
            }
            serializable.add(object);
        }
        Map map2 = Maps.newHashMap();
        for (XmlClass xmlClass : xmlTest.getClasses()) {
            map2.putAll(xmlClass.getLocalParameters());
        }
        boolean bl = false;
        for (Map.Entry entry : map.entrySet()) {
            void var6_9;
            serializable = (Class)entry.getKey();
            Set set = (Set)entry.getValue();
            XmlClass xmlClass = new XmlClass(((Class)serializable).getName(), (int)(++var6_9), false);
            List<XmlInclude> list3 = Lists.newArrayList(set.size());
            int n = 0;
            for (ITestNGMethod iTestNGMethod : set) {
                XmlInclude xmlInclude = new XmlInclude(iTestNGMethod.getMethod().getName(), iTestNGMethod.getFailedInvocationNumbers(), n++);
                xmlInclude.setParameters(FailedReporter.findMethodLocalParameters(xmlTest, iTestNGMethod));
                list3.add(xmlInclude);
            }
            xmlClass.setIncludedMethods(list3);
            xmlClass.setParameters(map2);
            list2.add(xmlClass);
        }
        return list2;
    }

    private static Map<String, String> findMethodLocalParameters(XmlTest xmlTest, ITestNGMethod iTestNGMethod) {
        Class clazz = iTestNGMethod.getRealClass();
        for (XmlClass xmlClass : xmlTest.getClasses()) {
            if (clazz != xmlClass.getSupportClass()) continue;
            for (XmlInclude xmlInclude : xmlClass.getIncludedMethods()) {
                if (!xmlInclude.getName().equals(iTestNGMethod.getMethodName())) continue;
                return xmlInclude.getLocalParameters();
            }
        }
        return Collections.emptyMap();
    }

    private String getFileName(ITestContext iTestContext) {
        return TESTNG_FAILED_XML;
    }

    private static void ppp(String string) {
        System.out.println("[FailedReporter] " + string);
    }
}

