/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml.dom;

import java.lang.annotation.Annotation;
import java.util.List;
import org.testng.collections.Lists;
import org.testng.xml.dom.OnElement;
import org.testng.xml.dom.OnElementList;
import org.testng.xml.dom.Tag;
import org.testng.xml.dom.TagContent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Wrapper {
    private OnElement m_onElement;
    private OnElementList m_onElementList;
    private Tag m_tag;
    private TagContent m_tagContent;
    private Object m_bean;

    public Wrapper(Annotation annotation, Object object) {
        this.m_bean = object;
        if (annotation instanceof OnElement) {
            this.m_onElement = (OnElement)annotation;
        } else if (annotation instanceof OnElementList) {
            this.m_onElementList = (OnElementList)annotation;
        } else if (annotation instanceof Tag) {
            this.m_tag = (Tag)annotation;
        } else if (annotation instanceof TagContent) {
            this.m_tagContent = (TagContent)annotation;
        } else {
            throw new RuntimeException("Illegal annotation " + annotation);
        }
    }

    public String getTagName() {
        if (this.m_onElement != null) {
            return this.m_onElement.tag();
        }
        if (this.m_onElementList != null) {
            return this.m_onElementList.tag();
        }
        return this.m_tag.name();
    }

    public List<Object[]> getParameters(Element element) {
        List<Object[]> list = Lists.newArrayList();
        if (this.m_onElement != null) {
            List list2 = Lists.newArrayList();
            for (String string : this.m_onElement.attributes()) {
                list2.add(element.getAttribute(string));
            }
            list.add(list2.toArray());
        } else if (this.m_tag != null) {
            List list3 = Lists.newArrayList();
            list3.add(this.m_bean);
            list.add(list3.toArray());
        } else {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (!nodeList.item(i).hasAttributes()) continue;
                Element element2 = (Element)nodeList.item(i);
                List list4 = Lists.newArrayList();
                for (String string : this.m_onElementList.attributes()) {
                    list4.add(element2.getAttribute(string));
                }
                list.add(list4.toArray());
            }
        }
        return list;
    }
}

