/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.testng.ClassMethodMap;
import org.testng.IAttributes;
import org.testng.IClass;
import org.testng.IConfigurable;
import org.testng.IExecutionListener;
import org.testng.IHookable;
import org.testng.IInvokedMethodListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.IMethodSelector;
import org.testng.IReporter;
import org.testng.IResultMap;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.testng.ITestClass;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestNGListenerFactory;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.InstanceOrderingMethodInterceptor;
import org.testng.PreserveOrderMethodInterceptor;
import org.testng.TestClass;
import org.testng.TestNGException;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Attributes;
import org.testng.internal.ClassHelper;
import org.testng.internal.ClassInfoMap;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.Constants;
import org.testng.internal.DynamicGraph;
import org.testng.internal.IConfiguration;
import org.testng.internal.IConfigurationListener;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestResultNotifier;
import org.testng.internal.InvokedMethod;
import org.testng.internal.Invoker;
import org.testng.internal.MapList;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.MethodInstance;
import org.testng.internal.ResultMap;
import org.testng.internal.RunInfo;
import org.testng.internal.TestMethodWorker;
import org.testng.internal.TestNGClassFinder;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.XmlMethodSelector;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.IListeners;
import org.testng.internal.annotations.Sets;
import org.testng.internal.thread.ThreadUtil;
import org.testng.internal.thread.graph.GraphThreadPoolExecutor;
import org.testng.internal.thread.graph.IThreadWorkerFactory;
import org.testng.internal.thread.graph.IWorker;
import org.testng.junit.IJUnitTestRunner;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlPackage;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestRunner
implements ITestContext,
ITestResultNotifier,
IThreadWorkerFactory<ITestNGMethod> {
    private static final long serialVersionUID = 4247820024988306670L;
    private ISuite m_suite;
    private XmlTest m_xmlTest;
    private String m_testName;
    private transient List<XmlClass> m_testClassesFromXml = null;
    private transient List<XmlPackage> m_packageNamesFromXml = null;
    private transient IInvoker m_invoker = null;
    private transient IAnnotationFinder m_annotationFinder = null;
    private transient List<ITestListener> m_testListeners = Lists.newArrayList();
    private transient List<IConfigurationListener> m_configurationListeners = Lists.newArrayList();
    private transient IConfigurationListener m_confListener = new ConfigurationListener();
    private transient boolean m_skipFailedInvocationCounts;
    private ITestNGMethod[] m_allTestMethods = new ITestNGMethod[0];
    private Date m_startDate = null;
    private Date m_endDate = null;
    private transient Map<Class<?>, ITestClass> m_classMap = Maps.newHashMap();
    private String m_outputDirectory = Constants.getDefaultValueFor("testng.outputDir");
    private XmlMethodSelector m_xmlMethodSelector = new XmlMethodSelector();
    private static int m_verbose = 1;
    private ITestNGMethod[] m_beforeSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterSuiteMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_beforeXmlTestMethods = new ITestNGMethod[0];
    private ITestNGMethod[] m_afterXmlTestMethods = new ITestNGMethod[0];
    private List<ITestNGMethod> m_excludedMethods = Lists.newArrayList();
    private ConfigurationGroupMethods m_groupMethods = null;
    private Map<String, List<String>> m_metaGroups = Maps.newHashMap();
    private IResultMap m_passedTests = new ResultMap();
    private IResultMap m_failedTests = new ResultMap();
    private IResultMap m_failedButWithinSuccessPercentageTests = new ResultMap();
    private IResultMap m_skippedTests = new ResultMap();
    private RunInfo m_runInfo = new RunInfo();
    private String m_host;
    private transient IMethodInterceptor m_methodInterceptor;
    private transient ClassMethodMap m_classMethodMap;
    private transient TestNGClassFinder m_testClassFinder;
    private transient IConfiguration m_configuration;
    private List<InvokedMethod> m_invokedMethods = Lists.newArrayList();
    private IResultMap m_passedConfigurations = new ResultMap();
    private IResultMap m_skippedConfigurations = new ResultMap();
    private IResultMap m_failedConfigurations = new ResultMap();
    private IAttributes m_attributes = new Attributes();

    protected TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder finder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.init(configuration, suite, test, outputDirectory, finder, skipFailedInvocationCounts, invokedMethodListeners);
    }

    public TestRunner(IConfiguration configuration, ISuite suite, XmlTest test, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> listeners) {
        this.init(configuration, suite, test, suite.getOutputDirectory(), suite.getAnnotationFinder(test.getAnnotations()), skipFailedInvocationCounts, listeners);
    }

    private void init(IConfiguration configuration, ISuite suite, XmlTest test, String outputDirectory, IAnnotationFinder annotationFinder, boolean skipFailedInvocationCounts, List<IInvokedMethodListener> invokedMethodListeners) {
        this.m_configuration = configuration;
        this.m_xmlTest = test;
        this.m_suite = suite;
        this.m_testName = test.getName();
        this.m_host = suite.getHost();
        this.m_testClassesFromXml = test.getXmlClasses();
        this.m_skipFailedInvocationCounts = skipFailedInvocationCounts;
        this.setVerbose(test.getVerbose());
        boolean preserveOrder = "true".equalsIgnoreCase(test.getPreserveOrder());
        this.m_methodInterceptor = preserveOrder ? new PreserveOrderMethodInterceptor() : new InstanceOrderingMethodInterceptor();
        this.m_packageNamesFromXml = test.getXmlPackages();
        if (null != this.m_packageNamesFromXml) {
            for (XmlPackage xp : this.m_packageNamesFromXml) {
                this.m_testClassesFromXml.addAll(xp.getXmlClasses());
            }
        }
        this.m_annotationFinder = annotationFinder;
        this.m_invoker = new Invoker(this.m_configuration, this, this, this.m_suite.getSuiteState(), this.m_skipFailedInvocationCounts, invokedMethodListeners);
        if (suite.getParallel() != null) {
            this.log(3, "Running the tests in '" + test.getName() + "' with parallel mode:" + suite.getParallel());
        }
        this.setOutputDirectory(outputDirectory);
        this.init();
    }

    public IInvoker getInvoker() {
        return this.m_invoker;
    }

    public ITestNGMethod[] getBeforeSuiteMethods() {
        return this.m_beforeSuiteMethods;
    }

    public ITestNGMethod[] getAfterSuiteMethods() {
        return this.m_afterSuiteMethods;
    }

    public ITestNGMethod[] getBeforeTestConfigurationMethods() {
        return this.m_beforeXmlTestMethods;
    }

    public ITestNGMethod[] getAfterTestConfigurationMethods() {
        return this.m_afterXmlTestMethods;
    }

    private void init() {
        this.initMetaGroups(this.m_xmlTest);
        this.initRunInfo(this.m_xmlTest);
        if (!this.m_xmlTest.isJUnit()) {
            this.initMethods();
        }
        this.initListeners();
        this.addConfigurationListener(this.m_confListener);
    }

    private ListenerHolder findAllListeners(Class<?> cls) {
        ListenerHolder result = new ListenerHolder();
        result.listenerClasses = Lists.newArrayList();
        do {
            Class<? extends ITestNGListener>[] classes;
            IListeners l;
            if ((l = (IListeners)((Object)this.m_annotationFinder.findAnnotation(cls, IListeners.class))) == null) continue;
            for (Class<? extends ITestNGListener> c : classes = l.getValue()) {
                result.listenerClasses.add(c);
                if (!ITestNGListenerFactory.class.isAssignableFrom(c)) continue;
                if (result.listenerFactoryClass == null) {
                    result.listenerFactoryClass = c;
                    continue;
                }
                throw new TestNGException("Found more than one class implementingITestNGListenerFactory:" + c + " and " + result.listenerFactoryClass);
            }
        } while ((cls = cls.getSuperclass()) != Object.class);
        return result;
    }

    private void initListeners() {
        List<Class> listenerClasses = Lists.newArrayList();
        Class listenerFactoryClass = null;
        for (ITestClass cls : this.getTestClasses()) {
            Class realClass = cls.getRealClass();
            ListenerHolder listenerHolder = this.findAllListeners(realClass);
            if (listenerFactoryClass == null) {
                listenerFactoryClass = listenerHolder.listenerFactoryClass;
            }
            listenerClasses.addAll(listenerHolder.listenerClasses);
        }
        ITestNGListenerFactory listenerFactory = null;
        try {
            IClass ic;
            if (this.m_testClassFinder != null && (ic = this.m_testClassFinder.getIClass(listenerFactoryClass)) != null) {
                listenerFactory = (ITestNGListenerFactory)ic.getInstances(false)[0];
            }
            if (listenerFactory == null) {
                listenerFactory = listenerFactoryClass != null ? (ITestNGListenerFactory)listenerFactoryClass.newInstance() : null;
            }
        }
        catch (Exception ex) {
            throw new TestNGException("Couldn't instantiate the ITestNGListenerFactory: " + ex);
        }
        for (Class c : listenerClasses) {
            ITestNGListener listener;
            ITestNGListener iTestNGListener = listener = listenerFactory != null ? listenerFactory.createListener(c) : null;
            if (listener == null) {
                listener = ClassHelper.newInstance(c);
            }
            if (listener instanceof IMethodInterceptor) {
                this.setMethodInterceptor((IMethodInterceptor)listener);
            }
            if (listener instanceof ISuiteListener) {
                this.m_suite.addListener((ISuiteListener)listener);
            }
            if (listener instanceof IInvokedMethodListener) {
                this.m_suite.addListener(listener);
            }
            if (listener instanceof ITestListener) {
                this.addTestListener((ITestListener)listener);
            }
            if (listener instanceof IConfigurationListener) {
                this.addConfigurationListener((IConfigurationListener)listener);
            }
            if (listener instanceof IReporter) {
                this.m_suite.addListener(listener);
            }
            if (listener instanceof IConfigurable) {
                this.m_configuration.setConfigurable((IConfigurable)listener);
            }
            if (listener instanceof IHookable) {
                this.m_configuration.setHookable((IHookable)listener);
            }
            if (!(listener instanceof IExecutionListener)) continue;
            IExecutionListener iel = (IExecutionListener)listener;
            iel.onExecutionStart();
            this.m_configuration.addExecutionListener(iel);
        }
    }

    private void initMetaGroups(XmlTest xmlTest) {
        Map<String, List<String>> metaGroups = xmlTest.getMetaGroups();
        for (Map.Entry<String, List<String>> entry : metaGroups.entrySet()) {
            this.addMetaGroup(entry.getKey(), entry.getValue());
        }
    }

    private void initRunInfo(XmlTest xmlTest) {
        this.m_xmlMethodSelector.setIncludedGroups(this.createGroups(this.m_xmlTest.getIncludedGroups()));
        this.m_xmlMethodSelector.setExcludedGroups(this.createGroups(this.m_xmlTest.getExcludedGroups()));
        this.m_xmlMethodSelector.setExpression(this.m_xmlTest.getExpression());
        this.m_xmlMethodSelector.setXmlClasses(this.m_xmlTest.getXmlClasses());
        this.m_runInfo.addMethodSelector(this.m_xmlMethodSelector, 10);
        if (null != xmlTest.getMethodSelectors()) {
            for (org.testng.xml.XmlMethodSelector selector : xmlTest.getMethodSelectors()) {
                if (selector.getClassName() == null) continue;
                IMethodSelector s = ClassHelper.createSelector(selector);
                this.m_runInfo.addMethodSelector(s, selector.getPriority());
            }
        }
    }

    private void initMethods() {
        IClass[] classes;
        List<ITestNGMethod> beforeClassMethods = Lists.newArrayList();
        List<ITestNGMethod> testMethods = Lists.newArrayList();
        List<ITestNGMethod> afterClassMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> afterSuiteMethods = Lists.newArrayList();
        List<ITestNGMethod> beforeXmlTestMethods = Lists.newArrayList();
        List<ITestNGMethod> afterXmlTestMethods = Lists.newArrayList();
        ClassInfoMap classMap = new ClassInfoMap(this.m_testClassesFromXml);
        this.m_testClassFinder = new TestNGClassFinder(classMap, null, this.m_xmlTest, this.m_configuration, this);
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(this.m_runInfo, this.m_annotationFinder);
        this.m_runInfo.setTestMethods(testMethods);
        for (IClass ic : classes = this.m_testClassFinder.findTestClasses()) {
            TestClass tc = new TestClass(ic, testMethodFinder, this.m_annotationFinder, this.m_runInfo, this.m_xmlTest, classMap.getXmlClass(ic.getRealClass()));
            this.m_classMap.put(ic.getRealClass(), tc);
        }
        Map<String, List<ITestNGMethod>> beforeGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), true);
        Map<String, List<ITestNGMethod>> afterGroupMethods = MethodGroupsHelper.findGroupsMethods(this.m_classMap.values(), false);
        for (ITestClass tc : this.m_classMap.values()) {
            this.fixMethodsWithClass(tc.getTestMethods(), tc, testMethods);
            this.fixMethodsWithClass(tc.getBeforeClassMethods(), tc, beforeClassMethods);
            this.fixMethodsWithClass(tc.getBeforeTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterTestMethods(), tc, null);
            this.fixMethodsWithClass(tc.getAfterClassMethods(), tc, afterClassMethods);
            this.fixMethodsWithClass(tc.getBeforeSuiteMethods(), tc, beforeSuiteMethods);
            this.fixMethodsWithClass(tc.getAfterSuiteMethods(), tc, afterSuiteMethods);
            this.fixMethodsWithClass(tc.getBeforeTestConfigurationMethods(), tc, beforeXmlTestMethods);
            this.fixMethodsWithClass(tc.getAfterTestConfigurationMethods(), tc, afterXmlTestMethods);
            this.fixMethodsWithClass(tc.getBeforeGroupsMethods(), tc, MethodHelper.uniqueMethodList(beforeGroupMethods.values()));
            this.fixMethodsWithClass(tc.getAfterGroupsMethods(), tc, MethodHelper.uniqueMethodList(afterGroupMethods.values()));
        }
        this.m_beforeSuiteMethods = MethodHelper.collectAndOrderMethods(beforeSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_beforeXmlTestMethods = MethodHelper.collectAndOrderMethods(beforeXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_allTestMethods = MethodHelper.collectAndOrderMethods(testMethods, true, this.m_runInfo, this.m_annotationFinder, false, this.m_excludedMethods);
        this.m_classMethodMap = new ClassMethodMap(this.m_allTestMethods);
        this.m_afterXmlTestMethods = MethodHelper.collectAndOrderMethods(afterXmlTestMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_afterSuiteMethods = MethodHelper.collectAndOrderMethods(afterSuiteMethods, false, this.m_runInfo, this.m_annotationFinder, true, this.m_excludedMethods);
        this.m_groupMethods = new ConfigurationGroupMethods(this.m_allTestMethods, beforeGroupMethods, afterGroupMethods);
    }

    private void fixMethodsWithClass(ITestNGMethod[] methods, ITestClass testCls, List<ITestNGMethod> methodList) {
        for (ITestNGMethod itm : methods) {
            itm.setTestClass(testCls);
            if (methodList == null) continue;
            methodList.add(itm);
        }
    }

    public Collection<ITestClass> getTestClasses() {
        return this.m_classMap.values();
    }

    public void setTestName(String name) {
        this.m_testName = name;
    }

    public void setOutputDirectory(String od) {
        this.m_outputDirectory = od;
    }

    private void addMetaGroup(String name, List<String> groupNames) {
        this.m_metaGroups.put(name, groupNames);
    }

    private void collectGroups(String[] groups, List<String> unfinishedGroups, Map<String, String> result) {
        for (String gn : groups) {
            List<String> subGroups = this.m_metaGroups.get(gn);
            if (null == subGroups) continue;
            for (String sg : subGroups) {
                if (null != result.get(sg)) continue;
                result.put(sg, sg);
                unfinishedGroups.add(sg);
            }
        }
    }

    private Map<String, String> createGroups(List<String> groups) {
        return this.createGroups(groups.toArray(new String[groups.size()]));
    }

    private Map<String, String> createGroups(String[] groups) {
        Map<String, String> result = Maps.newHashMap();
        for (String group : groups) {
            result.put(group, group);
        }
        List<String> unfinishedGroups = Lists.newArrayList();
        if (this.m_metaGroups.size() > 0) {
            this.collectGroups(groups, unfinishedGroups, result);
            while (unfinishedGroups.size() > 0) {
                String[] uGroups = unfinishedGroups.toArray(new String[unfinishedGroups.size()]);
                unfinishedGroups = Lists.newArrayList();
                this.collectGroups(uGroups, unfinishedGroups, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.beforeRun();
        try {
            XmlTest test = this.getTest();
            if (test.isJUnit()) {
                this.privateRunJUnit(test);
            } else {
                this.privateRun(test);
            }
        }
        finally {
            this.afterRun();
        }
    }

    private void beforeRun() {
        this.m_startDate = new Date(System.currentTimeMillis());
        this.logStart();
        this.fireEvent(true);
        ITestNGMethod[] testConfigurationMethods = this.getBeforeTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null, null);
        }
    }

    private void privateRunJUnit(XmlTest xmlTest) {
        ClassInfoMap cim = new ClassInfoMap(this.m_testClassesFromXml);
        final Set<Class<?>> classes = cim.getClasses();
        final List runMethods = Lists.newArrayList();
        List workers = Lists.newArrayList();
        workers.add(new IWorker<ITestNGMethod>(){

            @Override
            public long getTimeOut() {
                return 0L;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (Class tc : classes) {
                    IJUnitTestRunner tr = ClassHelper.createTestRunner(TestRunner.this);
                    try {
                        tr.run(tc);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        runMethods.addAll(tr.getTestMethods());
                    }
                }
            }

            @Override
            public List<ITestNGMethod> getTasks() {
                throw new TestNGException("JUnit not supported");
            }

            @Override
            public int getPriority() {
                if (TestRunner.this.m_allTestMethods.length == 1) {
                    return TestRunner.this.m_allTestMethods[0].getPriority();
                }
                return 0;
            }

            @Override
            public int compareTo(IWorker<ITestNGMethod> other) {
                return this.getPriority() - other.getPriority();
            }
        });
        this.runWorkers(workers, "", null);
        this.m_allTestMethods = runMethods.toArray(new ITestNGMethod[runMethods.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void privateRun(XmlTest xmlTest) {
        boolean parallel;
        List<List<ITestNGMethod>> sequentialList = Lists.newArrayList();
        List<ITestNGMethod> parallelList = Lists.newArrayList();
        MapList<Integer, ITestNGMethod> sequentialMapList = new MapList<Integer, ITestNGMethod>();
        String parallelMode = xmlTest.getParallel();
        boolean bl = parallel = "methods".equals(parallelMode) || "true".equalsIgnoreCase(parallelMode) || "classes".equals(parallelMode);
        if (!parallel) {
            this.computeTestLists(sequentialList, parallelList, sequentialMapList);
            int seqCount = 0;
            for (List<ITestNGMethod> l : sequentialList) {
                seqCount += l.size();
            }
            this.log(3, "Found " + seqCount + " sequential methods and " + parallelList.size() + " parallel methods");
            if ("true".equalsIgnoreCase(xmlTest.getPreserveOrder())) {
                sequentialList = this.preserveClassOrder(xmlTest, sequentialList);
            }
            List<TestMethodWorker> workers = Lists.newArrayList();
            this.createSequentialWorkers(sequentialList, xmlTest, this.m_classMethodMap, workers);
            MapList<Integer, TestMethodWorker> ml = this.createSequentialWorkers(sequentialMapList, xmlTest.getParameters(), this.m_classMethodMap);
            this.createParallelWorkers(parallelList, xmlTest, this.m_classMethodMap, workers);
            try {
                Collections.sort(workers);
                this.runWorkers(workers, xmlTest.getParallel(), ml);
            }
            finally {
                this.m_classMethodMap.clear();
            }
        }
        int threadCount = xmlTest.getThreadCount();
        DynamicGraph<ITestNGMethod> graph = this.computeAlternateTestList(this.intercept(this.m_allTestMethods));
        if (graph.getNodeCount() > 0) {
            GraphThreadPoolExecutor<ITestNGMethod> executor = new GraphThreadPoolExecutor<ITestNGMethod>(graph, this, threadCount, threadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
            executor.run();
            try {
                long timeOut = this.m_xmlTest.getTimeOut(XmlTest.DEFAULT_TIMEOUT_MS);
                Utils.log("TestRunner", 2, "Starting executor for test " + this.m_xmlTest.getName() + " with time out:" + timeOut + " milliseconds.");
                executor.awaitTermination(timeOut, TimeUnit.MILLISECONDS);
                executor.shutdownNow();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private ITestNGMethod[] intercept(ITestNGMethod[] methods) {
        if (this.m_methodInterceptor == null) {
            return methods;
        }
        MethodInstance[] instances = this.methodsToMethodInstances(Arrays.asList(methods));
        List<IMethodInstance> resultInstances = this.m_methodInterceptor.intercept(Arrays.asList(instances), this);
        List result = Lists.newArrayList();
        for (IMethodInstance imi : resultInstances) {
            result.add(imi.getMethod());
        }
        return result.toArray(new ITestNGMethod[result.size()]);
    }

    private List<List<ITestNGMethod>> preserveClassOrder(XmlTest test, List<List<ITestNGMethod>> lists) {
        List<List<ITestNGMethod>> result = Lists.newArrayList();
        Map<String, List<Object>> classes = Maps.newHashMap();
        List<XmlClass> sortedClasses = Lists.newArrayList();
        for (XmlClass xmlClass : test.getXmlClasses()) {
            classes.put(xmlClass.getName(), new ArrayList());
            sortedClasses.add(xmlClass);
        }
        Collections.sort(sortedClasses, new Comparator<XmlClass>(){

            @Override
            public int compare(XmlClass arg0, XmlClass arg1) {
                return arg0.getIndex() - arg1.getIndex();
            }
        });
        for (List list : lists) {
            for (ITestNGMethod m : list) {
                String declaredClass = m.getTestClass().getName();
                List l = (List)classes.get(declaredClass);
                if (l == null) {
                    l = Lists.newArrayList();
                    classes.put(declaredClass, l);
                }
                l.add(m);
            }
        }
        List tmpResult = Lists.newArrayList();
        for (XmlClass xc : sortedClasses) {
            List methods = (List)classes.get(xc.getName());
            tmpResult.addAll(methods);
        }
        result.add(tmpResult);
        return result;
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(Set<ITestNGMethod> methods) {
        List<IWorker<ITestNGMethod>> result = Lists.newArrayList();
        Set sequentialClasses = Sets.newHashSet();
        for (ITestNGMethod m : methods) {
            Class cls = m.getRealClass();
            ITestAnnotation test = (ITestAnnotation)this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class);
            if ((test == null || !test.getSequential() && !test.getSingleThreaded()) && !"classes".equals(this.m_xmlTest.getParallel())) continue;
            sequentialClasses.add(cls);
        }
        List<IMethodInstance> methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : methods) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        methodInstances = this.m_methodInterceptor.intercept(methodInstances, this);
        Map<String, String> params = this.m_xmlTest.getParameters();
        Set processedClasses = Sets.newHashSet();
        for (IMethodInstance im : methodInstances) {
            TestMethodWorker worker;
            Class c = im.getMethod().getTestClass().getRealClass();
            if (sequentialClasses.contains(c)) {
                if (processedClasses.contains(c)) continue;
                processedClasses.add(c);
                if (System.getProperty("experimental") != null) {
                    List<IMethodInstance>[] instances;
                    for (List<IMethodInstance> inst : instances = this.createInstances(methodInstances)) {
                        TestMethodWorker worker2 = this.createTestMethodWorker(inst, params, c);
                        result.add(worker2);
                    }
                    continue;
                }
                worker = this.createTestMethodWorker(methodInstances, params, c);
                result.add(worker);
                continue;
            }
            worker = this.createTestMethodWorker(Arrays.asList(im), params, c);
            result.add(worker);
        }
        Collections.sort(result);
        return result;
    }

    private List<IMethodInstance>[] createInstances(List<IMethodInstance> methodInstances) {
        Map map = Maps.newHashMap();
        for (IMethodInstance imi : methodInstances) {
            for (Object o : imi.getInstances()) {
                System.out.println(o);
                List l = (List)map.get(o);
                if (l == null) {
                    l = Lists.newArrayList();
                    map.put(o, l);
                }
                l.add(imi);
            }
        }
        System.out.println(map);
        List[] result = new List[map.size()];
        int i = 0;
        for (List imi : map.values()) {
            result[i++] = imi;
        }
        return result;
    }

    private TestMethodWorker createTestMethodWorker(List<IMethodInstance> methodInstances, Map<String, String> params, Class<?> c) {
        return new TestMethodWorker(this.m_invoker, this.findClasses(methodInstances, c), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, this.m_classMethodMap, this);
    }

    private IMethodInstance[] findClasses(List<IMethodInstance> methodInstances, Class<?> c) {
        List result = Lists.newArrayList();
        for (IMethodInstance mi : methodInstances) {
            if (mi.getMethod().getTestClass().getRealClass() != c) continue;
            result.add(mi);
        }
        return result.toArray(new IMethodInstance[result.size()]);
    }

    private void createParallelWorkers(List<ITestNGMethod> parallel, XmlTest xmlTest, ClassMethodMap cmm, List<TestMethodWorker> workers) {
        if (parallel.isEmpty()) {
            return;
        }
        List<IMethodInstance> methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : parallel) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        methodInstances = this.m_methodInterceptor.intercept(methodInstances, this);
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "Will be run in random order:");
            for (IMethodInstance mi : methodInstances) {
                this.log(3, "  " + mi.getMethod());
                this.log(3, "      on instances");
                for (Object o : mi.getInstances()) {
                    this.log(3, "     " + o);
                }
            }
            this.log(3, "===");
        }
        Map<String, String> params = xmlTest.getParameters();
        for (IMethodInstance mi : methodInstances) {
            workers.add(new TestMethodWorker(this.m_invoker, new IMethodInstance[]{mi}, this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
        }
    }

    private Map<Class, Set<IMethodInstance>> groupMethodInstancesByClass(List<IMethodInstance> instances) {
        Map<Class, Set<IMethodInstance>> result = Maps.newHashMap();
        for (IMethodInstance mi : instances) {
            Class cl = mi.getMethod().getTestClass().getRealClass();
            Set<IMethodInstance> methods = result.get(cl);
            if (methods == null) {
                methods = new HashSet<IMethodInstance>();
                result.put(cl, methods);
            }
            methods.add(mi);
        }
        return result;
    }

    private void createSequentialWorkers(List<List<ITestNGMethod>> sequentialList, XmlTest xmlTest, ClassMethodMap cmm, List<TestMethodWorker> workers) {
        Map<String, String> params = xmlTest.getParameters();
        if (sequentialList.isEmpty()) {
            return;
        }
        Map map = Maps.newHashMap();
        for (List<ITestNGMethod> list : sequentialList) {
            for (ITestNGMethod m : list) {
                for (Object o : m.getInstances()) {
                    List l = (List)map.get(o);
                    if (l == null) {
                        l = Lists.newArrayList();
                        map.put(o, l);
                    }
                    l.add(m);
                }
            }
        }
        if (xmlTest.groupByInstances()) {
            for (Map.Entry entry : map.entrySet()) {
                List instances = Lists.newArrayList();
                for (ITestNGMethod m : (List)entry.getValue()) {
                    instances.add(new MethodInstance(m, new Object[]{entry.getKey()}));
                }
                workers.add(new TestMethodWorker(this.m_invoker, instances.toArray(new MethodInstance[instances.size()]), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
            }
        } else {
            for (List list : sequentialList) {
                workers.add(new TestMethodWorker(this.m_invoker, this.methodsToMethodInstances(list), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
            }
        }
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "Will be run sequentially:");
            for (List list : sequentialList) {
                for (ITestNGMethod tm : list) {
                    this.log(3, "  " + tm);
                }
                this.log(3, "====");
            }
            this.log(3, "===");
        }
    }

    private MapList<Integer, TestMethodWorker> createSequentialWorkers(MapList<Integer, ITestNGMethod> mapList, Map<String, String> params, ClassMethodMap cmm) {
        MapList<Integer, TestMethodWorker> result = new MapList<Integer, TestMethodWorker>();
        for (Integer i : mapList.getKeys()) {
            result.put(i, new TestMethodWorker(this.m_invoker, this.methodsToMethodInstances(mapList.get(i)), this.m_xmlTest.getSuite(), params, this.m_allTestMethods, this.m_groupMethods, cmm, this));
        }
        if (TestRunner.getVerbose() >= 2) {
            this.log(3, "Will be run sequentially:" + result);
        }
        return result;
    }

    private List<MethodInstance> methodsToMultipleMethodInstances(ITestNGMethod ... sl) {
        List<MethodInstance> vResult = Lists.newArrayList();
        for (ITestNGMethod m : sl) {
            Object[] instances;
            for (Object instance : instances = m.getTestClass().getInstances(true)) {
                vResult.add(new MethodInstance(m, new Object[]{instance}));
            }
        }
        return vResult;
    }

    private MethodInstance[] methodsToMethodInstances(List<ITestNGMethod> sl) {
        MethodInstance[] result = new MethodInstance[sl.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new MethodInstance(sl.get(i), sl.get(i).getTestClass().getInstances(true));
        }
        return result;
    }

    private void runWorkers(List<? extends IWorker<ITestNGMethod>> workers, String parallelMode, MapList<Integer, TestMethodWorker> sequentialWorkers) {
        if ("methods".equals(parallelMode) || "true".equalsIgnoreCase(parallelMode) || "classes".equals(parallelMode)) {
            long maxTimeOut = this.m_xmlTest.getTimeOut(XmlTest.DEFAULT_TIMEOUT_MS);
            for (IWorker<ITestNGMethod> iWorker : workers) {
                long mt = iWorker.getTimeOut();
                if (mt <= maxTimeOut) continue;
                maxTimeOut = mt;
            }
            ThreadUtil.execute(workers, this.m_xmlTest.getThreadCount(), maxTimeOut, false);
        } else {
            for (IWorker<ITestNGMethod> iWorker : workers) {
                iWorker.run();
            }
        }
    }

    private void afterRun() {
        ITestNGMethod[] testConfigurationMethods = this.getAfterTestConfigurationMethods();
        if (null != testConfigurationMethods && testConfigurationMethods.length > 0) {
            this.m_invoker.invokeConfigurations(null, testConfigurationMethods, this.m_xmlTest.getSuite(), this.m_xmlTest.getParameters(), null, null);
        }
        this.m_endDate = new Date(System.currentTimeMillis());
        if (TestRunner.getVerbose() >= 3) {
            this.dumpInvokedMethods();
        }
        this.fireEvent(false);
    }

    private boolean containsString(Map<String, String> regexps, String group) {
        for (String regexp : regexps.values()) {
            boolean match = Pattern.matches(regexp, group);
            if (!match) continue;
            return true;
        }
        return false;
    }

    private DynamicGraph<ITestNGMethod> computeAlternateTestList(ITestNGMethod[] methods) {
        DynamicGraph<ITestNGMethod> result = new DynamicGraph<ITestNGMethod>();
        Map<String, ITestNGMethod> map = Maps.newHashMap();
        MapList<String, ITestNGMethod> groups = new MapList<String, ITestNGMethod>();
        for (ITestNGMethod m : methods) {
            map.put(m.getTestClass().getName() + "." + m.getMethodName(), m);
            for (String g : m.getGroups()) {
                groups.put(g, m);
            }
        }
        Map methodsByPriority = Maps.newHashMap();
        for (ITestNGMethod m : methods) {
            List l = (List)methodsByPriority.get(m.getPriority());
            if (l == null) {
                l = Lists.newArrayList();
                methodsByPriority.put(m.getPriority(), l);
            }
            l.add(m);
        }
        boolean hasPriorities = methodsByPriority.size() > 1;
        for (ITestNGMethod m : methods) {
            String[] dependentMethods;
            result.addNode(m);
            if (hasPriorities) {
                for (Map.Entry e : methodsByPriority.entrySet()) {
                    if ((Integer)e.getKey() >= m.getPriority()) continue;
                    for (ITestNGMethod dm : (List)e.getValue()) {
                        result.addEdge(m, dm);
                    }
                }
            }
            if ((dependentMethods = m.getMethodsDependedUpon()) != null) {
                for (String d : dependentMethods) {
                    ITestNGMethod dm = (ITestNGMethod)map.get(d);
                    if (dm == null) {
                        throw new TestNGException("Method \"" + m + "\" depends on nonexistent method \"" + d + "\"");
                    }
                    result.addEdge(m, dm);
                }
            }
            String[] dependentGroups = m.getGroupsDependedUpon();
            for (String d : dependentGroups) {
                List dg = groups.get(d);
                if (dg == null) {
                    throw new TestNGException("Method \"" + m + "\" depends on nonexistent group \"" + d + "\"");
                }
                for (ITestNGMethod ddm : dg) {
                    result.addEdge(m, ddm);
                }
            }
        }
        return result;
    }

    private void computeTestLists(List<List<ITestNGMethod>> sl, List<ITestNGMethod> parallelList, MapList<Integer, ITestNGMethod> outSequentialList) {
        Map<String, String> groupsDependedUpon = Maps.newHashMap();
        Map<String, String> methodsDependedUpon = Maps.newHashMap();
        Map sequentialAttributeList = Maps.newHashMap();
        List<ITestNGMethod> sequentialList = Lists.newArrayList();
        for (int i = this.m_allTestMethods.length - 1; i >= 0; --i) {
            ITestNGMethod tm = this.m_allTestMethods[i];
            Class cls = tm.getRealClass();
            ITestAnnotation test = (ITestAnnotation)this.m_annotationFinder.findAnnotation(cls, ITestAnnotation.class);
            if (test != null && (test.getSequential() || test.getSingleThreaded())) {
                String className = tm.getTestClass().getName();
                List list = (List)sequentialAttributeList.get(className);
                if (list == null) {
                    list = Lists.newArrayList();
                    sequentialAttributeList.put(className, list);
                }
                list.add(0, tm);
                continue;
            }
            String[] currentGroups = tm.getGroups();
            String[] currentGroupsDependedUpon = tm.getGroupsDependedUpon();
            String[] currentMethodsDependedUpon = tm.getMethodsDependedUpon();
            String thisMethodName = tm.getMethod().getDeclaringClass().getName() + "." + tm.getMethod().getName();
            if (currentGroupsDependedUpon.length > 0) {
                for (String gdu : currentGroupsDependedUpon) {
                    groupsDependedUpon.put(gdu, gdu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (currentMethodsDependedUpon.length > 0) {
                for (String cmu : currentMethodsDependedUpon) {
                    methodsDependedUpon.put(cmu, cmu);
                }
                sequentialList.add(0, tm);
                continue;
            }
            if (this.containsString(methodsDependedUpon, thisMethodName)) {
                int index = 0;
                for (int j = 0; j < sequentialList.size(); ++j) {
                    ITestNGMethod m = sequentialList.get(j);
                    if (!this.arrayContains(m.getMethodsDependedUpon(), thisMethodName)) continue;
                    index = j;
                    break;
                }
                sequentialList.add(index, tm);
                continue;
            }
            if (currentGroups.length > 0) {
                boolean isSequential = false;
                for (String group : currentGroups) {
                    if (!this.containsString(groupsDependedUpon, group)) continue;
                    sequentialList.add(0, tm);
                    isSequential = true;
                    break;
                }
                if (isSequential) continue;
                parallelList.add(0, tm);
                continue;
            }
            parallelList.add(0, tm);
        }
        if (sequentialList.size() > 0) {
            sl.add(sequentialList);
        }
        String previousGroup = "";
        int index = 0;
        for (ITestNGMethod m : sequentialList) {
            String[] g = m.getGroupsDependedUpon();
            if (g.length > 0 && !m.getGroupsDependedUpon()[0].equals(previousGroup)) {
                ++index;
                previousGroup = m.getGroupsDependedUpon()[0];
            }
            outSequentialList.put(index, m);
        }
        sl.addAll(sequentialAttributeList.values());
    }

    private boolean arrayContains(String[] array, String element) {
        for (String a : array) {
            if (!element.equals(a)) continue;
            return true;
        }
        return false;
    }

    private void logStart() {
        this.log(3, "Running test " + this.m_testName + " on " + this.m_classMap.size() + " " + " classes, " + " included groups:[" + this.mapToString(this.m_xmlMethodSelector.getIncludedGroups()) + "] excluded groups:[" + this.mapToString(this.m_xmlMethodSelector.getExcludedGroups()) + "]");
        if (TestRunner.getVerbose() >= 3) {
            for (ITestClass tc : this.m_classMap.values()) {
                ((TestClass)tc).dump();
            }
        }
    }

    private void fireEvent(boolean isStart) {
        for (ITestListener itl : this.m_testListeners) {
            if (isStart) {
                itl.onStart(this);
                continue;
            }
            itl.onFinish(this);
        }
    }

    @Override
    public String getName() {
        return this.m_testName;
    }

    @Override
    public Date getStartDate() {
        return this.m_startDate;
    }

    @Override
    public Date getEndDate() {
        return this.m_endDate;
    }

    @Override
    public IResultMap getPassedTests() {
        return this.m_passedTests;
    }

    @Override
    public IResultMap getSkippedTests() {
        return this.m_skippedTests;
    }

    @Override
    public IResultMap getFailedTests() {
        return this.m_failedTests;
    }

    @Override
    public IResultMap getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    @Override
    public String[] getIncludedGroups() {
        Map<String, String> ig = this.m_xmlMethodSelector.getIncludedGroups();
        String[] result = ig.values().toArray(new String[ig.size()]);
        return result;
    }

    @Override
    public String[] getExcludedGroups() {
        Map<String, String> eg = this.m_xmlMethodSelector.getExcludedGroups();
        String[] result = eg.values().toArray(new String[eg.size()]);
        return result;
    }

    @Override
    public String getOutputDirectory() {
        return this.m_outputDirectory;
    }

    @Override
    public ISuite getSuite() {
        return this.m_suite;
    }

    @Override
    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods;
    }

    @Override
    public String getHost() {
        return this.m_host;
    }

    @Override
    public Collection<ITestNGMethod> getExcludedMethods() {
        Map<ITestNGMethod, ITestNGMethod> vResult = Maps.newHashMap();
        for (ITestNGMethod m : this.m_excludedMethods) {
            vResult.put(m, m);
        }
        return vResult.keySet();
    }

    @Override
    public IResultMap getFailedConfigurations() {
        return this.m_failedConfigurations;
    }

    @Override
    public IResultMap getPassedConfigurations() {
        return this.m_passedConfigurations;
    }

    @Override
    public IResultMap getSkippedConfigurations() {
        return this.m_skippedConfigurations;
    }

    @Override
    public void addPassedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_passedTests.addResult(tr, tm);
    }

    @Override
    public Set<ITestResult> getPassedTests(ITestNGMethod tm) {
        return this.m_passedTests.getResults(tm);
    }

    @Override
    public Set<ITestResult> getFailedTests(ITestNGMethod tm) {
        return this.m_failedTests.getResults(tm);
    }

    @Override
    public Set<ITestResult> getSkippedTests(ITestNGMethod tm) {
        return this.m_skippedTests.getResults(tm);
    }

    @Override
    public void addSkippedTest(ITestNGMethod tm, ITestResult tr) {
        this.m_skippedTests.addResult(tr, tm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInvokedMethod(InvokedMethod im) {
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            this.m_invokedMethods.add(im);
        }
    }

    @Override
    public void addFailedTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, false);
    }

    @Override
    public void addFailedButWithinSuccessPercentageTest(ITestNGMethod testMethod, ITestResult result) {
        this.logFailedTest(testMethod, result, true);
    }

    @Override
    public XmlTest getTest() {
        return this.m_xmlTest;
    }

    @Override
    public List<ITestListener> getTestListeners() {
        return this.m_testListeners;
    }

    @Override
    public List<IConfigurationListener> getConfigurationListeners() {
        return this.m_configurationListeners;
    }

    private void logFailedTest(ITestNGMethod method, ITestResult tr, boolean withinSuccessPercentage) {
        if (withinSuccessPercentage) {
            this.m_failedButWithinSuccessPercentageTests.addResult(tr, method);
        } else {
            this.m_failedTests.addResult(tr, method);
        }
    }

    private String mapToString(Map<?, ?> m) {
        StringBuffer result = new StringBuffer();
        for (Object o : m.values()) {
            result.append(o.toString()).append(" ");
        }
        return result.toString();
    }

    private void log(int level, String s) {
        Utils.log("TestRunner", level, s);
    }

    public static int getVerbose() {
        return m_verbose;
    }

    public void setVerbose(int n) {
        m_verbose = n;
    }

    private void log(String s) {
        Utils.log("TestRunner", 2, s);
    }

    public void addListener(Object listener) {
        if (listener instanceof ITestListener) {
            this.addTestListener((ITestListener)listener);
        }
        if (listener instanceof IConfigurationListener) {
            this.addConfigurationListener((IConfigurationListener)listener);
        }
    }

    public void addTestListener(ITestListener il) {
        this.m_testListeners.add(il);
    }

    private void addConfigurationListener(IConfigurationListener icl) {
        this.m_configurationListeners.add(icl);
    }

    private void dumpInvokedMethods() {
        System.out.println("\n*********** INVOKED METHODS\n");
        for (InvokedMethod im : this.m_invokedMethods) {
            if (im.isTestMethod()) {
                System.out.print("\t\t");
            } else {
                if (!im.isConfigurationMethod()) continue;
                System.out.print("\t");
            }
            System.out.println("" + im);
        }
        System.out.println("\n***********\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ITestNGMethod> getInvokedMethods() {
        List<ITestNGMethod> result = Lists.newArrayList();
        List<InvokedMethod> list = this.m_invokedMethods;
        synchronized (list) {
            for (InvokedMethod im : this.m_invokedMethods) {
                ITestNGMethod tm = im.getTestMethod();
                tm.setDate(im.getDate());
                result.add(tm);
            }
        }
        return result;
    }

    public void setMethodInterceptor(IMethodInterceptor methodInterceptor) {
        this.m_methodInterceptor = methodInterceptor;
    }

    @Override
    public XmlTest getCurrentXmlTest() {
        return this.m_xmlTest;
    }

    @Override
    public Object getAttribute(String name) {
        return this.m_attributes.getAttribute(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.m_attributes.setAttribute(name, value);
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.m_attributes.getAttributeNames();
    }

    @Override
    public Object removeAttribute(String name) {
        return this.m_attributes.removeAttribute(name);
    }

    private class ConfigurationListener
    implements IConfigurationListener {
        private ConfigurationListener() {
        }

        public void onConfigurationFailure(ITestResult itr) {
            TestRunner.this.m_failedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSkip(ITestResult itr) {
            TestRunner.this.m_skippedConfigurations.addResult(itr, itr.getMethod());
        }

        public void onConfigurationSuccess(ITestResult itr) {
            TestRunner.this.m_passedConfigurations.addResult(itr, itr.getMethod());
        }
    }

    private class ListenerHolder {
        private List<Class<? extends ITestNGListener>> listenerClasses;
        private Class<? extends ITestNGListenerFactory> listenerFactoryClass;

        private ListenerHolder() {
        }
    }
}

