/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailedReporter
extends TestListenerAdapter {
    public static final String TESTNG_FAILED_XML = "testng-failed.xml";
    private XmlSuite m_xmlSuite;

    public FailedReporter(XmlSuite xmlSuite) {
        this.m_xmlSuite = xmlSuite;
    }

    @Override
    public void onFinish(ITestContext context) {
        File f = new File(context.getOutputDirectory(), this.getFileName(context));
        f.delete();
        List<ITestResult> failedTests = this.getFailedTests();
        List<ITestResult> skippedTests = this.getSkippedTests();
        if (skippedTests.size() > 0 || failedTests.size() > 0) {
            HashMap<ITestNGMethod, ITestNGMethod> methodsToReRun = new HashMap<ITestNGMethod, ITestNGMethod>();
            List<ITestResult> tests = failedTests.size() > 0 ? failedTests : skippedTests;
            for (ITestResult failedTest : tests) {
                ITestNGMethod current = failedTest.getMethod();
                if (!current.isTest()) continue;
                methodsToReRun.put(current, current);
                ITestNGMethod method = failedTest.getMethod();
                if (!method.isTest()) continue;
                List<ITestNGMethod> methodsDependedUpon = MethodHelper.getMethodsDependedUpon(method, context.getAllTestMethods());
                for (ITestNGMethod m : methodsDependedUpon) {
                    if (!m.isTest()) continue;
                    methodsToReRun.put(m, m);
                }
            }
            ArrayList<ITestNGMethod> result = new ArrayList<ITestNGMethod>();
            for (ITestNGMethod m : context.getAllTestMethods()) {
                if (null == methodsToReRun.get(m)) continue;
                result.add(m);
            }
            this.generateFile(context, result);
        }
    }

    private void generateFile(ITestContext context, List<ITestNGMethod> methods) {
        XmlSuite xmlSuite = (XmlSuite)this.m_xmlSuite.clone();
        xmlSuite.setName("Failed suite [" + this.m_xmlSuite.getName() + "]");
        XmlTest xmlTest = new XmlTest(xmlSuite);
        xmlTest.setName("Failed tests");
        List<XmlClass> xmlClasses = this.createXmlClasses(methods);
        xmlTest.setXmlClasses(xmlClasses);
        Utils.writeFile(context.getOutputDirectory(), this.getFileName(context), xmlSuite.toXml());
    }

    private List<XmlClass> createXmlClasses(List<ITestNGMethod> methods) {
        ArrayList<XmlClass> result = new ArrayList<XmlClass>();
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        for (ITestNGMethod m : methods) {
            String className = m.getRealClass().getName();
            String method = m.getMethod().getName();
            ArrayList<String> methodList = (ArrayList<String>)map.get(className);
            if (null == methodList) {
                methodList = new ArrayList<String>();
                map.put(className, methodList);
            }
            methodList.add(method);
        }
        for (String className : map.keySet()) {
            List includedMethods = (List)map.get(className);
            XmlClass xmlClass = new XmlClass(className);
            xmlClass.setIncludedMethods(includedMethods);
            result.add(xmlClass);
        }
        return result;
    }

    private String getFileName(ITestContext context) {
        return TESTNG_FAILED_XML;
    }

    private static void ppp(String s) {
        System.out.println("[FailedReporter] " + s);
    }
}

