/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.thread;

import edu.emory.mathcs.util.concurrent.ThreadFactory;
import org.testng.internal.thread.ICountDown;
import org.testng.internal.thread.IExecutor;
import org.testng.internal.thread.IPooledExecutor;
import org.testng.internal.thread.IThreadFactory;
import org.testng.internal.thread.TestNGThread;
import org.testng.internal.thread.port.CountDownAdapter;
import org.testng.internal.thread.port.ExecutorAdapter;
import org.testng.internal.thread.port.PooledExecutorAdapter;

public class ThreadUtil {
    public static final String currentThreadInfo() {
        return String.valueOf(Thread.currentThread().hashCode());
    }

    public static final ICountDown createCountDown(int count) {
        return new CountDownAdapter(count);
    }

    public static final IExecutor createExecutor(int threadCount, IThreadFactory itf) {
        return new ExecutorAdapter(threadCount, itf);
    }

    public static final IPooledExecutor createPooledExecutor(int size) {
        return new PooledExecutorAdapter(size);
    }

    public static final IThreadFactory createFactory(String name) {
        return new ThreadFactoryImpl(name);
    }

    public static class ThreadFactoryImpl
    implements IThreadFactory,
    ThreadFactory {
        private String m_methodName;

        public ThreadFactoryImpl(String name) {
            this.m_methodName = name;
        }

        public Thread newThread(Runnable run) {
            return new TestNGThread(run, this.m_methodName);
        }

        public Object getThreadFactory() {
            return this;
        }
    }
}

